/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gerrit.ui;

import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.mylyn.internal.gerrit.ui.GerritConnectorUi;
import org.eclipse.mylyn.internal.tasks.core.LocalTask;
import org.eclipse.mylyn.internal.tasks.core.TaskTask;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ChangeIdHyperlinkTest {
    private TaskRepository repository;
    private GerritConnectorUi connector;

    private void checkLink(IHyperlink link) {
        Assert.assertNotNull((Object)link);
        Assert.assertNotNull((Object)link.getHyperlinkRegion());
        Assert.assertTrue((link.getHyperlinkRegion().getLength() > 0 ? 1 : 0) != 0);
    }

    private String getHyperlinkedText(String text, IHyperlink hyperlink) {
        return text.substring(hyperlink.getHyperlinkRegion().getOffset(), hyperlink.getHyperlinkRegion().getOffset() + hyperlink.getHyperlinkRegion().getLength());
    }

    @Before
    public void setUp() {
        this.connector = new GerritConnectorUi();
        this.repository = new TaskRepository("org.eclipse.mylyn.gerrit", "http://localhost");
    }

    @Test
    public void emptyText() {
        IHyperlink[] links = this.connector.findHyperlinks(this.repository, null, "", -1, 0);
        Assert.assertNull((Object)links);
    }

    @Test
    public void invalidHexPortionInTail() {
        String changeId = "Change-Id: I9a2336216f0bc1256073bff692c087cfebff8ct";
        IHyperlink[] links = this.connector.findHyperlinks(this.repository, null, changeId, -1, 0);
        Assert.assertNotNull((Object)links);
        Assert.assertEquals((long)1L, (long)links.length);
        this.checkLink(links[0]);
        Assert.assertEquals((Object)"I9a233621", (Object)this.getHyperlinkedText(changeId, links[0]));
    }

    @Test
    public void invalidHexPortionInBeginning() {
        String changeId = "Change-Id: I9az336216f0bc1256073bff692c087cfebff8ct";
        IHyperlink[] links = this.connector.findHyperlinks(this.repository, null, changeId, -1, 0);
        Assert.assertNull((Object)links);
    }

    @Test
    public void singleHyperlinkNoPadding() {
        String changeId = "Change-Id: I9a2336216f0bc1256073bff692c087cfbebff8cc";
        IHyperlink[] links = this.connector.findHyperlinks(this.repository, null, changeId, -1, 0);
        Assert.assertNotNull((Object)links);
        Assert.assertEquals((long)1L, (long)links.length);
        this.checkLink(links[0]);
        Assert.assertEquals((Object)"I9a2336216f0bc1256073bff692c087cfbebff8cc", (Object)this.getHyperlinkedText(changeId, links[0]));
    }

    @Test
    public void singleHyperlinkWithPadding() {
        String changeId = "    Change-Id: I9a2336216f0bc1256073bff692c087cfbebff8cc";
        IHyperlink[] links = this.connector.findHyperlinks(this.repository, null, changeId, -1, 0);
        Assert.assertNotNull((Object)links);
        Assert.assertEquals((long)1L, (long)links.length);
        this.checkLink(links[0]);
        Assert.assertEquals((long)15L, (long)links[0].getHyperlinkRegion().getOffset());
    }

    @Test
    public void twoHyperlinks() {
        String change1 = "Change-Id: I9a2336216f0bc1256073bff692c087cfbebff8cc";
        String change2 = "Change-Id: I9a2336216f0bc1256073bff692c087cfbebff8cf";
        IHyperlink[] links = this.connector.findHyperlinks(this.repository, null, String.valueOf(change1) + "\n" + change2, -1, 0);
        Assert.assertNotNull((Object)links);
        Assert.assertEquals((long)2L, (long)links.length);
        IHyperlink[] iHyperlinkArray = links;
        int n = links.length;
        int n2 = 0;
        while (n2 < n) {
            IHyperlink link = iHyperlinkArray[n2];
            this.checkLink(link);
            ++n2;
        }
        Assert.assertEquals((long)11L, (long)links[0].getHyperlinkRegion().getOffset());
        Assert.assertEquals((long)(change1.length() + 12), (long)links[1].getHyperlinkRegion().getOffset());
    }

    @Test
    public void shortHyperlink() {
        String changeId = "  I12345678 Iabc A01234567";
        IHyperlink[] links = this.connector.findHyperlinks(this.repository, null, changeId, -1, 0);
        Assert.assertNotNull((Object)links);
        Assert.assertEquals((long)1L, (long)links.length);
        this.checkLink(links[0]);
        Assert.assertEquals((Object)"I12345678", (Object)this.getHyperlinkedText(changeId, links[0]));
    }

    @Test
    public void shortHyperlinkLocalTask() {
        String changeId = "  I12345678 Iabc A01234567";
        IHyperlink[] links = this.connector.findHyperlinks(this.repository, (ITask)new LocalTask("1", ""), changeId, -1, 0);
        Assert.assertNotNull((Object)links);
        Assert.assertEquals((long)1L, (long)links.length);
        this.checkLink(links[0]);
        Assert.assertEquals((Object)"I12345678", (Object)this.getHyperlinkedText(changeId, links[0]));
    }

    @Test
    public void shortHyperlinkLocalTaskMatchingKey() {
        String changeId = "  I12345678 Iabc A01234567";
        TaskTask task = new TaskTask("1", "http://repository", "");
        task.setTaskKey("I12345678");
        IHyperlink[] links = this.connector.findHyperlinks(this.repository, (ITask)task, changeId, -1, 0);
        Assert.assertNull((Object)links);
    }
}

