/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gerrit.core.remote;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.mylyn.reviews.core.spi.remote.emf.AbstractRemoteEmfFactory;
import org.eclipse.mylyn.reviews.core.spi.remote.emf.RemoteEmfObserver;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

class TestRemoteObserver<P extends EObject, T, L, C>
extends RemoteEmfObserver<P, T, L, C> {
    static final int TEST_TIMEOUT = 15000;
    int updated;
    int responded;
    AbstractRemoteEmfFactory<P, T, L, ?, ?, C> factory;

    public TestRemoteObserver(AbstractRemoteEmfFactory<P, T, L, ?, ?, C> factory) {
        this.factory = factory;
    }

    public void updating() {
    }

    public void updated(boolean modified) {
        ++this.responded;
        if (modified) {
            ++this.updated;
        }
    }

    void waitForResponse() {
        this.waitForResponse(1, 1);
    }

    void waitForResponse(boolean updated) {
        this.waitForResponse(1, updated ? 1 : 0);
    }

    private void waitForResponse(int responses, int updates) {
        try {
            long delay = 0L;
            while (delay < 15000L) {
                if (this.responded >= responses && this.updated >= updates) break;
                try {
                    Thread.sleep(10L);
                    delay += 10L;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            try {
                Thread.sleep(25L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            Assert.assertThat((String)("Wrong # responses: " + this.responded + ", updated: " + this.updated), (Object)this.responded, (Matcher)Matchers.is((Object)responses));
            Assert.assertThat((String)("Wrong # updates " + this.updated), (Object)this.updated, (Matcher)Matchers.is((Object)updates));
            if (this.factory != null) {
                Assert.assertThat((Object)this.factory.getService().isActive(), (Matcher)Matchers.is((Object)false));
            }
        }
        finally {
            this.responded = 0;
            this.updated = 0;
        }
    }
}

