/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gerrit.core.remote;

import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.net.Proxy;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jgit.api.CommitCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.mylyn.commons.net.AbstractWebLocation;
import org.eclipse.mylyn.commons.net.IProxyProvider;
import org.eclipse.mylyn.commons.net.WebLocation;
import org.eclipse.mylyn.commons.net.WebUtil;
import org.eclipse.mylyn.commons.repositories.core.auth.UserCredentials;
import org.eclipse.mylyn.commons.sdk.util.CommonTestUtil;
import org.eclipse.mylyn.gerrit.tests.support.GerritFixture;
import org.eclipse.mylyn.gerrit.tests.support.GerritHarness;
import org.eclipse.mylyn.gerrit.tests.support.GerritProject;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritChange;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritClient;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritException;
import org.eclipse.mylyn.internal.gerrit.core.remote.GerritRemoteFactoryProvider;
import org.eclipse.mylyn.internal.gerrit.core.remote.TestDataLocator;
import org.eclipse.mylyn.internal.gerrit.core.remote.TestRemoteObserver;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.reviews.core.model.IRepository;
import org.eclipse.mylyn.reviews.core.model.IReview;
import org.eclipse.mylyn.reviews.core.model.IReviewItemSet;
import org.eclipse.mylyn.reviews.core.spi.remote.AbstractDataLocator;
import org.eclipse.mylyn.reviews.core.spi.remote.AbstractRemoteService;
import org.eclipse.mylyn.reviews.core.spi.remote.JobRemoteService;
import org.eclipse.mylyn.reviews.core.spi.remote.emf.RemoteEmfConsumer;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.hamcrest.Matchers;
import org.junit.Assert;

class ReviewHarness {
    private static final Pattern SHORT_ID_PATTERN = Pattern.compile("(\\d+).*", 32);
    private static final long CREATION_TIME_DELTA = 1800000L;
    private static final String DEFAULT_TEST_FILE = "testFile1.txt";
    private TestRemoteObserver<IRepository, IReview, String, Date> listener;
    private RemoteEmfConsumer<IRepository, IReview, String, GerritChange, String, Date> consumer;
    private String shortId;
    private String commitId;
    private String changeId = ReviewHarness.generateChangeId();
    private final Git git;
    private final GerritClient client;
    private GerritClient adminClient;
    private final GerritRemoteFactoryProvider provider;
    private final TaskRepository taskRepository;
    private final GerritHarness gerritHarness = GerritFixture.current().harness();

    ReviewHarness() throws Exception {
        this.git = this.gerritHarness.project().getGitProject(CommonTestUtil.PrivilegeLevel.USER);
        this.taskRepository = GerritFixture.current().singleRepository();
        this.client = this.gerritHarness.client(CommonTestUtil.PrivilegeLevel.USER);
        this.provider = new GerritRemoteFactoryProvider(this.client);
        this.provider.setService((AbstractRemoteService)new JobRemoteService());
        this.provider.setDataLocator((AbstractDataLocator)new TestDataLocator());
    }

    static String generateChangeId() throws NoSuchAlgorithmException {
        byte[] bytes = new byte[22];
        new Random().nextBytes(bytes);
        return "I" + new BigInteger(bytes).toString(16).replace("-", "").substring(0, 40);
    }

    ReviewHarness duplicate() throws Exception {
        ReviewHarness reviewHarness = new ReviewHarness();
        reviewHarness.changeId = this.changeId;
        return reviewHarness;
    }

    void retrieve() {
        this.consumer.retrieve(false);
        this.listener.waitForResponse();
    }

    void init() throws Exception {
        this.init("HEAD:refs/for/master", CommonTestUtil.PrivilegeLevel.USER, DEFAULT_TEST_FILE, true);
    }

    void init(String refSpec, CommonTestUtil.PrivilegeLevel privilegeLevel, String fileName, boolean wait) throws Exception {
        this.provider.open();
        Assert.assertThat((Object)this.getRepository().getReviews().size(), (org.hamcrest.Matcher)Matchers.is((Object)0));
        this.pushFileToReview(refSpec, privilegeLevel, fileName);
        this.listener = new TestRemoteObserver(this.provider.getReviewFactory());
        this.consumer = this.provider.getReviewFactory().getConsumerForRemoteKey((EObject)this.getRepository(), (Object)this.getShortId());
        this.consumer.setAsynchronous(false);
        this.consumer.addObserver(this.listener);
        if (!wait) {
            return;
        }
        this.retrieve();
        Assert.assertThat((Object)this.getRepository().getReviews().size(), (org.hamcrest.Matcher)Matchers.is((Object)1));
        IReview review = (IReview)this.getRepository().getReviews().get(0);
        IReview reviewDirect = (IReview)this.provider.open((Object)this.getShortId());
        Assert.assertThat((Object)review, (org.hamcrest.Matcher)Matchers.sameInstance((Object)reviewDirect));
        Assert.assertThat((Object)review, (org.hamcrest.Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)review.getId(), (org.hamcrest.Matcher)Matchers.is((Object)this.getShortId()));
        Assert.assertThat((Object)review.getKey(), (org.hamcrest.Matcher)Matchers.is((Object)this.changeId));
        Assert.assertThat((Object)review.getSubject(), (org.hamcrest.Matcher)Matchers.is((Object)("Test Change " + this.changeId)));
        Assert.assertThat((Object)review.getOwner().getDisplayName(), (org.hamcrest.Matcher)Matchers.is((Object)"tests"));
        this.assertIsRecent(review.getCreationDate());
    }

    public void pushFileToReview(String refSpec, CommonTestUtil.PrivilegeLevel privilegeLevel) throws Exception {
        this.pushFileToReview(refSpec, privilegeLevel, DEFAULT_TEST_FILE);
    }

    public void pushFileToReview(String refSpec, CommonTestUtil.PrivilegeLevel privilegeLevel, String fileName) throws Exception {
        CommitCommand command = this.createCommitCommand(this.changeId);
        this.addFile(fileName);
        GerritProject.CommitResult result = this.commitAndPush(command, refSpec, privilegeLevel);
        this.shortId = ReviewHarness.parseShortId(result.push.getMessages());
        this.commitId = result.commit.getId().toString();
        Assert.assertThat((String)("Bad Push: " + result.push.getMessages()), (Object)this.getShortId().length(), (org.hamcrest.Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
    }

    static String parseShortId(String messages) {
        String tail = StringUtils.trimToEmpty((String)StringUtils.substringAfterLast((String)messages, (String)"/"));
        Matcher m = SHORT_ID_PATTERN.matcher(tail);
        if (m.matches()) {
            return m.group(1);
        }
        Assert.fail((String)("ShortId could not be parsed from \"" + tail + "\". Messages was: " + messages));
        return null;
    }

    void assertIsRecent(Date date) {
        long timeDelta = System.currentTimeMillis() - date.getTime();
        Assert.assertThat((String)("Creation delta out of range : " + timeDelta + " ms"), (Object)(timeDelta > -1800000L && timeDelta < 1800000L ? 1 : 0), (org.hamcrest.Matcher)Matchers.is((Object)true));
    }

    public void dispose() throws GerritException {
        if (this.listener != null) {
            this.consumer.removeObserver(this.listener);
        }
        if (this.consumer != null) {
            this.consumer.release();
        }
        this.gerritHarness.dispose();
    }

    CommitCommand createCommitCommand() {
        return this.createCommitCommand(this.changeId).setAmend(true);
    }

    CommitCommand createCommitCommand(String changeId) {
        return this.git.commit().setAll(true).setMessage("Test Change " + changeId + "\n\nChange-Id: " + changeId);
    }

    void addFile(String fileName) throws Exception {
        this.gerritHarness.project().addFile(fileName);
    }

    void addFile(String fileName, String text) throws Exception {
        this.gerritHarness.project().addFile(fileName, text);
    }

    void addFile(String fileName, File file) throws Exception {
        this.gerritHarness.project().addFile(fileName, file);
    }

    void removeFile(String fileName) throws Exception {
        this.gerritHarness.project().removeFile(fileName);
    }

    GerritProject.CommitResult commitAndPush(CommitCommand command) throws Exception {
        return this.gerritHarness.project().commitAndPush(command);
    }

    GerritProject.CommitResult commitAndPush(CommitCommand command, String refSpec, CommonTestUtil.PrivilegeLevel privilegeLevel) throws Exception {
        return this.gerritHarness.project().commitAndPush(command, refSpec, privilegeLevel);
    }

    void checkoutPatchSet(int number) throws Exception {
        IReviewItemSet patchSet = (IReviewItemSet)this.getReview().getSets().get(0);
        ObjectId ref = this.git.getRepository().resolve(patchSet.getRevision());
        RevCommit targetCommit = this.parseCommit(ref);
        Assert.assertThat((Object)targetCommit.toString(), (org.hamcrest.Matcher)Matchers.is((Object)this.commitId));
        this.git.checkout().setCreateBranch(true).setName("change/" + this.getReview().getId() + "/" + number).setStartPoint(targetCommit).call();
    }

    private RevCommit parseCommit(ObjectId ref) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (RevWalk walker = new RevWalk(this.git.getRepository());){
            return walker.parseCommit((AnyObjectId)ref);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    GerritClient getClient() {
        return this.client;
    }

    GerritClient getAdminClient() {
        if (this.adminClient == null) {
            UserCredentials credentials = GerritFixture.current().getCredentials(CommonTestUtil.PrivilegeLevel.ADMIN);
            WebLocation location = new WebLocation(GerritFixture.current().getRepositoryUrl(), credentials.getUserName(), credentials.getPassword(), new IProxyProvider(){

                public Proxy getProxyForHost(String host, String proxyType) {
                    return WebUtil.getProxyForUrl((String)GerritFixture.current().getRepositoryUrl());
                }
            });
            TaskRepository repository = TasksUiPlugin.getRepositoryManager().getRepository(GerritFixture.current().getRepositoryUrl());
            this.adminClient = GerritClient.create((TaskRepository)repository, (AbstractWebLocation)location);
        }
        return this.adminClient;
    }

    IReview getReview() {
        return (IReview)this.consumer.getModelObject();
    }

    IRepository getRepository() {
        return (IRepository)this.provider.getRoot();
    }

    public TaskRepository getTaskRepository() {
        return this.taskRepository;
    }

    String getShortId() {
        return this.shortId;
    }

    GerritRemoteFactoryProvider getProvider() {
        return this.provider;
    }
}

