/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gerrit.core.remote;

import com.google.gerrit.common.data.PatchSetDetail;
import com.google.gerrit.reviewdb.Change;
import com.google.gerrit.reviewdb.Patch;
import com.google.gerrit.reviewdb.PatchSet;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jgit.api.CommitCommand;
import org.eclipse.mylyn.commons.sdk.util.CommonTestUtil;
import org.eclipse.mylyn.gerrit.tests.support.GerritFixture;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritChange;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritClient;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritException;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritVersion;
import org.eclipse.mylyn.internal.gerrit.core.client.PatchSetContent;
import org.eclipse.mylyn.internal.gerrit.core.client.compat.PatchScriptX;
import org.eclipse.mylyn.internal.gerrit.core.client.rest.CommentInput;
import org.eclipse.mylyn.internal.gerrit.core.remote.GerritRemoteTest;
import org.eclipse.mylyn.internal.gerrit.core.remote.TestRemoteObserverConsumer;
import org.eclipse.mylyn.reviews.core.model.IComment;
import org.eclipse.mylyn.reviews.core.model.IFileItem;
import org.eclipse.mylyn.reviews.core.model.IFileVersion;
import org.eclipse.mylyn.reviews.core.model.IReviewItem;
import org.eclipse.mylyn.reviews.core.model.IReviewItemSet;
import org.eclipse.mylyn.reviews.internal.core.model.FileVersion;
import org.eclipse.osgi.util.NLS;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.osgi.framework.Version;

public class PatchSetRemoteFactoryTest
extends GerritRemoteTest {
    @Test
    public void testPatchSetFiles() throws Exception {
        if (!this.canMakeMultipleCommits()) {
            return;
        }
        CommitCommand command2 = this.reviewHarness.createCommitCommand();
        this.reviewHarness.addFile("testFile2.txt");
        this.reviewHarness.addFile("testFile3.txt");
        this.reviewHarness.commitAndPush(command2);
        CommitCommand command3 = this.reviewHarness.createCommitCommand();
        this.reviewHarness.addFile("testFile2.txt", "testmod");
        this.reviewHarness.addFile("testFile4.txt");
        this.reviewHarness.addFile("testFile5.txt");
        this.reviewHarness.commitAndPush(command3);
        this.reviewHarness.retrieve();
        Assert.assertThat((Object)this.getReview().getSets().size(), (Matcher)Matchers.is((Object)3));
        IReviewItemSet testPatchSet = (IReviewItemSet)this.getReview().getSets().get(2);
        PatchSetDetail detail = this.retrievePatchSetDetail("3");
        Assert.assertThat((Object)detail.getInfo().getKey().get(), (Matcher)Matchers.is((Object)3));
        List fileItems = testPatchSet.getItems();
        Assert.assertThat((Object)fileItems.size(), (Matcher)Matchers.is((Object)0));
        this.retrievePatchSetContents(testPatchSet);
        Assert.assertThat((Object)fileItems.size(), (Matcher)Matchers.is((Object)6));
        for (IReviewItem fileItem : fileItems) {
            Assert.assertThat((Object)fileItem, (Matcher)Matchers.instanceOf(IFileItem.class));
            Assert.assertThat((Object)fileItem.getAddedBy().getDisplayName(), (Matcher)Matchers.is((Object)"tests"));
            Assert.assertThat((Object)fileItem.getCommittedBy().getDisplayName(), (Matcher)Matchers.is((Object)"tests"));
        }
        IFileItem fileItem0 = (IFileItem)fileItems.get(0);
        Assert.assertThat((Object)fileItem0.getName(), (Matcher)Matchers.is((Object)"/COMMIT_MSG"));
        IFileItem fileItem1 = (IFileItem)fileItems.get(1);
        Assert.assertThat((Object)fileItem1.getName(), (Matcher)Matchers.is((Object)"testFile1.txt"));
        IFileItem fileItem2 = (IFileItem)fileItems.get(2);
        Assert.assertThat((Object)fileItem2.getName(), (Matcher)Matchers.is((Object)"testFile2.txt"));
        IFileVersion base2 = fileItem2.getBase();
        Assert.assertThat((Object)base2.getAddedBy(), (Matcher)Matchers.nullValue());
        Assert.assertThat((Object)base2.getCommittedBy(), (Matcher)Matchers.nullValue());
        Assert.assertThat((Object)base2.getContent(), (Matcher)Matchers.is((Object)""));
        Assert.assertThat((Object)base2.getId(), (Matcher)Matchers.is((Object)("base-" + this.reviewHarness.getShortId() + ",3,testFile2.txt")));
        Assert.assertThat((Object)base2.getName(), (Matcher)Matchers.is((Object)"testFile2.txt"));
        Assert.assertThat((Object)base2.getPath(), (Matcher)Matchers.nullValue());
        Assert.assertThat((Object)base2.getReference(), (Matcher)Matchers.nullValue());
        Assert.assertThat((Object)base2.getDescription(), (Matcher)Matchers.is((Object)"Base"));
        IFileVersion target2 = fileItem2.getTarget();
        Assert.assertThat((Object)target2.getAddedBy().getDisplayName(), (Matcher)Matchers.is((Object)"tests"));
        Assert.assertThat((Object)target2.getCommittedBy().getDisplayName(), (Matcher)Matchers.is((Object)"tests"));
        Assert.assertThat((Object)target2.getContent(), (Matcher)Matchers.is((Object)"testmod"));
        Assert.assertThat((Object)target2.getId(), (Matcher)Matchers.is((Object)(String.valueOf(this.reviewHarness.getShortId()) + ",3,testFile2.txt")));
        Assert.assertThat((Object)target2.getName(), (Matcher)Matchers.is((Object)"testFile2.txt"));
        Assert.assertThat((Object)target2.getPath(), (Matcher)Matchers.is((Object)"testFile2.txt"));
        Assert.assertThat((Object)target2.getReference(), (Matcher)Matchers.nullValue());
        Assert.assertThat((Object)target2.getDescription(), (Matcher)Matchers.is((Object)"Patch Set 3"));
    }

    @Test
    public void testFetchBinaryContent() throws Exception {
        if (!this.canMakeMultipleCommits()) {
            return;
        }
        this.fetchBinaryContent("test.png", "testdata/binary/gerrit.png");
    }

    @Test
    public void testFetchZippedBinaryContent() throws Exception {
        if (!this.canMakeMultipleCommits()) {
            return;
        }
        this.fetchBinaryContent("test.gif", "testdata/binary/gerrit.gif");
    }

    private void fetchBinaryContent(String fileName, String path) throws Exception {
        byte[] fileContent = this.commitFile(fileName, path);
        Assert.assertThat((Object)this.getReview().getSets().size(), (Matcher)Matchers.is((Object)2));
        PatchSetDetail detail = this.retrievePatchSetDetail(Integer.toString(2));
        Assert.assertThat((Object)detail.getInfo().getKey().get(), (Matcher)Matchers.is((Object)2));
        IReviewItemSet patchSet = (IReviewItemSet)this.getReview().getSets().get(1);
        List fileItems = patchSet.getItems();
        Assert.assertThat((Object)fileItems.size(), (Matcher)Matchers.is((Object)0));
        this.retrievePatchSetContents(patchSet);
        Assert.assertThat((Object)fileItems.size(), (Matcher)Matchers.is((Object)3));
        IFileItem fileItem = (IFileItem)fileItems.get(1);
        Assert.assertThat((Object)fileItem.getName(), (Matcher)Matchers.is((Object)fileName));
        Assert.assertThat((Object)fileItem.getBase().getContent(), (Matcher)Matchers.nullValue());
        Assert.assertThat((Object)fileItem.getBase().getBinaryContent(), (Matcher)Matchers.nullValue());
        Assert.assertThat((Object)fileItem.getTarget().getContent(), (Matcher)Matchers.nullValue());
        Assert.assertThat((Object)fileItem.getTarget().getBinaryContent(), (Matcher)Matchers.is((Object)fileContent));
    }

    @Test
    public void testUnzipBinaryContent() throws Exception {
        File imageFile = CommonTestUtil.getFile((Object)((Object)this), (String)"testdata/binary/gerrit.png");
        byte[] zippedBytes = this.zip(imageFile);
        Assert.assertThat((Object)GerritClient.isZippedContent((byte[])zippedBytes), (Matcher)Matchers.is((Object)true));
        byte[] unzippedBytes = GerritClient.unzip((byte[])zippedBytes);
        byte[] imageBytes = FileUtils.readFileToByteArray((File)imageFile);
        Assert.assertThat((Object)GerritClient.isZippedContent((byte[])imageBytes), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)unzippedBytes, (Matcher)Matchers.is((Object)imageBytes));
    }

    private byte[] zip(File file) throws IOException, FileNotFoundException {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        ZipOutputStream out = new ZipOutputStream(bytes);
        out.putNextEntry(new ZipEntry(file.getName()));
        IOUtils.copy((InputStream)new FileInputStream(file), (OutputStream)out);
        out.closeEntry();
        return bytes.toByteArray();
    }

    @Test
    public void testCompareBinaryContent() throws Exception {
        if (!this.canMakeMultipleCommits()) {
            return;
        }
        String fileName = "test.png";
        byte[] fileContent2 = this.commitFile(fileName, "testdata/binary/gerrit.png");
        byte[] fileContent3 = this.commitFile(fileName, "testdata/binary/gerrit2.png");
        this.removeFile(fileName);
        PatchSetDetail detail1 = this.retrievePatchSetDetail("1");
        PatchSetDetail detail2 = this.retrievePatchSetDetail("2");
        PatchSetDetail detail3 = this.retrievePatchSetDetail("3");
        PatchSetDetail detail4 = this.retrievePatchSetDetail("4");
        PatchScriptX patchScript = this.loadPatchSetContent(fileName, detail2, detail3);
        this.assertPatchContent(patchScript, (Matcher<byte[]>)Matchers.equalTo((Object)fileContent2), (Matcher<byte[]>)Matchers.equalTo((Object)fileContent3));
        patchScript = this.loadPatchSetContent(fileName, detail3, detail2);
        this.assertPatchContent(patchScript, (Matcher<byte[]>)Matchers.equalTo((Object)fileContent3), (Matcher<byte[]>)Matchers.equalTo((Object)fileContent2));
        patchScript = this.loadPatchSetContent(fileName, detail2, detail4);
        if (GerritVersion.isVersion2112OrLater((Version)GerritFixture.current().getGerritVersion())) {
            this.assertPatchContent(patchScript, (Matcher<byte[]>)Matchers.equalTo((Object)fileContent2), (Matcher<byte[]>)Matchers.nullValue(byte[].class));
        } else {
            Assert.assertThat((Object)patchScript, (Matcher)Matchers.nullValue());
        }
        patchScript = this.loadPatchSetContent(fileName, detail3, detail1);
        if (GerritVersion.isVersion2112OrLater((Version)GerritFixture.current().getGerritVersion())) {
            this.assertPatchContent(patchScript, (Matcher<byte[]>)Matchers.equalTo((Object)fileContent3), (Matcher<byte[]>)Matchers.nullValue(byte[].class));
        } else {
            Assert.assertThat((Object)patchScript, (Matcher)Matchers.nullValue());
        }
        patchScript = this.loadPatchSetContent(fileName, detail1, detail2);
        this.assertPatchContent(patchScript, PatchSetRemoteFactoryTest.empty(), (Matcher<byte[]>)Matchers.equalTo((Object)fileContent2));
        patchScript = this.loadPatchSetContent(fileName, detail4, detail3);
        this.assertPatchContent(patchScript, PatchSetRemoteFactoryTest.empty(), (Matcher<byte[]>)Matchers.equalTo((Object)fileContent3));
    }

    @Test
    public void testCompareRenamedImage() throws Exception {
        if (!this.canMakeMultipleCommits()) {
            return;
        }
        String fileName = "test.png";
        String newFileName = "renamed-" + fileName;
        String path = "testdata/binary/gerrit.png";
        byte[] fileContent = this.commitAndRenameFile(fileName, newFileName, path);
        PatchSetDetail detail2 = this.retrievePatchSetDetail("2");
        PatchSetDetail detail3 = this.retrievePatchSetDetail("3");
        PatchScriptX patchScript = this.loadPatchSetContent(newFileName, detail2, detail3);
        this.assertPatchContent(patchScript, PatchSetRemoteFactoryTest.empty(), (Matcher<byte[]>)Matchers.equalTo((Object)fileContent));
    }

    private PatchScriptX loadPatchSetContent(String fileName, PatchSetDetail base, PatchSetDetail target) throws GerritException {
        PatchSetContent content = new PatchSetContent(base.getPatchSet(), target.getPatchSet());
        this.reviewHarness.getClient().loadPatchSetContent(content, (IProgressMonitor)new NullProgressMonitor());
        return content.getPatchScript(this.createPatchKey(fileName, target.getInfo().getKey().get()));
    }

    private Patch.Key createPatchKey(String fileName, int patchSet) throws GerritException {
        Change.Id changeId = new Change.Id(this.reviewHarness.getClient().id(this.reviewHarness.getShortId()));
        PatchSet.Id patchSetId = new PatchSet.Id(changeId, patchSet);
        return new Patch.Key(patchSetId, fileName);
    }

    private void assertPatchContent(PatchScriptX patchScript, Matcher<byte[]> base, Matcher<byte[]> target) {
        Assert.assertThat((Object)patchScript.getBinaryA(), (Matcher)Matchers.is(base));
        Assert.assertThat((Object)patchScript.getBinaryB(), (Matcher)Matchers.is(target));
    }

    private static Matcher<byte[]> empty() {
        return Matchers.nullValue(byte[].class);
    }

    private byte[] commitFile(String fileName, String path) throws Exception {
        File file = CommonTestUtil.getFile((Object)((Object)this), (String)path);
        CommitCommand command = this.reviewHarness.createCommitCommand();
        this.reviewHarness.addFile(fileName, file);
        this.reviewHarness.commitAndPush(command);
        this.reviewHarness.retrieve();
        return FileUtils.readFileToByteArray((File)file);
    }

    private void removeFile(String fileName) throws Exception {
        CommitCommand command = this.reviewHarness.createCommitCommand();
        this.reviewHarness.removeFile(fileName);
        this.reviewHarness.commitAndPush(command);
        this.reviewHarness.retrieve();
    }

    private byte[] commitAndRenameFile(String fileName, String newFileName, String path) throws Exception, IOException {
        byte[] fileContent = this.commitFile(fileName, path);
        File file = CommonTestUtil.getFile((Object)((Object)this), (String)path);
        CommitCommand command = this.reviewHarness.createCommitCommand();
        this.reviewHarness.removeFile(fileName);
        this.reviewHarness.addFile(newFileName, file);
        this.reviewHarness.commitAndPush(command);
        this.reviewHarness.retrieve();
        return fileContent;
    }

    @Test
    public void testPatchSetComments() throws Exception {
        if (!this.canMakeMultipleCommits()) {
            return;
        }
        TestRemoteObserverConsumer<IReviewItemSet, List<IFileItem>, String, PatchSetContent, String, Long> patchSetObserver = this.setUpAddComments();
        IReviewItemSet testPatchSet = (IReviewItemSet)this.getReview().getSets().get(1);
        IFileItem commentFile = (IFileItem)testPatchSet.getItems().get(1);
        String id = commentFile.getReference();
        CommentInput commentInput = this.reviewHarness.getClient().saveDraft(Patch.Key.parse((String)id), "Line 2 Comment", 2, (short)1, null, null, (IProgressMonitor)new NullProgressMonitor());
        patchSetObserver.retrieve(false);
        patchSetObserver.waitForResponse();
        commentFile = (IFileItem)testPatchSet.getItems().get(1);
        List allComments = commentFile.getAllComments();
        Assert.assertThat((Object)allComments.size(), (Matcher)Matchers.is((Object)1));
        IComment fileComment = (IComment)allComments.get(0);
        Assert.assertThat((String)"saveDraft returned wrong comment id", (Object)fileComment.getId(), (Matcher)Matchers.is((Object)commentInput.getId()));
        Assert.assertThat((Object)fileComment, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)fileComment.isDraft(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)fileComment.getAuthor().getDisplayName(), (Matcher)Matchers.is((Object)"tests"));
        Assert.assertThat((Object)fileComment.getDescription(), (Matcher)Matchers.is((Object)"Line 2 Comment"));
        this.reviewHarness.getClient().deleteDraft(Patch.Key.parse((String)id), fileComment.getId(), (IProgressMonitor)new NullProgressMonitor());
        commentFile = (IFileItem)testPatchSet.getItems().get(0);
        allComments = commentFile.getAllComments();
        Assert.assertThat((Object)allComments.size(), (Matcher)Matchers.is((Object)0));
        this.reviewHarness.getClient().saveDraft(Patch.Key.parse((String)id), "Line 2 Comment", 2, (short)1, null, null, (IProgressMonitor)new NullProgressMonitor());
        patchSetObserver.retrieve(false);
        patchSetObserver.waitForResponse();
        commentFile = (IFileItem)testPatchSet.getItems().get(1);
        allComments = commentFile.getAllComments();
        fileComment = (IComment)allComments.get(0);
        Assert.assertThat((Object)fileComment, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)fileComment.isDraft(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)fileComment.getAuthor().getDisplayName(), (Matcher)Matchers.is((Object)"tests"));
        Assert.assertThat((Object)fileComment.getDescription(), (Matcher)Matchers.is((Object)"Line 2 Comment"));
        this.reviewHarness.getClient().saveDraft(Patch.Key.parse((String)id), "Line 2 Comment modified", 2, (short)1, null, fileComment.getId(), (IProgressMonitor)new NullProgressMonitor());
        patchSetObserver.retrieve(false);
        patchSetObserver.waitForResponse();
        commentFile = (IFileItem)testPatchSet.getItems().get(1);
        allComments = commentFile.getAllComments();
        Assert.assertThat((Object)allComments.size(), (Matcher)Matchers.is((Object)1));
        fileComment = (IComment)allComments.get(0);
        Assert.assertThat((Object)fileComment, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)fileComment.isDraft(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)fileComment.getAuthor().getDisplayName(), (Matcher)Matchers.is((Object)"tests"));
        Assert.assertThat((Object)fileComment.getDescription(), (Matcher)Matchers.is((Object)"Line 2 Comment modified"));
        this.reviewHarness.getClient().publishComments(this.reviewHarness.getShortId(), 2, "Submit Comments", Collections.emptySet(), (IProgressMonitor)new NullProgressMonitor());
        patchSetObserver.retrieve(false);
        patchSetObserver.waitForResponse();
        allComments = commentFile.getAllComments();
        Assert.assertThat((Object)allComments.size(), (Matcher)Matchers.is((Object)1));
        fileComment = (IComment)allComments.get(0);
        Assert.assertThat((Object)fileComment, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)fileComment.isDraft(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)fileComment.getAuthor().getDisplayName(), (Matcher)Matchers.is((Object)"tests"));
        Assert.assertThat((Object)fileComment.getDescription(), (Matcher)Matchers.is((Object)"Line 2 Comment modified"));
    }

    @Test
    public void testBaseComment() throws Exception {
        if (!this.canMakeMultipleCommits()) {
            return;
        }
        TestRemoteObserverConsumer<IReviewItemSet, List<IFileItem>, String, PatchSetContent, String, Long> patchSetObserver = this.setUpAddComments();
        IFileItem commentFile = (IFileItem)((IReviewItemSet)this.getReview().getSets().get(1)).getItems().get(1);
        String id = commentFile.getReference();
        this.reviewHarness.getClient().saveDraft(Patch.Key.parse((String)id), "base comment", 1, (short)0, null, null, (IProgressMonitor)new NullProgressMonitor());
        patchSetObserver.retrieve(false);
        patchSetObserver.waitForResponse();
        this.assertFileComments(commentFile, 1, true);
        this.reviewHarness.getClient().publishComments(this.reviewHarness.getShortId(), 2, "Submit Comments", Collections.emptySet(), (IProgressMonitor)new NullProgressMonitor());
        patchSetObserver.retrieve(false);
        patchSetObserver.waitForResponse();
        this.assertFileComments(commentFile, 1, false);
    }

    @Test
    public void testBaseAndPatchSetComments() throws Exception {
        if (!this.canMakeMultipleCommits()) {
            return;
        }
        TestRemoteObserverConsumer<IReviewItemSet, List<IFileItem>, String, PatchSetContent, String, Long> patchSetObserver = this.setUpAddComments();
        IFileItem commentFile = (IFileItem)((IReviewItemSet)this.getReview().getSets().get(1)).getItems().get(1);
        String id = commentFile.getReference();
        this.reviewHarness.getClient().saveDraft(Patch.Key.parse((String)id), "base comment", 1, (short)0, null, null, (IProgressMonitor)new NullProgressMonitor());
        patchSetObserver.retrieve(false);
        patchSetObserver.waitForResponse();
        this.reviewHarness.getClient().saveDraft(Patch.Key.parse((String)id), "another comment", 1, (short)1, null, null, (IProgressMonitor)new NullProgressMonitor());
        patchSetObserver.retrieve(false);
        patchSetObserver.waitForResponse();
        this.assertFileComments(commentFile, 2, true);
        this.reviewHarness.getClient().publishComments(this.reviewHarness.getShortId(), 2, "Submit Comments", Collections.emptySet(), (IProgressMonitor)new NullProgressMonitor());
        patchSetObserver.retrieve(false);
        patchSetObserver.waitForResponse();
        this.assertFileComments(commentFile, 2, false);
    }

    private TestRemoteObserverConsumer<IReviewItemSet, List<IFileItem>, String, PatchSetContent, String, Long> setUpAddComments() throws Exception {
        CommitCommand command2 = this.reviewHarness.createCommitCommand();
        this.reviewHarness.addFile("testComments.txt", "line1\nline2\nline3\nline4\nline5\nline6\nline7\n");
        this.reviewHarness.commitAndPush(command2);
        this.reviewHarness.retrieve();
        PatchSetDetail detail = this.retrievePatchSetDetail("2");
        Assert.assertThat((Object)detail.getInfo().getKey().get(), (Matcher)Matchers.is((Object)2));
        IReviewItemSet testPatchSet = (IReviewItemSet)this.getReview().getSets().get(1);
        TestRemoteObserverConsumer<IReviewItemSet, List<IFileItem>, String, PatchSetContent, String, Long> patchSetObserver = this.retrievePatchSetContents(testPatchSet);
        IFileItem commentFile = (IFileItem)testPatchSet.getItems().get(1);
        Assert.assertThat((Object)commentFile.getName(), (Matcher)Matchers.is((Object)"testComments.txt"));
        Assert.assertThat((Object)commentFile.getAllComments().size(), (Matcher)Matchers.is((Object)0));
        return patchSetObserver;
    }

    private void assertFileComments(IFileItem commentFile, int size, boolean isDraft) {
        List allComments = commentFile.getAllComments();
        PatchSetRemoteFactoryTest.assertEquals((int)size, (int)allComments.size());
        this.assertRevisionComment((IComment)allComments.get(0), "Base", isDraft, "base comment");
        if (size > 1) {
            this.assertRevisionComment((IComment)allComments.get(1), "Patch Set 2", isDraft, "another comment");
        }
    }

    private void assertRevisionComment(IComment fileComment, String revision, boolean isDraft, String message) {
        PatchSetRemoteFactoryTest.assertNotNull((Object)fileComment);
        PatchSetRemoteFactoryTest.assertEquals((boolean)isDraft, (boolean)fileComment.isDraft());
        PatchSetRemoteFactoryTest.assertEquals((String)"tests", (String)fileComment.getAuthor().getDisplayName());
        PatchSetRemoteFactoryTest.assertEquals((String)message, (String)fileComment.getDescription());
        PatchSetRemoteFactoryTest.assertEquals((String)revision, (String)((FileVersion)fileComment.getItem()).getDescription());
    }

    @Test
    public void testLoadPatchSet() throws Exception {
        GerritChange change = this.reviewHarness.getClient().getChange(this.reviewHarness.getShortId(), (IProgressMonitor)new NullProgressMonitor());
        List details = change.getPatchSetDetails();
        Assert.assertThat((Object)details, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)details.size(), (Matcher)Matchers.is((Object)1));
        PatchSetDetail detail = (PatchSetDetail)details.get(0);
        PatchSetContent content = new PatchSetContent(null, detail);
        Patch.Key commitMsgPatchKey = this.createPatchKey("/COMMIT_MSG", 1);
        Patch.Key testFilePatchKey = this.createPatchKey("testFile1.txt", 1);
        Assert.assertThat((Object)content.getTargetDetail(), (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)content.getPatchScript(commitMsgPatchKey), (Matcher)Matchers.nullValue());
        Assert.assertThat((Object)content.getPatchScript(testFilePatchKey), (Matcher)Matchers.nullValue());
        this.reviewHarness.getClient().loadPatchSetContent(content, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertThat((Object)content.getPatchScript(commitMsgPatchKey), (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)content.getPatchScript(testFilePatchKey), (Matcher)Matchers.notNullValue());
    }

    private PatchSetDetail retrievePatchSetDetail(String patchSetId) {
        TestRemoteObserverConsumer itemSetObserver = TestRemoteObserverConsumer.retrieveForLocalKey(this.reviewHarness.getProvider().getReviewItemSetFactory(), this.getReview(), patchSetId, false);
        PatchSetDetail detail = (PatchSetDetail)itemSetObserver.getRemoteObject();
        PatchSetRemoteFactoryTest.assertNotNull((String)NLS.bind((String)"Failed to retrieve PatchSetDetail {0} for {1}", (Object)patchSetId, (Object)this.getReview().getId()), (Object)detail);
        return detail;
    }

    private TestRemoteObserverConsumer<IReviewItemSet, List<IFileItem>, String, PatchSetContent, String, Long> retrievePatchSetContents(IReviewItemSet patchSet) {
        return TestRemoteObserverConsumer.retrieveForRemoteKey(this.reviewHarness.getProvider().getReviewItemSetContentFactory(), patchSet, patchSet.getId(), true);
    }
}

