/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gerrit.core.remote;

import com.google.common.collect.ImmutableList;
import com.google.gerrit.common.data.PatchSetDetail;
import com.google.gerrit.reviewdb.Change;
import com.google.gerrit.reviewdb.PatchSet;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jgit.api.CommitCommand;
import org.eclipse.mylyn.commons.sdk.util.CommonTestUtil;
import org.eclipse.mylyn.gerrit.tests.support.GerritFixture;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritException;
import org.eclipse.mylyn.internal.gerrit.core.client.compat.ChangeDetailX;
import org.eclipse.mylyn.internal.gerrit.core.client.compat.PatchSetPublishDetailX;
import org.eclipse.mylyn.internal.gerrit.core.remote.ReviewHarness;
import org.eclipse.mylyn.internal.gerrit.core.remote.TestRemoteObserverConsumer;
import org.eclipse.mylyn.reviews.core.model.IReviewItemSet;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PatchSetDetailRemoteFactoryTest
extends TestCase {
    private static final String NON_DRAFT_BRANCH = "HEAD:refs/for/master";
    private static final String DRAFT_BRANCH = "HEAD:refs/drafts/master";
    private ReviewHarness reviewHarness;

    @Before
    public void setUp() throws Exception {
        this.reviewHarness = new ReviewHarness();
        this.reviewHarness.init(DRAFT_BRANCH, CommonTestUtil.PrivilegeLevel.ADMIN, "testFile1.txt", false);
    }

    @After
    public void tearDown() throws Exception {
        this.reviewHarness.dispose();
    }

    @Test
    public void testUserHasNoAccessToAdminDraft() throws Exception {
        this.createPatchSet(NON_DRAFT_BRANCH, CommonTestUtil.PrivilegeLevel.ADMIN, (List<String>)ImmutableList.of((Object)"testFile2.txt", (Object)"testFile3.txt"));
        this.reviewHarness.retrieve();
        Assert.assertThat((Object)this.reviewHarness.getReview().getSets().size(), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)((IReviewItemSet)this.reviewHarness.getReview().getSets().get(0)).getId(), (Matcher)Matchers.is((Object)"2"));
        PatchSetDetailRemoteFactoryTest.assertNull((Object)this.retrievePatchSetDetail("1"));
        PatchSetDetail detail = this.retrievePatchSetDetail("2");
        Assert.assertThat((Object)detail.getInfo().getKey().get(), (Matcher)Matchers.is((Object)2));
    }

    @Test
    public void testUserHasAccessToAdminDraft() throws Exception {
        this.createPatchSet(NON_DRAFT_BRANCH, CommonTestUtil.PrivilegeLevel.ADMIN, (List<String>)ImmutableList.of((Object)"testFile2.txt", (Object)"testFile3.txt"));
        this.reviewHarness.getClient().addReviewers(this.reviewHarness.getShortId(), (List)ImmutableList.of((Object)GerritFixture.current().getCredentials(CommonTestUtil.PrivilegeLevel.USER).getUserName()), (IProgressMonitor)new NullProgressMonitor());
        this.reviewHarness.retrieve();
        Assert.assertThat((Object)this.reviewHarness.getReview().getSets().size(), (Matcher)Matchers.is((Object)2));
        Assert.assertThat((Object)((IReviewItemSet)this.reviewHarness.getReview().getSets().get(0)).getId(), (Matcher)Matchers.is((Object)"1"));
        Assert.assertThat((Object)((IReviewItemSet)this.reviewHarness.getReview().getSets().get(1)).getId(), (Matcher)Matchers.is((Object)"2"));
        PatchSetDetail detail = this.retrievePatchSetDetail("1");
        Assert.assertThat((Object)detail.getInfo().getKey().get(), (Matcher)Matchers.is((Object)1));
        detail = this.retrievePatchSetDetail("2");
        Assert.assertThat((Object)detail.getInfo().getKey().get(), (Matcher)Matchers.is((Object)2));
    }

    @Test
    public void testGetPatchSetPublishDetailOfDraftIffAdmin() throws Exception {
        PatchSetPublishDetailX patchSetDetail;
        int reviewId = Integer.parseInt(this.reviewHarness.getShortId());
        PatchSet.Id id = new PatchSet.Id(new Change.Id(reviewId), 1);
        try {
            patchSetDetail = this.reviewHarness.getClient().getPatchSetPublishDetail(id, (IProgressMonitor)new NullProgressMonitor());
            PatchSetDetailRemoteFactoryTest.fail((String)"Expected Gerrit Exception");
        }
        catch (GerritException gerritException) {
            // empty catch block
        }
        patchSetDetail = this.reviewHarness.getAdminClient().getPatchSetPublishDetail(id, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertThat((Object)patchSetDetail, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)patchSetDetail.getChange().getStatus(), (Matcher)Matchers.is((Object)Change.Status.NEW));
    }

    @Test
    public void testGetChangeDetailOfDraftIffAdmin() throws Exception {
        ChangeDetailX changeDetail;
        int reviewId = Integer.parseInt(this.reviewHarness.getShortId());
        try {
            changeDetail = this.reviewHarness.getClient().getChangeDetail(reviewId, (IProgressMonitor)new NullProgressMonitor());
            PatchSetDetailRemoteFactoryTest.fail((String)"Expected Gerrit Exception");
        }
        catch (GerritException gerritException) {
            // empty catch block
        }
        changeDetail = this.reviewHarness.getAdminClient().getChangeDetail(reviewId, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertThat((Object)changeDetail, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)changeDetail.getChange().getStatus(), (Matcher)Matchers.is((Object)Change.Status.NEW));
    }

    private void createPatchSet(String pushTo, CommonTestUtil.PrivilegeLevel privilegeLevel, List<String> files) throws Exception {
        CommitCommand command = this.reviewHarness.createCommitCommand();
        for (String fileName : files) {
            this.reviewHarness.addFile(fileName);
        }
        this.reviewHarness.commitAndPush(command, pushTo, privilegeLevel);
    }

    private PatchSetDetail retrievePatchSetDetail(String patchSetId) {
        TestRemoteObserverConsumer itemSetObserver = TestRemoteObserverConsumer.retrieveForLocalKey(this.reviewHarness.getProvider().getReviewItemSetFactory(), this.reviewHarness.getReview(), patchSetId, false);
        PatchSetDetail detail = (PatchSetDetail)itemSetObserver.getRemoteObject();
        return detail;
    }
}

