/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gerrit.core.remote;

import com.google.common.base.CharMatcher;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.gerrit.common.data.ApprovalDetail;
import com.google.gerrit.common.data.ChangeDetail;
import com.google.gerrit.common.data.PatchSetDetail;
import com.google.gerrit.common.data.ReviewerResult;
import com.google.gerrit.reviewdb.ApprovalCategoryValue;
import com.google.gerrit.reviewdb.Change;
import com.google.gerrit.reviewdb.ChangeMessage;
import com.google.gerrit.reviewdb.Patch;
import com.google.gerrit.reviewdb.PatchSet;
import com.google.gerrit.reviewdb.PatchSetApproval;
import com.google.gerrit.reviewdb.Project;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jgit.api.CommitCommand;
import org.eclipse.mylyn.commons.sdk.util.CommonTestUtil;
import org.eclipse.mylyn.gerrit.tests.core.client.rest.ChangeInfoTest;
import org.eclipse.mylyn.gerrit.tests.core.client.rest.IsEmpty;
import org.eclipse.mylyn.gerrit.tests.support.GerritProject;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritClient;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritException;
import org.eclipse.mylyn.internal.gerrit.core.client.compat.ChangeDetailX;
import org.eclipse.mylyn.internal.gerrit.core.client.compat.GerritSystemAccount;
import org.eclipse.mylyn.internal.gerrit.core.client.compat.PatchSetPublishDetailX;
import org.eclipse.mylyn.internal.gerrit.core.client.compat.PermissionLabel;
import org.eclipse.mylyn.internal.gerrit.core.client.rest.ApprovalUtil;
import org.eclipse.mylyn.internal.gerrit.core.client.rest.BranchInfo;
import org.eclipse.mylyn.internal.gerrit.core.client.rest.ChangeInfo;
import org.eclipse.mylyn.internal.gerrit.core.remote.GerritRemoteTest;
import org.eclipse.mylyn.internal.gerrit.core.remote.GerritReviewRemoteFactory;
import org.eclipse.mylyn.internal.gerrit.core.remote.ReviewHarness;
import org.eclipse.mylyn.internal.gerrit.core.remote.TestRemoteObserver;
import org.eclipse.mylyn.internal.gerrit.core.remote.TestRemoteObserverConsumer;
import org.eclipse.mylyn.reviews.core.model.IApprovalType;
import org.eclipse.mylyn.reviews.core.model.IChange;
import org.eclipse.mylyn.reviews.core.model.IComment;
import org.eclipse.mylyn.reviews.core.model.ICommit;
import org.eclipse.mylyn.reviews.core.model.IRequirementEntry;
import org.eclipse.mylyn.reviews.core.model.IReview;
import org.eclipse.mylyn.reviews.core.model.IReviewItemSet;
import org.eclipse.mylyn.reviews.core.model.IReviewerEntry;
import org.eclipse.mylyn.reviews.core.model.IUser;
import org.eclipse.mylyn.reviews.core.model.RequirementStatus;
import org.eclipse.mylyn.reviews.core.model.ReviewStatus;
import org.eclipse.mylyn.reviews.core.spi.remote.emf.RemoteEmfConsumer;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsNot;
import org.junit.Assert;
import org.junit.Test;

public class GerritReviewRemoteFactoryJUnit3Test
extends GerritRemoteTest {
    public void testGlobalComments() throws Exception {
        String message1 = "new comment, time: " + System.currentTimeMillis();
        this.reviewHarness.getClient().publishComments(this.reviewHarness.getShortId(), 1, message1, Collections.emptySet(), null);
        String message2 = "new comment, time: " + System.currentTimeMillis();
        this.reviewHarness.getClient().publishComments(this.reviewHarness.getShortId(), 1, message2, Collections.emptySet(), null);
        this.reviewHarness.retrieve();
        List comments = this.getReview().getComments();
        Assert.assertThat((Object)comments.size(), (Matcher)Matchers.is((Object)3));
        IComment uploadComment = (IComment)comments.get(0);
        Assert.assertThat((Object)uploadComment.getAuthor().getDisplayName(), (Matcher)Matchers.is((Object)"tests"));
        Assert.assertThat((Object)uploadComment.getDescription(), (Matcher)Matchers.is((Object)"Uploaded patch set 1."));
        IComment comment1 = (IComment)comments.get(1);
        Assert.assertThat((Object)comment1.getAuthor().getDisplayName(), (Matcher)Matchers.is((Object)"tests"));
        Assert.assertThat((Object)comment1.getDescription(), (Matcher)Matchers.is((Object)("Patch Set 1:\n\n" + message1)));
        IComment comment2 = (IComment)comments.get(2);
        Assert.assertThat((Object)comment2.getAuthor().getDisplayName(), (Matcher)Matchers.is((Object)"tests"));
        Assert.assertThat((Object)comment2.getDescription(), (Matcher)Matchers.is((Object)("Patch Set 1:\n\n" + message2)));
    }

    @Test
    public void testReviewStatus() throws Exception {
        Assert.assertThat((Object)GerritReviewRemoteFactory.getReviewStatus((Change.Status)Change.Status.ABANDONED), (Matcher)Matchers.is((Object)ReviewStatus.ABANDONED));
        Assert.assertThat((Object)GerritReviewRemoteFactory.getReviewStatus((Change.Status)Change.Status.MERGED), (Matcher)Matchers.is((Object)ReviewStatus.MERGED));
        Assert.assertThat((Object)GerritReviewRemoteFactory.getReviewStatus((Change.Status)Change.Status.NEW), (Matcher)Matchers.is((Object)ReviewStatus.NEW));
        Assert.assertThat((Object)GerritReviewRemoteFactory.getReviewStatus((Change.Status)Change.Status.SUBMITTED), (Matcher)Matchers.is((Object)ReviewStatus.SUBMITTED));
        Assert.assertThat((Object)GerritReviewRemoteFactory.getReviewStatus(null), (Matcher)Matchers.is((Object)ReviewStatus.DRAFT));
    }

    @Test
    public void testNewChange() throws Exception {
        if (!this.canMakeMultipleCommits()) {
            return;
        }
        CommitCommand command2 = this.reviewHarness.createCommitCommand();
        this.reviewHarness.addFile("testFile2.txt");
        this.reviewHarness.commitAndPush(command2);
        this.reviewHarness.retrieve();
        List items = this.getReview().getSets();
        Assert.assertThat((Object)items.size(), (Matcher)Matchers.is((Object)2));
        IReviewItemSet patchSet2 = (IReviewItemSet)items.get(1);
        Assert.assertThat((Object)patchSet2.getReference(), (Matcher)Matchers.endsWith((String)"/2"));
        this.reviewHarness.assertIsRecent(patchSet2.getCreationDate());
    }

    @Test
    public void testAccount() throws Exception {
        Assert.assertThat((Object)this.reviewHarness.getRepository().getAccount(), (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)this.reviewHarness.getRepository().getAccount().getDisplayName(), (Matcher)Matchers.is((Object)"tests"));
        Assert.assertThat((Object)this.reviewHarness.getRepository().getAccount().getEmail(), (Matcher)Matchers.is((Object)"tests@mylyn.eclipse.org"));
        Assert.assertThat((Object)((IUser)this.reviewHarness.getRepository().getUsers().get(0)), (Matcher)Matchers.is((Object)this.reviewHarness.getRepository().getAccount()));
    }

    @Test
    public void testApprovals() throws Exception {
        int approvals = 1;
        Assert.assertThat((Object)this.reviewHarness.getRepository().getApprovalTypes().size(), (Matcher)Matchers.is((Object)approvals));
        IApprovalType codeReviewApproval = (IApprovalType)this.reviewHarness.getRepository().getApprovalTypes().get(approvals - 1);
        Assert.assertThat((Object)codeReviewApproval.getKey(), (Matcher)Matchers.is((Object)ApprovalUtil.CRVW.getCategory().getId().get()));
        Assert.assertThat((Object)codeReviewApproval.getName(), (Matcher)Matchers.is((Object)ApprovalUtil.CRVW.getCategory().getName()));
        String approvalMessage = "approval, time: " + System.currentTimeMillis();
        this.reviewHarness.getClient().publishComments(this.reviewHarness.getShortId(), 1, approvalMessage, new HashSet<ApprovalCategoryValue.Id>(Collections.singleton(ApprovalUtil.CRVW.getValue((short)1).getId())), (IProgressMonitor)new NullProgressMonitor());
        this.reviewHarness.retrieve();
        Assert.assertThat((Object)this.getReview().getReviewerApprovals().size(), (Matcher)Matchers.is((Object)1));
        Map.Entry reviewerEntry = this.getReview().getReviewerApprovals().entrySet().iterator().next();
        Map reviewerApprovals = ((IReviewerEntry)reviewerEntry.getValue()).getApprovals();
        Assert.assertThat((Object)reviewerApprovals.size(), (Matcher)Matchers.is((Object)1));
        Map.Entry next = reviewerApprovals.entrySet().iterator().next();
        Assert.assertThat((Object)((IApprovalType)next.getKey()), (Matcher)Matchers.sameInstance((Object)codeReviewApproval));
        Assert.assertThat((Object)((Integer)next.getValue()), (Matcher)Matchers.is((Object)1));
        Set reviewApprovals = this.getReview().getRequirements().entrySet();
        Assert.assertThat((Object)reviewApprovals.size(), (Matcher)Matchers.is((Object)approvals));
        IRequirementEntry codeReviewEntry = (IRequirementEntry)this.getReview().getRequirements().get(codeReviewApproval);
        Assert.assertThat((Object)codeReviewEntry, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)codeReviewEntry.getBy(), (Matcher)Matchers.nullValue());
        Assert.assertThat((Object)codeReviewEntry.getStatus(), (Matcher)Matchers.is((Object)RequirementStatus.NOT_SATISFIED));
        Assert.assertThat((Object)this.getReview().getState(), (Matcher)Matchers.is((Object)ReviewStatus.NEW));
    }

    @Test
    public void testDependencies() throws Exception {
        String changeIdDep1 = "I" + StringUtils.rightPad((String)String.valueOf(System.currentTimeMillis()), (int)40, (String)"a");
        CommitCommand commandDep1 = this.reviewHarness.createCommitCommand(changeIdDep1);
        this.reviewHarness.addFile("testFile1.txt", "test 2");
        GerritProject.CommitResult resultDep1 = this.reviewHarness.commitAndPush(commandDep1);
        String resultIdDep1 = ReviewHarness.parseShortId(resultDep1.push.getMessages());
        Assert.assertThat((String)("Bad Push: " + resultDep1.push.getMessages()), (Object)resultIdDep1.length(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        TestRemoteObserverConsumer consumerDep1 = TestRemoteObserverConsumer.retrieveForRemoteKey(this.reviewHarness.getProvider().getReviewFactory(), this.reviewHarness.getRepository(), resultIdDep1, true);
        IReview reviewDep1 = (IReview)consumerDep1.getModelObject();
        Assert.assertThat((Object)reviewDep1.getParents().size(), (Matcher)Matchers.is((Object)1));
        IChange parentChange = (IChange)reviewDep1.getParents().get(0);
        Assert.assertThat((Object)parentChange.getId(), (Matcher)Matchers.is((Object)this.getReview().getId()));
        Assert.assertThat((Object)parentChange.getSubject(), (Matcher)Matchers.is((Object)this.getReview().getSubject()));
        this.reviewHarness.retrieve();
        Assert.assertThat((Object)this.getReview().getChildren().size(), (Matcher)Matchers.is((Object)1));
        IChange childChange = (IChange)this.getReview().getChildren().get(0);
        Assert.assertThat((Object)childChange.getId(), (Matcher)Matchers.is((Object)reviewDep1.getId()));
        Assert.assertThat((Object)childChange.getSubject(), (Matcher)Matchers.is((Object)reviewDep1.getSubject()));
    }

    @Test
    public void testAbandonChange() throws Exception {
        String message1 = "abandon, time: " + System.currentTimeMillis();
        ChangeDetail changeDetail = this.reviewHarness.getClient().abandon(this.reviewHarness.getShortId(), 1, message1, (IProgressMonitor)new NullProgressMonitor());
        this.reviewHarness.retrieve();
        Assert.assertThat((Object)changeDetail, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)changeDetail.getChange().getStatus(), (Matcher)Matchers.is((Object)Change.Status.ABANDONED));
        List messages = changeDetail.getMessages();
        Assert.assertThat((Object)messages.size(), (Matcher)Matchers.is((Object)2));
        ChangeMessage lastMessage = (ChangeMessage)messages.get(1);
        Assert.assertThat((Object)lastMessage.getAuthor().get(), (Matcher)Matchers.is((Object)1000001));
        Assert.assertThat((Object)lastMessage.getMessage(), (Matcher)Matchers.endsWith((String)("Abandoned\n\n" + message1)));
        Assert.assertThat((Object)this.getReview().getState(), (Matcher)Matchers.is((Object)ReviewStatus.ABANDONED));
        List comments = this.getReview().getComments();
        Assert.assertThat((Object)comments.size(), (Matcher)Matchers.is((Object)2));
        IComment lastComment = (IComment)comments.get(1);
        Assert.assertThat((Object)lastComment.getAuthor().getDisplayName(), (Matcher)Matchers.is((Object)"tests"));
        Assert.assertThat((Object)lastComment.getAuthor().getId(), (Matcher)Matchers.is((Object)"1000001"));
        Assert.assertThat((Object)lastComment.getDescription(), (Matcher)Matchers.endsWith((String)("Abandoned\n\n" + message1)));
    }

    @Test
    public void testRestoreChange() throws Exception {
        String message1 = "abandon, time: " + System.currentTimeMillis();
        this.reviewHarness.getClient().abandon(this.reviewHarness.getShortId(), 1, message1, (IProgressMonitor)new NullProgressMonitor());
        this.reviewHarness.retrieve();
        String message2 = "restore, time: " + System.currentTimeMillis();
        this.reviewHarness.getClient().restore(this.reviewHarness.getShortId(), 1, message2, (IProgressMonitor)new NullProgressMonitor());
        this.reviewHarness.retrieve();
        Assert.assertThat((Object)this.getReview().getState(), (Matcher)Matchers.is((Object)ReviewStatus.NEW));
        List comments = this.getReview().getComments();
        Assert.assertThat((Object)comments.size(), (Matcher)Matchers.is((Object)3));
        IComment lastComment = (IComment)comments.get(2);
        Assert.assertThat((Object)lastComment.getAuthor().getDisplayName(), (Matcher)Matchers.is((Object)"tests"));
        Assert.assertThat((Object)lastComment.getDescription(), (Matcher)Matchers.endsWith((String)("Restored\n\n" + message2)));
    }

    @Test
    public void testRestoreNewChange() throws Exception {
        Assert.assertThat((Object)this.getReview().getState(), (Matcher)Matchers.is((Object)ReviewStatus.NEW));
        String message1 = "restore, time: " + System.currentTimeMillis();
        try {
            this.reviewHarness.getClient().restore(this.reviewHarness.getShortId(), 1, message1, (IProgressMonitor)new NullProgressMonitor());
            GerritReviewRemoteFactoryJUnit3Test.fail((String)"Expected to fail when restoring a new change");
        }
        catch (GerritException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)"Not Found"));
        }
    }

    public void testCannotSubmitChange() throws Exception {
        try {
            this.reviewHarness.getClient().submit(this.reviewHarness.getShortId(), 1, (IProgressMonitor)new NullProgressMonitor());
            GerritReviewRemoteFactoryJUnit3Test.fail((String)"Expected to fail when submitting a change without approvals");
        }
        catch (GerritException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.startsWith((String)"Cannot submit change"));
        }
    }

    @Test
    public void testAddNullReviewers() throws Exception {
        try {
            this.reviewHarness.getClient().addReviewers(this.reviewHarness.getShortId(), null, (IProgressMonitor)new NullProgressMonitor());
            GerritReviewRemoteFactoryJUnit3Test.fail((String)"Expected to fail when trying to add null reviewers");
        }
        catch (IllegalArgumentException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)"reviewers cannot be null"));
        }
    }

    @Test
    public void testAddEmptyReviewers() throws Exception {
        ReviewerResult reviewerResult = this.reviewHarness.getClient().addReviewers(this.reviewHarness.getShortId(), Collections.emptyList(), (IProgressMonitor)new NullProgressMonitor());
        this.reviewHarness.retrieve();
        Assert.assertThat((Object)reviewerResult, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)reviewerResult.getErrors().isEmpty(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)reviewerResult.getChange().getApprovals().isEmpty(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)this.getReview().getReviewerApprovals().isEmpty(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testAddInvalidReviewers() throws Exception {
        List<String> reviewers = Arrays.asList("foo");
        ReviewerResult reviewerResult = this.reviewHarness.getClient().addReviewers(this.reviewHarness.getShortId(), reviewers, (IProgressMonitor)new NullProgressMonitor());
        this.reviewHarness.retrieve();
        Assert.assertThat((Object)reviewerResult, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)reviewerResult.getErrors().size(), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)((ReviewerResult.Error)reviewerResult.getErrors().get(0)).getName(), (Matcher)Matchers.is((Object)"foo"));
        Assert.assertThat((Object)((ReviewerResult.Error)reviewerResult.getErrors().get(0)).getType(), (Matcher)Matchers.nullValue());
        Assert.assertThat((Object)reviewerResult.getChange().getApprovals().isEmpty(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)this.getReview().getReviewerApprovals().isEmpty(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testAddSomeInvalidReviewers() throws Exception {
        List<String> reviewers = Arrays.asList("admin", "foo");
        List<Integer> userid = Arrays.asList(1000000);
        ReviewerResult reviewerResult = this.reviewHarness.getClient().addReviewers(this.reviewHarness.getShortId(), reviewers, (IProgressMonitor)new NullProgressMonitor());
        this.reviewHarness.retrieve();
        this.assertReviewerResult(reviewerResult, "foo", userid);
    }

    @Test
    public void testAddReviewers() throws Exception {
        Assert.assertThat((Object)this.getReview().getReviewerApprovals().isEmpty(), (Matcher)Matchers.is((Object)true));
        this.addAdminToReviewAndVerify();
    }

    @Test
    public void testAddReviewerThenRemoveReviewer() throws Exception {
        Assert.assertThat((Object)this.getReview().getReviewerApprovals().isEmpty(), (Matcher)Matchers.is((Object)true));
        this.addAdminToReviewAndVerify();
        String reviewer = "admin";
        ReviewerResult removeReviewerResult = this.reviewHarness.getClient().removeReviewer(this.reviewHarness.getShortId(), reviewer, (IProgressMonitor)new NullProgressMonitor());
        this.reviewHarness.retrieve();
        Assert.assertThat((Object)this.getReview().getReviewerApprovals().isEmpty(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)removeReviewerResult, (Matcher)Matchers.notNullValue());
        GerritReviewRemoteFactoryJUnit3Test.assertTrue((boolean)removeReviewerResult.getErrors().isEmpty());
        List approvals = removeReviewerResult.getChange().getApprovals();
        Assert.assertThat((Object)approvals.isEmpty(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)approvals.size(), (Matcher)Matchers.is((Object)0));
    }

    @Test
    public void testAddReviewerAndRemoveInvalidReviewer() throws Exception {
        this.addAdminToReviewAndVerify();
        String reviewer = "foo";
        ReviewerResult removeReviewerResult = this.reviewHarness.getClient().removeReviewer(this.reviewHarness.getShortId(), reviewer, (IProgressMonitor)new NullProgressMonitor());
        this.reviewHarness.retrieve();
        Assert.assertThat((Object)removeReviewerResult, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)removeReviewerResult.getErrors().size(), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)((ReviewerResult.Error)removeReviewerResult.getErrors().get(0)).getType(), (Matcher)Matchers.nullValue());
        Assert.assertThat((Object)((ReviewerResult.Error)removeReviewerResult.getErrors().get(0)).getName(), (Matcher)Matchers.is((Object)reviewer));
        List approvals = removeReviewerResult.getChange().getApprovals();
        Assert.assertThat((Object)approvals.isEmpty(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)approvals.size(), (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void testAddReviewerAndRemoveValidReviewerNotOnReview() throws Exception {
        this.addAdminToReviewAndVerify();
        String reviewer = "tests";
        ReviewerResult removeReviewerResult = this.reviewHarness.getClient().removeReviewer(this.reviewHarness.getShortId(), reviewer, (IProgressMonitor)new NullProgressMonitor());
        this.reviewHarness.retrieve();
        Assert.assertThat((Object)removeReviewerResult, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)removeReviewerResult.getErrors().size(), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)((ReviewerResult.Error)removeReviewerResult.getErrors().get(0)).getType(), (Matcher)Matchers.nullValue());
        Assert.assertThat((Object)((ReviewerResult.Error)removeReviewerResult.getErrors().get(0)).getName(), (Matcher)Matchers.is((Object)reviewer));
        List approvals = removeReviewerResult.getChange().getApprovals();
        Assert.assertThat((Object)approvals.isEmpty(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)approvals.size(), (Matcher)Matchers.is((Object)1));
    }

    private void addAdminToReviewAndVerify() throws Exception {
        List<String> reviewers = Arrays.asList("admin");
        List<Integer> userid = Arrays.asList(1000000);
        ReviewerResult addReviewerResult = this.reviewHarness.getClient().addReviewers(this.reviewHarness.getShortId(), reviewers, (IProgressMonitor)new NullProgressMonitor());
        this.reviewHarness.retrieve();
        this.assertReviewerResult(addReviewerResult, null, userid);
    }

    @Test
    public void testAddReviewersByEmail() throws Exception {
        List<String> reviewers = Arrays.asList("admin@mylyn.eclipse.org");
        List<Integer> userid = Arrays.asList(1000000);
        ReviewerResult reviewerResult = this.reviewHarness.getClient().addReviewers(this.reviewHarness.getShortId(), reviewers, (IProgressMonitor)new NullProgressMonitor());
        this.reviewHarness.retrieve();
        this.assertReviewerResult(reviewerResult, null, userid);
    }

    private void assertReviewerResult(ReviewerResult reviewerResult, String nameInErrors, List<Integer> userIds) {
        Assert.assertThat((Object)reviewerResult, (Matcher)Matchers.notNullValue());
        int numReviewers = userIds.size();
        Assert.assertThat((Object)reviewerResult.getErrors().isEmpty(), (Matcher)Matchers.is((Object)(nameInErrors == null ? 1 : 0)));
        if (nameInErrors != null) {
            Assert.assertThat((Object)reviewerResult.getErrors().size(), (Matcher)Matchers.is((Object)1));
            Assert.assertThat((Object)((ReviewerResult.Error)reviewerResult.getErrors().get(0)).getName(), (Matcher)Matchers.is((Object)nameInErrors));
            Assert.assertThat((Object)((ReviewerResult.Error)reviewerResult.getErrors().get(0)).getType(), (Matcher)Matchers.nullValue());
        }
        List approvals = reviewerResult.getChange().getApprovals();
        Assert.assertThat((Object)approvals.isEmpty(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)approvals.size(), (Matcher)Matchers.is((Object)numReviewers));
        int i = 0;
        while (i < numReviewers) {
            Assert.assertThat((Object)((ApprovalDetail)approvals.get(i)).getAccount().get(), (Matcher)Matchers.is((Object)userIds.get(i)));
            Map approvalMap = ((ApprovalDetail)approvals.get(i)).getApprovalMap();
            Assert.assertThat((Object)approvalMap, (Matcher)Matchers.notNullValue());
            Assert.assertThat((Object)approvalMap.isEmpty(), (Matcher)Matchers.is((Object)false));
            Assert.assertThat((Object)approvalMap.size(), (Matcher)Matchers.is((Object)1));
            PatchSetApproval crvw = (PatchSetApproval)approvalMap.get(ApprovalUtil.CRVW.getCategory().getId());
            Assert.assertThat((Object)crvw, (Matcher)Matchers.notNullValue());
            Assert.assertThat((Object)crvw.getAccountId().get(), (Matcher)Matchers.is((Object)userIds.get(i)));
            Assert.assertThat((Object)crvw.getValue(), (Matcher)Matchers.is((Object)0));
            Assert.assertThat((Object)crvw.getGranted(), (Matcher)Matchers.notNullValue());
            Assert.assertThat((Object)crvw.getPatchSetId(), (Matcher)Matchers.notNullValue());
            Assert.assertThat((Object)crvw.getPatchSetId().get(), (Matcher)Matchers.is((Object)1));
            Assert.assertThat((Object)crvw.getPatchSetId().getParentKey().get(), (Matcher)Matchers.is((Object)Integer.parseInt(this.getReview().getId())));
            Assert.assertThat((Object)((IReviewerEntry)this.getReview().getReviewerApprovals().get(i)), (Matcher)Matchers.nullValue());
            ++i;
        }
        Assert.assertThat((Object)this.getReview().getReviewerApprovals().isEmpty(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)this.getReview().getReviewerApprovals().size(), (Matcher)Matchers.is((Object)numReviewers));
    }

    @Test
    public void testCannotRebaseChangeAlreadyUpToDate() throws Exception {
        try {
            this.reviewHarness.getClient().rebase(this.reviewHarness.getShortId(), 1, (IProgressMonitor)new NullProgressMonitor());
            GerritReviewRemoteFactoryJUnit3Test.fail((String)"Expected to fail when rebasing a change that is already up to date");
        }
        catch (GerritException e) {
            String message = CharMatcher.JAVA_ISO_CONTROL.removeFrom((CharSequence)e.getMessage());
            Assert.assertThat((Object)message, (Matcher)Matchers.is((Object)"Change is already up to date."));
        }
    }

    @Test
    public void testGetChangeDetailWithNoApprovals() throws Exception {
        int reviewId = Integer.parseInt(this.reviewHarness.getShortId());
        ChangeDetailX changeDetail = this.reviewHarness.getClient().getChangeDetail(reviewId, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertThat((Object)changeDetail, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)changeDetail.getApprovals(), IsEmpty.empty());
    }

    @Test
    public void testGetChangeInfo() throws Exception {
        int reviewId = Integer.parseInt(this.reviewHarness.getShortId());
        ChangeInfo changeInfo = this.reviewHarness.getClient().getChangeInfo(reviewId, (IProgressMonitor)new NullProgressMonitor());
        ChangeInfoTest.assertHasCodeReviewLabels(changeInfo, true);
    }

    @Test
    public void testUnpermittedApproval() throws Exception {
        String approvalMessage = "approval, time: " + System.currentTimeMillis();
        try {
            this.reviewHarness.getClient().publishComments(this.reviewHarness.getShortId(), 1, approvalMessage, new HashSet<ApprovalCategoryValue.Id>(Collections.singleton(ApprovalUtil.CRVW.getValue((short)2).getId())), (IProgressMonitor)new NullProgressMonitor());
            GerritReviewRemoteFactoryJUnit3Test.fail((String)"Expected to fail when trying to vote +2 when it's not permitted");
        }
        catch (GerritException e) {
            GerritReviewRemoteFactoryJUnit3Test.assertEquals((String)"Applying label \"Code-Review\": 2 is restricted", (String)e.getMessage());
        }
    }

    @Test
    public void testGetPatchSetPublishDetail() throws Exception {
        int reviewId = Integer.parseInt(this.reviewHarness.getShortId());
        PatchSet.Id id = new PatchSet.Id(new Change.Id(reviewId), 1);
        PatchSetPublishDetailX patchSetDetail = this.reviewHarness.getClient().getPatchSetPublishDetail(id, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertThat((Object)patchSetDetail, (Matcher)Matchers.notNullValue());
        List allowed = patchSetDetail.getLabels();
        Assert.assertThat((Object)allowed, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)allowed, (Matcher)IsNot.not(IsEmpty.empty()));
        Assert.assertThat((Object)allowed.size(), (Matcher)Matchers.is((Object)1));
        PermissionLabel crvwAllowed = (PermissionLabel)allowed.get(0);
        Assert.assertThat((Object)crvwAllowed.matches(ApprovalUtil.CRVW.getCategory()), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)crvwAllowed.getName(), (Matcher)Matchers.is((Object)PermissionLabel.toLabelName((String)ApprovalUtil.toNameWithDash((String)ApprovalUtil.CRVW.getCategory().getName()))));
        Assert.assertThat((Object)crvwAllowed.getMin(), (Matcher)Matchers.is((Object)-1));
        Assert.assertThat((Object)crvwAllowed.getMax(), (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void testSetStarred() throws Exception {
        int reviewId = Integer.parseInt(this.reviewHarness.getShortId());
        this.reviewHarness.getClient().setStarred(this.reviewHarness.getShortId(), true, (IProgressMonitor)new NullProgressMonitor());
        ChangeDetailX changeDetail = this.reviewHarness.getClient().getChangeDetail(reviewId, (IProgressMonitor)new NullProgressMonitor());
        GerritReviewRemoteFactoryJUnit3Test.assertEquals((boolean)true, (boolean)changeDetail.isStarred());
        this.reviewHarness.getClient().setStarred(this.reviewHarness.getShortId(), true, (IProgressMonitor)new NullProgressMonitor());
        changeDetail = this.reviewHarness.getClient().getChangeDetail(reviewId, (IProgressMonitor)new NullProgressMonitor());
        GerritReviewRemoteFactoryJUnit3Test.assertEquals((boolean)true, (boolean)changeDetail.isStarred());
        this.reviewHarness.getClient().setStarred(this.reviewHarness.getShortId(), false, (IProgressMonitor)new NullProgressMonitor());
        changeDetail = this.reviewHarness.getClient().getChangeDetail(reviewId, (IProgressMonitor)new NullProgressMonitor());
        GerritReviewRemoteFactoryJUnit3Test.assertEquals((boolean)false, (boolean)changeDetail.isStarred());
    }

    @Test
    public void testReviewsWithSameChangeId() throws Exception {
        String branchName = "test_side_branch";
        this.createBranchIfNonExistent(branchName);
        ReviewHarness reviewHarness2 = this.reviewHarness.duplicate();
        reviewHarness2.init("HEAD:refs/for/" + branchName, CommonTestUtil.PrivilegeLevel.USER, "otherTestFile.txt", true);
        this.reviewHarness.retrieve();
        reviewHarness2.retrieve();
        GerritReviewRemoteFactoryJUnit3Test.assertEquals((String)this.reviewHarness.getReview().getKey(), (String)reviewHarness2.getReview().getKey());
        Assert.assertThat((Object)this.reviewHarness.getReview().getId(), (Matcher)Matchers.is((Matcher)IsNot.not((Object)reviewHarness2.getReview().getId())));
        Assert.assertThat((Object)this.reviewHarness.getReview().getSets().size(), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)((IReviewItemSet)this.reviewHarness.getReview().getSets().get(0)).getId(), (Matcher)Matchers.is((Object)"1"));
        PatchSetDetail detail = this.retrievePatchSetDetail(this.reviewHarness, "1");
        Assert.assertThat((Object)detail.getPatches().size(), (Matcher)Matchers.is((Object)2));
        Assert.assertThat((Object)((Patch)detail.getPatches().get(0)).getFileName(), (Matcher)Matchers.is((Object)"/COMMIT_MSG"));
        Assert.assertThat((Object)((Patch)detail.getPatches().get(1)).getFileName(), (Matcher)Matchers.is((Object)"testFile1.txt"));
        Assert.assertThat((Object)reviewHarness2.getReview().getSets().size(), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)((IReviewItemSet)reviewHarness2.getReview().getSets().get(0)).getId(), (Matcher)Matchers.is((Object)"1"));
        PatchSetDetail detail2 = this.retrievePatchSetDetail(reviewHarness2, "1");
        Assert.assertThat((Object)detail2.getPatches().size(), (Matcher)Matchers.is((Object)2));
        Assert.assertThat((Object)((Patch)detail2.getPatches().get(0)).getFileName(), (Matcher)Matchers.is((Object)"/COMMIT_MSG"));
        Assert.assertThat((Object)((Patch)detail2.getPatches().get(1)).getFileName(), (Matcher)Matchers.is((Object)"otherTestFile.txt"));
    }

    @Test
    public void testCherryPick() throws Exception {
        String testMessage = "Test Cherry Pick";
        String branchName = "test_side_branch";
        this.createBranchIfNonExistent(branchName);
        String refSpec = "refs/heads/" + branchName;
        ChangeDetail changeDetail = this.reviewHarness.getClient().cherryPick(this.reviewHarness.getShortId(), 1, testMessage, refSpec, (IProgressMonitor)new NullProgressMonitor());
        Change change = changeDetail.getChange();
        IReview review = this.reviewHarness.getReview();
        Assert.assertThat((Object)change.getChangeId(), (Matcher)Matchers.is((Matcher)IsNot.not((Object)Integer.parseInt(review.getId()))));
        Assert.assertThat((Object)change.getKey().get(), (Matcher)Matchers.is((Matcher)IsNot.not((Object)review.getKey())));
        Assert.assertThat((Object)change.getSubject(), (Matcher)Matchers.is((Object)testMessage));
        Assert.assertThat((Object)change.getDest().get(), (Matcher)Matchers.is((Object)branchName));
    }

    @Test
    public void testCannotCherryPick() throws Exception {
        String testMessage = "Test Cherry Pick";
        String testDest = "refs/heads/test_side_branch";
        this.badRequestCherryPick(null, testDest, "message must be non-empty");
        this.badRequestCherryPick("", testDest, "message must be non-empty");
        this.badRequestCherryPick(testMessage, null, "destination must be non-empty");
        this.badRequestCherryPick(testMessage, "", "destination must be non-empty");
        this.badRequestCherryPick(testMessage, "no_such_branch", "Branch no_such_branch does not exist.");
    }

    private void badRequestCherryPick(String message, String dest, String errMsg) {
        this.failedCherryPick(message, dest, "Bad Request: " + errMsg);
    }

    @Test
    public void unsupportedVersionCherryPick(String message, String dest, String errMsg) throws GerritException {
        this.failedCherryPick("Test Cherry Pick", "refs/heads/test_side_branch", "Cherry Picking not supported before version 2.8");
    }

    private void failedCherryPick(String message, String dest, String errMsg) {
        try {
            this.reviewHarness.getClient().cherryPick(this.reviewHarness.getShortId(), 1, message, dest, (IProgressMonitor)new NullProgressMonitor());
            GerritReviewRemoteFactoryJUnit3Test.fail((String)"Expected to get an exception when cherry picking");
        }
        catch (GerritException e) {
            String receivedMessage = CharMatcher.JAVA_ISO_CONTROL.removeFrom((CharSequence)e.getMessage());
            Assert.assertThat((Object)receivedMessage, (Matcher)Matchers.is((Object)errMsg));
        }
    }

    @Test
    public void testGlobalCommentByGerrit() throws Exception {
        String changeIdNewChange = ReviewHarness.generateChangeId();
        CommitCommand commandNewChange = this.reviewHarness.createCommitCommand(changeIdNewChange);
        this.reviewHarness.addFile("testFileNewChange.txt");
        GerritProject.CommitResult result = this.reviewHarness.commitAndPush(commandNewChange);
        String newReviewShortId = ReviewHarness.parseShortId(result.push.getMessages());
        TestRemoteObserver newReviewListener = new TestRemoteObserver(this.reviewHarness.getProvider().getReviewFactory());
        RemoteEmfConsumer newReviewConsumer = this.reviewHarness.getProvider().getReviewFactory().getConsumerForRemoteKey((EObject)this.reviewHarness.getRepository(), (Object)newReviewShortId);
        newReviewConsumer.addObserver(newReviewListener);
        newReviewConsumer.retrieve(false);
        newReviewListener.waitForResponse();
        this.reviewHarness.retrieve();
        IReview newReview = (IReview)this.reviewHarness.getProvider().open((Object)newReviewShortId);
        Assert.assertThat((Object)newReview.getId(), (Matcher)Matchers.is((Object)newReviewShortId));
        Assert.assertThat((Object)this.getReview().getChildren().size(), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)this.getReview().getSets().size(), (Matcher)Matchers.is((Object)1));
        this.reviewHarness.checkoutPatchSet(1);
        CommitCommand command2 = this.reviewHarness.createCommitCommand();
        this.reviewHarness.addFile("testFile3.txt");
        this.reviewHarness.commitAndPush(command2);
        this.reviewHarness.retrieve();
        List items = this.getReview().getSets();
        Assert.assertThat((Object)items.size(), (Matcher)Matchers.is((Object)2));
        IReviewItemSet patchSet2 = (IReviewItemSet)items.get(1);
        Assert.assertThat((Object)patchSet2.getReference(), (Matcher)Matchers.endsWith((String)"/2"));
        this.reviewHarness.assertIsRecent(patchSet2.getCreationDate());
        String approvalMessage = "approval, time: " + System.currentTimeMillis();
        HashSet<ApprovalCategoryValue.Id> approvals = new HashSet<ApprovalCategoryValue.Id>(Collections.singleton(ApprovalUtil.CRVW.getValue((short)2).getId()));
        this.reviewHarness.getAdminClient().publishComments(newReviewShortId, 1, approvalMessage, approvals, (IProgressMonitor)new NullProgressMonitor());
        this.reviewHarness.getAdminClient().submit(newReviewShortId, 1, (IProgressMonitor)new NullProgressMonitor());
        newReviewConsumer.retrieve(false);
        newReviewListener.waitForResponse();
        Assert.assertThat((Object)newReview.getState(), (Matcher)Matchers.is((Object)ReviewStatus.SUBMITTED));
        List comments = newReview.getComments();
        Assert.assertThat((Object)comments.size(), (Matcher)Matchers.is((Object)3));
        IComment commentByGerrit = (IComment)comments.get(2);
        GerritReviewRemoteFactoryJUnit3Test.assertNotNull((Object)commentByGerrit.getAuthor());
        Assert.assertThat((Object)commentByGerrit.getAuthor().getId(), (Matcher)Matchers.is((Object)String.valueOf(GerritSystemAccount.GERRIT_SYSTEM.getId())));
        Assert.assertThat((Object)commentByGerrit.getAuthor().getDisplayName(), (Matcher)Matchers.is((Object)"Gerrit Code Review"));
        Assert.assertThat((Object)commentByGerrit.getDescription().substring(0, 58), (Matcher)Matchers.is((Object)"Change cannot be merged due to unsatisfiable dependencies."));
        Assert.assertThat((Object)this.findUser("tests").getEmail(), (Matcher)Matchers.is((Object)"tests@mylyn.eclipse.org"));
        Assert.assertThat((Object)this.findUser("admin").getEmail(), (Matcher)Matchers.is((Object)"admin@mylyn.eclipse.org"));
        IUser systemUser = this.findUser("Gerrit Code Review");
        Assert.assertThat((Object)systemUser.getEmail(), (Matcher)Matchers.nullValue());
        Assert.assertThat((Object)systemUser.getId(), (Matcher)Matchers.is((Object)"-2"));
    }

    private IUser findUser(final String displayName) {
        return (IUser)Iterables.find((Iterable)this.reviewHarness.getRepository().getUsers(), (Predicate)new Predicate<IUser>(){

            public boolean apply(IUser user) {
                return user.getDisplayName().equals(displayName);
            }
        });
    }

    @Test
    public void testParentCommit() throws Exception {
        String changeIdNewChange = ReviewHarness.generateChangeId();
        CommitCommand commandNewChange = this.reviewHarness.createCommitCommand(changeIdNewChange);
        this.reviewHarness.addFile("testFileNewChange.txt");
        GerritProject.CommitResult result = this.reviewHarness.commitAndPush(commandNewChange);
        String newReviewShortId = ReviewHarness.parseShortId(result.push.getMessages());
        TestRemoteObserver newReviewListener = new TestRemoteObserver(this.reviewHarness.getProvider().getReviewFactory());
        RemoteEmfConsumer newReviewConsumer = this.reviewHarness.getProvider().getReviewFactory().getConsumerForRemoteKey((EObject)this.reviewHarness.getRepository(), (Object)newReviewShortId);
        newReviewConsumer.addObserver(newReviewListener);
        newReviewConsumer.retrieve(false);
        newReviewListener.waitForResponse();
        this.reviewHarness.retrieve();
        IReview parentReview = this.getReview();
        IReview childReview = (IReview)this.reviewHarness.getProvider().open((Object)newReviewShortId);
        Assert.assertThat((Object)childReview.getId(), (Matcher)Matchers.is((Object)newReviewShortId));
        Assert.assertThat((Object)parentReview.getChildren().size(), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)parentReview.getSets().size(), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)childReview.getSets().size(), (Matcher)Matchers.is((Object)1));
        IReviewItemSet childPatchSet = (IReviewItemSet)childReview.getSets().get(0);
        IReviewItemSet parentPatchSet = (IReviewItemSet)parentReview.getSets().get(0);
        Assert.assertThat((Object)childPatchSet.getParentCommits().size(), (Matcher)Matchers.is((Object)1));
        String parentCommitId = ((ICommit)childPatchSet.getParentCommits().get(0)).getId();
        Assert.assertThat((Object)parentCommitId, (Matcher)Matchers.is((Object)parentPatchSet.getRevision()));
    }

    @Test
    public void testGetCachedBranches() throws GerritException {
        GerritClient client = this.reviewHarness.getClient();
        NullProgressMonitor monitor = new NullProgressMonitor();
        Project.NameKey project = client.getChange(this.reviewHarness.getShortId(), (IProgressMonitor)monitor).getChangeDetail().getChange().getProject();
        GerritReviewRemoteFactoryJUnit3Test.assertNull((Object)client.getCachedBranches(project));
        client.refreshConfigOnce(project, (IProgressMonitor)monitor);
        Set branches = client.getCachedBranches(project);
        GerritReviewRemoteFactoryJUnit3Test.assertNotNull((Object)branches);
        GerritReviewRemoteFactoryJUnit3Test.assertTrue((boolean)branches.contains("refs/heads/master"));
        String newBranch = "branch-" + System.currentTimeMillis();
        String newBranchRef = "refs/heads/" + newBranch;
        try {
            this.createBranchIfNonExistent(newBranch);
            GerritReviewRemoteFactoryJUnit3Test.assertFalse((boolean)client.getCachedBranches(project).contains(newBranchRef));
            client.refreshConfigOnce(project, (IProgressMonitor)monitor);
            GerritReviewRemoteFactoryJUnit3Test.assertFalse((boolean)client.getCachedBranches(project).contains(newBranchRef));
            client.refreshConfig((IProgressMonitor)monitor);
            GerritReviewRemoteFactoryJUnit3Test.assertTrue((boolean)client.getCachedBranches(project).contains(newBranchRef));
        }
        finally {
            this.deleteBranch(newBranch);
        }
    }

    private void createBranchIfNonExistent(String branchName) throws GerritException {
        if (!this.branchExists(branchName)) {
            this.reviewHarness.getAdminClient().createRemoteBranch("org.eclipse.mylyn.test", branchName, null, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    private void deleteBranch(String branchName) throws GerritException {
        this.reviewHarness.getAdminClient().deleteRemoteBranch("org.eclipse.mylyn.test", branchName, null, (IProgressMonitor)new NullProgressMonitor());
    }

    private boolean branchExists(String branchName) throws GerritException {
        BranchInfo[] branches;
        BranchInfo[] branchInfoArray = branches = this.reviewHarness.getAdminClient().getRemoteProjectBranches("org.eclipse.mylyn.test", (IProgressMonitor)new NullProgressMonitor());
        int n = branches.length;
        int n2 = 0;
        while (n2 < n) {
            BranchInfo branch = branchInfoArray[n2];
            String branchRef = StringUtils.trimToEmpty((String)StringUtils.substringAfterLast((String)branch.getRef(), (String)"/"));
            if (branchRef.equals(branchName)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private PatchSetDetail retrievePatchSetDetail(ReviewHarness reviewHarness, String patchSetId) {
        TestRemoteObserverConsumer itemSetObserver = TestRemoteObserverConsumer.retrieveForLocalKey(reviewHarness.getProvider().getReviewItemSetFactory(), reviewHarness.getReview(), patchSetId, false);
        PatchSetDetail detail = (PatchSetDetail)itemSetObserver.getRemoteObject();
        return detail;
    }

    @Test
    public void testNoLabels() throws Exception {
        HashSet<ApprovalCategoryValue.Id> approvals = new HashSet<ApprovalCategoryValue.Id>(Collections.singleton(ApprovalUtil.CRVW.getValue((short)-2).getId()));
        this.reviewHarness.getAdminClient().publishComments(this.reviewHarness.getShortId(), 1, "", approvals, (IProgressMonitor)new NullProgressMonitor());
        this.reviewHarness.retrieve();
    }
}

