/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gerrit.core.remote;

import java.io.File;
import junit.framework.TestCase;
import org.apache.commons.io.FileUtils;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.mylyn.internal.gerrit.core.remote.GerritRemoteFactoryProvider;
import org.eclipse.mylyn.internal.gerrit.core.remote.ReviewHarness;
import org.eclipse.mylyn.internal.gerrit.core.remote.TestDataLocator;
import org.eclipse.mylyn.reviews.core.model.IRepository;
import org.eclipse.mylyn.reviews.core.model.IReview;
import org.eclipse.mylyn.reviews.core.spi.remote.AbstractDataLocator;
import org.eclipse.mylyn.reviews.core.spi.remote.AbstractRemoteService;
import org.eclipse.mylyn.reviews.core.spi.remote.JobRemoteService;
import org.eclipse.mylyn.reviews.spi.edit.remote.review.ReviewsRemoteEditFactoryProvider;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class GerritDataLocatorTest
extends TestCase {
    private ReviewHarness reviewHarness;
    private final TestDataLocator locator = new TestDataLocator();
    private GerritRemoteFactoryProvider provider;

    @Before
    public void setUp() throws Exception {
        File rootDir = new File(this.locator.getSystemDataPath().toOSString());
        if (rootDir.exists()) {
            FileUtils.forceDelete((File)rootDir);
        }
        FileUtils.forceMkdir((File)rootDir);
        this.reviewHarness = new ReviewHarness();
        this.provider = new GerritRemoteFactoryProvider(this.reviewHarness.getClient());
        this.provider.setDataLocator((AbstractDataLocator)this.locator);
        this.provider.setService((AbstractRemoteService)new JobRemoteService());
    }

    @After
    public void tearDown() throws Exception {
        this.reviewHarness.dispose();
    }

    @Test
    public void testCreateRoot() throws Exception {
        String testPath = String.valueOf(FileUtils.getTempDirectory().getAbsolutePath()) + File.separator + "gerrit_tests";
        String filePath = String.valueOf(testPath) + File.separator + "reviews_bin" + File.separator + "org.eclipse.mylyn.gerrit-" + ReviewsRemoteEditFactoryProvider.asFileName((String)this.reviewHarness.getTaskRepository().getUrl()) + File.separator + "Repository" + File.separator + "Repository.reviews";
        File file = new File(filePath);
        Assert.assertThat((String)("File should not exist at: " + filePath), (Object)file.exists(), (Matcher)Matchers.is((Object)false));
        this.provider.open();
        Assert.assertThat((String)("File should exist at: " + filePath), (Object)file.exists(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)((IRepository)this.provider.getRoot()), (Matcher)Matchers.instanceOf(IRepository.class));
        Assert.assertThat((Object)((IRepository)this.provider.getRoot()).getTaskRepositoryUrl(), (Matcher)Matchers.is((Object)this.reviewHarness.getTaskRepository().getUrl()));
        Assert.assertThat((Object)this.provider.getEditingDomain().getResourceSet().getResources().size(), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)((Resource)this.provider.getEditingDomain().getResourceSet().getResources().get(0)).getContents().size(), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)((EObject)((Resource)this.provider.getEditingDomain().getResourceSet().getResources().get(0)).getContents().get(0)), (Matcher)Matchers.is((Object)this.provider.getRoot()));
        this.provider.close();
        Assert.assertThat((Object)((IRepository)this.provider.getRoot()), (Matcher)Matchers.nullValue());
        Assert.assertThat((String)("File should exist at: " + filePath), (Object)file.exists(), (Matcher)Matchers.is((Object)true));
        this.provider.open();
        Assert.assertThat((Object)((IRepository)this.provider.getRoot()), (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)((IRepository)this.provider.getRoot()).getTaskRepositoryUrl(), (Matcher)Matchers.is((Object)this.reviewHarness.getTaskRepository().getUrl()));
    }

    @Test
    public void testMigrate() throws Exception {
        String testPath = String.valueOf(FileUtils.getTempDirectory().getAbsolutePath()) + File.separator + "gerrit_tests";
        File binDir = new File(String.valueOf(testPath) + File.separator + "reviews_bin");
        File xmlDir = new File(String.valueOf(testPath) + File.separator + "reviews_xml");
        FileUtils.forceMkdir((File)xmlDir);
        File xmlFile = new File(String.valueOf(testPath) + File.separator + "reviews_xml" + File.separator + "SomeFile.txt");
        xmlFile.createNewFile();
        File modelDir = new File(String.valueOf(testPath) + File.separator + "model");
        FileUtils.forceMkdir((File)modelDir);
        Assert.assertThat((Object)binDir.exists(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)xmlDir.exists(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)xmlFile.exists(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)modelDir.exists(), (Matcher)Matchers.is((Object)true));
        this.provider.setDataLocator((AbstractDataLocator)new TestDataLocator());
        this.provider.open();
        Assert.assertThat((Object)binDir.exists(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)xmlDir.exists(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)xmlFile.exists(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)modelDir.exists(), (Matcher)Matchers.is((Object)false));
        this.provider.close();
    }

    @Test
    public void testCreateChild() throws Exception {
        String testPath = String.valueOf(FileUtils.getTempDirectory().getAbsolutePath()) + File.separator + "gerrit_tests";
        String filePath = String.valueOf(testPath) + File.separator + "reviews_bin" + File.separator + "org.eclipse.mylyn.gerrit-" + ReviewsRemoteEditFactoryProvider.asFileName((String)this.reviewHarness.getTaskRepository().getUrl()) + File.separator + "Review" + File.separator + "2.reviews";
        File file = new File(filePath);
        Assert.assertThat((String)("File should not exist at: " + filePath), (Object)file.exists(), (Matcher)Matchers.is((Object)false));
        this.provider.open();
        IReview child = (IReview)this.provider.open((Object)"2");
        Assert.assertThat((Object)child.getId(), (Matcher)Matchers.is((Object)"2"));
        child.setMessage("Foo");
        Assert.assertThat((Object)((IReview)((IRepository)this.provider.getRoot()).getReviews().get(0)), (Matcher)Matchers.sameInstance((Object)child));
        this.provider.close((EObject)child);
        Assert.assertThat((String)("File should exist at: " + filePath), (Object)file.exists(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)((IRepository)this.provider.getRoot()).getReviews().size(), (Matcher)Matchers.is((Object)0));
        this.provider.close();
        this.provider.open();
        Assert.assertThat((Object)((IRepository)this.provider.getRoot()).getReviews().size(), (Matcher)Matchers.is((Object)0));
        IReview newChild = (IReview)this.provider.open((Object)"2");
        Assert.assertThat((Object)((IRepository)this.provider.getRoot()).getReviews().size(), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)newChild.getId(), (Matcher)Matchers.is((Object)"2"));
        Assert.assertThat((Object)newChild.getMessage(), (Matcher)Matchers.is((Object)"Foo"));
    }
}

