/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.gerrit.tests.ui;

import java.util.concurrent.TimeUnit;
import junit.framework.TestCase;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.net.AuthenticationType;
import org.eclipse.mylyn.commons.sdk.util.CommonTestUtil;
import org.eclipse.mylyn.commons.ui.PlatformUiUtil;
import org.eclipse.mylyn.commons.workbench.EditorHandle;
import org.eclipse.mylyn.commons.workbench.browser.BrowserUtil;
import org.eclipse.mylyn.gerrit.tests.support.GerritFixture;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditor;
import org.eclipse.mylyn.tests.util.TestFixture;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;

public class GerritUrlHandlerTest
extends TestCase {
    private IWorkbenchPage activePage;

    protected void setUp() throws Exception {
        this.activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        GerritUrlHandlerTest.assertNotNull((Object)this.activePage);
    }

    protected void tearDown() throws Exception {
        TestFixture.resetTaskListAndRepositories();
    }

    public void testOpenUrl() throws Exception {
        if (!GerritFixture.current().supportsAnonymousAccess()) {
            System.err.println("Skipping GerritUrlHandlerTest.testOpenUrl() due to lack of anonymous access");
            return;
        }
        TaskRepository repository = GerritFixture.current().singleRepository();
        repository.setCredentials(AuthenticationType.REPOSITORY, null, false);
        EditorHandle handler = BrowserUtil.openUrl((IWorkbenchPage)this.activePage, (String)(String.valueOf(repository.getUrl()) + "/1"), (int)0);
        GerritUrlHandlerTest.assertNull((String)"Expected an editor instance, got a browser instance", (Object)handler.getAdapter(IWebBrowser.class));
        long startTime = System.currentTimeMillis();
        Display display = PlatformUI.getWorkbench().getDisplay();
        while (!display.isDisposed()) {
            if (display.readAndDispatch()) continue;
            if (handler.await(500L, TimeUnit.MILLISECONDS)) break;
            GerritUrlHandlerTest.assertTrue((String)"Expected editor did not open within 30 seconds", (System.currentTimeMillis() - startTime < 30000L ? 1 : 0) != 0);
        }
        GerritUrlHandlerTest.assertEquals((Object)Status.OK_STATUS, (Object)handler.getStatus());
        GerritUrlHandlerTest.assertEquals(TaskEditor.class, this.activePage.getActiveEditor().getClass());
    }

    public void testOpenUrlInvalid() throws Exception {
        if (!PlatformUiUtil.hasInternalBrowser()) {
            System.err.println("Skipping GerritUrlHandlerTest.testOpenUrlInvalid() due to lack of browser support");
            return;
        }
        if (CommonTestUtil.skipBrowserTests()) {
            System.err.println("Skipping GerritUrlHandlerTest.testOpenUrlInvalid() to avoid browser crash");
            return;
        }
        TaskRepository repository = GerritFixture.GERRIT_NON_EXISTANT.singleRepository();
        EditorHandle handler = BrowserUtil.openUrl((IWorkbenchPage)this.activePage, (String)(String.valueOf(repository.getUrl()) + "/abc"), (int)0);
        GerritUrlHandlerTest.assertNotNull((String)("Expected a browser instance, got: " + handler.getClass()), (Object)handler.getAdapter(IWebBrowser.class));
        GerritUrlHandlerTest.assertEquals((Object)Status.OK_STATUS, (Object)handler.getStatus());
    }
}

