/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.gerrit.tests.support;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jgit.api.CommitCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.PushResult;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.eclipse.mylyn.commons.net.AuthenticationCredentials;
import org.eclipse.mylyn.commons.net.AuthenticationType;
import org.eclipse.mylyn.commons.sdk.util.CommonTestUtil;
import org.eclipse.mylyn.gerrit.tests.support.GerritFixture;
import org.junit.Test;

public class GerritProject {
    public static final String PROP_ALTERNATE_PUSH = "org.eclipse.mylyn.gerrit.tests.alternate.push";
    public static final String PROJECT = "org.eclipse.mylyn.test";
    private File folder;
    private Git git;
    private final GerritFixture fixture;

    public GerritProject(GerritFixture fixture) throws Exception {
        this.fixture = fixture;
    }

    public File getFolder() throws IOException {
        if (this.folder == null) {
            this.folder = CommonTestUtil.createTempFolder((String)"gerrit");
        }
        return this.folder;
    }

    private CredentialsProvider getCredentialsProvider(CommonTestUtil.PrivilegeLevel privilegeLevel) throws Exception {
        AuthenticationCredentials credentials = this.fixture.location(privilegeLevel).getCredentials(AuthenticationType.REPOSITORY);
        return new UsernamePasswordCredentialsProvider(this.getGitUsername(credentials), credentials.getPassword());
    }

    public String getGitUsername(AuthenticationCredentials credentials) {
        String shortUsername = StringUtils.substringBefore((String)credentials.getUserName(), (String)"@");
        return shortUsername;
    }

    public Git getGitProject() throws Exception {
        return this.getGitProject(CommonTestUtil.PrivilegeLevel.USER);
    }

    public Git getGitProject(CommonTestUtil.PrivilegeLevel privilegeLevel) throws Exception {
        if (this.git == null) {
            String url = String.valueOf(this.fixture.getRepositoryUrl()) + PROJECT;
            AuthenticationCredentials credentials = this.fixture.location(privilegeLevel).getCredentials(AuthenticationType.REPOSITORY);
            url = url.replace("://", "://" + this.getGitUsername(credentials) + ":" + credentials.getPassword() + "@");
            this.git = Git.cloneRepository().setDirectory(this.getFolder()).setURI(url).call();
        }
        return this.git;
    }

    public CommitResult commitAndPushFile(String message) throws Exception {
        return this.commitAndPushFile(message, "test.txt");
    }

    public CommitResult commitAndPushFile(String message, String fileName) throws Exception {
        this.addFile(fileName);
        CommitCommand command = this.getGitProject().commit().setAll(true).setInsertChangeId(true).setMessage(message);
        return this.commitAndPush(command);
    }

    public void addFile(String fileName) throws Exception {
        this.addFile(fileName, "this is line 1\nhere is another line\nline3");
    }

    public void addFile(String fileName, String text) throws Exception {
        Git gitProject = this.getGitProject();
        CommonTestUtil.write((String)new File(this.getFolder(), fileName).getAbsolutePath(), (StringBuffer)new StringBuffer(text));
        gitProject.add().addFilepattern(fileName).call();
    }

    public void addFile(String fileName, File file) throws Exception {
        Git gitProject = this.getGitProject();
        CommonTestUtil.copy((File)file, (File)new File(this.getFolder(), fileName));
        gitProject.add().addFilepattern(fileName).call();
    }

    public void removeFile(String fileName) throws Exception {
        Git gitProject = this.getGitProject();
        gitProject.rm().addFilepattern(fileName).call();
    }

    public CommitResult commitAndPush(CommitCommand command) throws Exception {
        return this.commitAndPush(command, "HEAD:refs/for/master", CommonTestUtil.PrivilegeLevel.USER);
    }

    public CommitResult commitAndPush(CommitCommand command, String refSpec, CommonTestUtil.PrivilegeLevel privilegeLevel) throws Exception {
        AuthenticationCredentials credentials = this.registerAuthenticator(privilegeLevel);
        String email = credentials.getUserName();
        RevCommit call = command.setAuthor("Test", email).setCommitter("Test", email).call();
        if (Boolean.getBoolean(PROP_ALTERNATE_PUSH)) {
            String username = StringUtils.substringBefore((String)email, (String)"@");
            String protocol = StringUtils.substringBefore((String)this.fixture.getRepositoryUrl(), (String)"://");
            String hostAndPath = StringUtils.substringAfter((String)this.fixture.getRepositoryUrl(), (String)"://");
            String project = "org.eclipse.mylyn.test/";
            String url = String.valueOf(protocol) + "://" + username + ":" + credentials.getPassword() + "@" + hostAndPath + project;
            File directory = command.getRepository().getDirectory().getParentFile();
            final String responseMessage = this.execute(directory, "git", "push", url, refSpec);
            System.out.println("Response message:");
            System.out.println(responseMessage);
            System.out.println("######");
            PushResult result = new PushResult(){

                public String getMessages() {
                    return responseMessage.toString();
                }
            };
            return new CommitResult(call, result);
        }
        Iterable result = ((PushCommand)this.git.push().setCredentialsProvider(this.getCredentialsProvider(privilegeLevel))).setRefSpecs(new RefSpec[]{new RefSpec(refSpec)}).call();
        return new CommitResult(call, (PushResult)result.iterator().next());
    }

    private String execute(File directory, String ... command) throws IOException {
        Process process = Runtime.getRuntime().exec(command, null, directory);
        StringBuilder responseMessage = new StringBuilder();
        try (BufferedReader r = new BufferedReader(new InputStreamReader(process.getErrorStream()));){
            String line;
            while ((line = r.readLine()) != null) {
                if (!line.startsWith("remote:")) {
                    line = line.replace('/', '\\');
                }
                responseMessage.append(line);
                responseMessage.append('\n');
            }
        }
        return responseMessage.toString();
    }

    public AuthenticationCredentials registerAuthenticator(CommonTestUtil.PrivilegeLevel privilegeLevel) throws Exception {
        AuthenticationCredentials credentials = this.fixture.location(privilegeLevel).getCredentials(AuthenticationType.REPOSITORY);
        final PasswordAuthentication authentication = new PasswordAuthentication(credentials.getUserName(), credentials.getPassword().toCharArray());
        Authenticator.setDefault(new Authenticator(){

            @Override
            protected PasswordAuthentication getPasswordAuthentication() {
                return authentication;
            }
        });
        return credentials;
    }

    public void dispose() {
        if (this.folder != null) {
            CommonTestUtil.deleteFolderRecursively((File)this.folder);
        }
    }

    public class CommitResult {
        public RevCommit commit;
        public PushResult push;

        private CommitResult(RevCommit commit, PushResult result) {
            this.commit = commit;
            this.push = result;
        }
    }

    public static class GerritProjectTest {
        @Test
        public void testCommitAndPushFile() throws Exception {
            GerritProject project = new GerritProject(GerritFixture.current());
            try {
                project.commitAndPushFile("test");
            }
            finally {
                System.err.println(project.getFolder());
            }
        }
    }
}

