/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.gerrit.tests.support;

import java.net.Proxy;
import org.apache.commons.lang.RandomStringUtils;
import org.eclipse.mylyn.commons.net.AbstractWebLocation;
import org.eclipse.mylyn.commons.net.IProxyProvider;
import org.eclipse.mylyn.commons.net.WebLocation;
import org.eclipse.mylyn.commons.net.WebUtil;
import org.eclipse.mylyn.commons.repositories.core.auth.UserCredentials;
import org.eclipse.mylyn.commons.sdk.util.CommonTestUtil;
import org.eclipse.mylyn.gerrit.tests.support.GerritFixture;
import org.eclipse.mylyn.gerrit.tests.support.GerritProject;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritClient;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.core.TaskRepository;

public class GerritHarness {
    private final GerritFixture fixture;
    private UserCredentials credentials;
    private GerritProject project;
    private final String uniqueMessage = RandomStringUtils.randomAlphabetic((int)6);

    public GerritHarness(GerritFixture fixture) {
        this.fixture = fixture;
    }

    public GerritClient client() {
        return this.client(CommonTestUtil.PrivilegeLevel.USER);
    }

    public GerritClient client(CommonTestUtil.PrivilegeLevel privilegeLevel) {
        TaskRepository repository = TasksUiPlugin.getRepositoryManager().getRepository(this.fixture.getRepositoryUrl());
        return GerritClient.create((TaskRepository)repository, (AbstractWebLocation)this.location(privilegeLevel));
    }

    public WebLocation location() {
        return this.location(CommonTestUtil.PrivilegeLevel.USER);
    }

    public WebLocation location(CommonTestUtil.PrivilegeLevel privilegeLevel) {
        this.readCredentials(privilegeLevel);
        String username = this.credentials.getUserName();
        String password = this.credentials.getPassword();
        if (!this.fixture.canAuthenticate()) {
            username = null;
            password = null;
        }
        WebLocation location = new WebLocation(this.fixture.getRepositoryUrl(), username, password, new IProxyProvider(){

            public Proxy getProxyForHost(String host, String proxyType) {
                return WebUtil.getProxyForUrl((String)GerritHarness.this.fixture.getRepositoryUrl());
            }
        });
        return location;
    }

    public GerritClient clientAnonymous() {
        TaskRepository repository = TasksUiPlugin.getRepositoryManager().getRepository(this.fixture.getRepositoryUrl());
        WebLocation location = new WebLocation(this.fixture.getRepositoryUrl(), null, null, new IProxyProvider(){

            public Proxy getProxyForHost(String host, String proxyType) {
                return WebUtil.getProxyForUrl((String)GerritHarness.this.fixture.getRepositoryUrl());
            }
        });
        return GerritClient.create((TaskRepository)repository, (AbstractWebLocation)location);
    }

    public void dispose() {
        if (this.project != null) {
            this.project.dispose();
        }
    }

    public UserCredentials readCredentials() {
        return this.readCredentials(CommonTestUtil.PrivilegeLevel.USER);
    }

    public UserCredentials readCredentials(CommonTestUtil.PrivilegeLevel privilegeLevel) {
        if (this.credentials == null) {
            this.credentials = CommonTestUtil.getCredentials((CommonTestUtil.PrivilegeLevel)privilegeLevel);
        }
        return this.credentials;
    }

    public GerritProject project() throws Exception {
        if (this.project == null) {
            this.project = new GerritProject(this.fixture);
        }
        return this.project;
    }

    public String defaultQuery() {
        return "message:" + this.uniqueMessage;
    }

    public void ensureOneReviewExists() throws Exception {
        this.project().commitAndPushFile(this.uniqueMessage);
    }
}

