/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.gerrit.tests.support;

import org.eclipse.mylyn.commons.repositories.core.auth.UserCredentials;
import org.eclipse.mylyn.commons.sdk.util.CommonTestUtil;
import org.eclipse.mylyn.commons.sdk.util.FixtureConfiguration;
import org.eclipse.mylyn.commons.sdk.util.TestConfiguration;
import org.eclipse.mylyn.gerrit.tests.support.GerritHarness;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritCapabilities;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritVersion;
import org.eclipse.mylyn.tests.util.TestFixture;
import org.osgi.framework.Version;

public class GerritFixture
extends TestFixture {
    @Deprecated
    public static GerritFixture GERRIT_ECLIPSE_ORG = new GerritFixture("https://git.eclipse.org/r", "2.2.2", "");
    public static GerritFixture GERRIT_NON_EXISTANT = new GerritFixture("http://mylyn.org/gerrit", "2.2.2", "");
    public static GerritFixture DEFAULT = (GerritFixture)((Object)TestConfiguration.getDefault().discoverDefault(GerritFixture.class, "gerrit"));
    private static GerritFixture current;
    private final boolean excluded;
    private boolean supportsAnonymousAccess;

    public GerritFixture(String url, String version, String description) {
        super("org.eclipse.mylyn.gerrit", url);
        this.setInfo(url, version, description);
        this.excluded = "Test".equals(description);
    }

    public GerritFixture(FixtureConfiguration configuration) {
        this(configuration.getUrl(), configuration.getVersion(), configuration.getInfo());
        this.supportsAnonymousAccess = "DEVELOPMENT_BECOME_ANY_ACCOUNT".equals(configuration.getProperties().get("authtype"));
    }

    public static GerritFixture current() {
        if (current == null) {
            DEFAULT.activate();
        }
        return current;
    }

    public static GerritFixture forVersion(int major, int minor) {
        GerritFixture fixture = TestConfiguration.getDefault().discover(GerritFixture.class, "gerrit", false).stream().filter(f -> f.getGerritVersion().getMinor() >= minor && f.getGerritVersion().getMajor() >= major).findFirst().get();
        fixture.activate();
        return fixture;
    }

    protected GerritFixture activate() {
        current = this;
        this.setUpFramework();
        return this;
    }

    protected GerritFixture getDefault() {
        return DEFAULT;
    }

    public GerritHarness harness() {
        return new GerritHarness(this);
    }

    public boolean canAuthenticate() {
        return true;
    }

    public boolean isExcluded() {
        return super.isExcluded() || this.excluded;
    }

    public boolean supportsAnonymousAccess() {
        return this.supportsAnonymousAccess;
    }

    public Version getGerritVersion() {
        String version = this.getSimpleInfo();
        if (version.indexOf(47) != -1) {
            version = version.substring(0, version.indexOf(47));
        }
        return GerritVersion.parseGerritVersion((String)version);
    }

    public GerritCapabilities getCapabilities() {
        return new GerritCapabilities(this.getGerritVersion());
    }

    public UserCredentials getCredentials(CommonTestUtil.PrivilegeLevel level) {
        if (level == CommonTestUtil.PrivilegeLevel.ADMIN) {
            UserCredentials credentials = super.getCredentials(CommonTestUtil.PrivilegeLevel.USER);
            return new UserCredentials("admin@mylyn.eclipse.org", credentials.getPassword());
        }
        return super.getCredentials(level);
    }
}

