/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.gerrit.tests.core.client.rest;

import java.io.File;
import java.io.IOException;
import junit.framework.TestCase;
import org.eclipse.mylyn.commons.sdk.util.CommonTestUtil;
import org.eclipse.mylyn.internal.gerrit.core.client.JSonSupport;
import org.eclipse.mylyn.internal.gerrit.core.client.rest.ReviewerInput;
import org.junit.Test;

public class ReviewerInputTest
extends TestCase {
    @Test
    public void testFromNull() throws Exception {
        try {
            new ReviewerInput(null);
            ReviewerInputTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testFromEmpty() throws Exception {
        try {
            new ReviewerInput("");
            ReviewerInputTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testFromValid() throws Exception {
        ReviewerInput reviewerInput = new ReviewerInput("john.doe@example.com");
        String json = new JSonSupport().toJson((Object)reviewerInput);
        ReviewerInputTest.assertNotNull((Object)json);
        ReviewerInputTest.assertFalse((boolean)json.isEmpty());
        ReviewerInputTest.assertEquals((String)this.readFile("testdata/ReviewerInput_johnDoe.json"), (String)json);
    }

    private String readFile(String path) throws IOException {
        File file = CommonTestUtil.getFile((Object)((Object)this), (String)path);
        return CommonTestUtil.read((File)file);
    }
}

