/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.gerrit.tests.core.client.rest;

import com.google.gerrit.common.data.AccountInfo;
import com.google.gerrit.common.data.ApprovalDetail;
import com.google.gerrit.reviewdb.Account;
import com.google.gerrit.reviewdb.Change;
import com.google.gerrit.reviewdb.PatchSet;
import com.google.gerrit.reviewdb.PatchSetApproval;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import junit.framework.TestCase;
import org.eclipse.mylyn.commons.sdk.util.CommonTestUtil;
import org.eclipse.mylyn.internal.gerrit.core.client.JSonSupport;
import org.eclipse.mylyn.internal.gerrit.core.client.rest.ApprovalUtil;
import org.eclipse.mylyn.internal.gerrit.core.client.rest.ReviewerInfo;
import org.junit.Test;

public class ReviewerInfoTest
extends TestCase {
    @Test
    public void testFromEmptyJson() throws Exception {
        ReviewerInfo reviewerInfo = this.parseFile("testdata/EmptyWithMagic.json");
        ReviewerInfoTest.assertNotNull((Object)reviewerInfo);
        ReviewerInfoTest.assertEquals((String)"gerritcodereview#reviewer", (String)reviewerInfo.getKind());
        ReviewerInfoTest.assertNull((Object)reviewerInfo.getApprovals());
        ReviewerInfoTest.assertEquals((int)-1, (int)reviewerInfo.getId());
        ReviewerInfoTest.assertNull((Object)reviewerInfo.getName());
        ReviewerInfoTest.assertNull((Object)reviewerInfo.getEmail());
        ReviewerInfoTest.assertNull((Object)reviewerInfo.getUsername());
    }

    @Test
    public void testFromInvalid() throws Exception {
        ReviewerInfo reviewerInfo = this.parseFile("testdata/InvalidWithMagic.json");
        ReviewerInfoTest.assertNotNull((Object)reviewerInfo);
        ReviewerInfoTest.assertEquals((String)"gerritcodereview#reviewer", (String)reviewerInfo.getKind());
        ReviewerInfoTest.assertNull((Object)reviewerInfo.getApprovals());
        ReviewerInfoTest.assertEquals((int)-1, (int)reviewerInfo.getId());
        ReviewerInfoTest.assertNull((Object)reviewerInfo.getName());
        ReviewerInfoTest.assertNull((Object)reviewerInfo.getEmail());
        ReviewerInfoTest.assertNull((Object)reviewerInfo.getUsername());
    }

    @Test
    public void testFromValid() throws IOException {
        ReviewerInfo reviewerInfo = this.parseFile("testdata/ReviewerInfo_JohnDoePlusTwo.json");
        ReviewerInfoTest.assertEquals((String)"gerritcodereview#reviewer", (String)reviewerInfo.getKind());
        Map approvals = reviewerInfo.getApprovals();
        ReviewerInfoTest.assertNotNull((Object)approvals);
        ReviewerInfoTest.assertFalse((boolean)approvals.isEmpty());
        ReviewerInfoTest.assertEquals((int)2, (int)approvals.size());
        ReviewerInfoTest.assertEquals((String)"+1", (String)((String)approvals.get("Verified")));
        ReviewerInfoTest.assertEquals((String)"+2", (String)((String)approvals.get("Code-Review")));
        ReviewerInfoTest.assertEquals((int)1000096, (int)reviewerInfo.getId());
        ReviewerInfoTest.assertEquals((String)"John Doe", (String)reviewerInfo.getName());
        ReviewerInfoTest.assertEquals((String)"john.doe@example.com", (String)reviewerInfo.getEmail());
        ReviewerInfoTest.assertNull((Object)reviewerInfo.getUsername());
        PatchSet dummyPatchSet = new PatchSet(new PatchSet.Id(new Change.Id(1), 1));
        ApprovalDetail approvalDetail = reviewerInfo.toApprovalDetail(dummyPatchSet);
        ReviewerInfoTest.assertNotNull((Object)approvalDetail);
        ReviewerInfoTest.assertEquals((Object)new Account.Id(1000096), (Object)approvalDetail.getAccount());
        Map approvalMap = approvalDetail.getApprovalMap();
        ReviewerInfoTest.assertNotNull((Object)approvalMap);
        ReviewerInfoTest.assertEquals((int)2, (int)approvalMap.size());
        PatchSetApproval crvw = (PatchSetApproval)approvalMap.get(ApprovalUtil.CRVW.getCategory().getId());
        ReviewerInfoTest.assertNotNull((Object)crvw);
        ReviewerInfoTest.assertEquals((int)1000096, (int)crvw.getAccountId().get());
        ReviewerInfoTest.assertEquals((int)2, (int)crvw.getValue());
        PatchSetApproval vrif = (PatchSetApproval)approvalMap.get(ApprovalUtil.VRIF.getCategory().getId());
        ReviewerInfoTest.assertNotNull((Object)vrif);
        ReviewerInfoTest.assertEquals((int)1000096, (int)vrif.getAccountId().get());
        ReviewerInfoTest.assertEquals((int)1, (int)vrif.getValue());
        AccountInfo accountInfo = reviewerInfo.toAccountInfo();
        ReviewerInfoTest.assertNotNull((Object)accountInfo);
        ReviewerInfoTest.assertEquals((int)1000096, (int)accountInfo.getId().get());
        ReviewerInfoTest.assertEquals((String)"john.doe@example.com", (String)accountInfo.getPreferredEmail());
        ReviewerInfoTest.assertEquals((String)"John Doe", (String)accountInfo.getFullName());
    }

    private ReviewerInfo parseFile(String path) throws IOException {
        File file = CommonTestUtil.getFile((Object)((Object)this), (String)path);
        String content = CommonTestUtil.read((File)file);
        return (ReviewerInfo)new JSonSupport().parseResponse(content, ReviewerInfo.class);
    }
}

