/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.gerrit.tests.core.client.rest;

import com.google.gerrit.reviewdb.ApprovalCategoryValue;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import junit.framework.TestCase;
import org.eclipse.mylyn.commons.sdk.util.CommonTestUtil;
import org.eclipse.mylyn.internal.gerrit.core.client.JSonSupport;
import org.eclipse.mylyn.internal.gerrit.core.client.rest.ApprovalUtil;
import org.eclipse.mylyn.internal.gerrit.core.client.rest.ReviewInput;
import org.junit.Test;

public class ReviewInputTest
extends TestCase {
    @Test
    public void testFromNull() throws Exception {
        try {
            new ReviewInput(null);
            ReviewInputTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testFromEmpty() throws Exception {
        ReviewInput reviewInput = new ReviewInput("");
        String json = new JSonSupport().toJson((Object)reviewInput);
        ReviewInputTest.assertNotNull((Object)json);
        ReviewInputTest.assertFalse((boolean)json.isEmpty());
        ReviewInputTest.assertEquals((String)this.readFile("testdata/ReviewInput_emptyMessage.json"), (String)json);
    }

    @Test
    public void testFromValid() throws Exception {
        ReviewInput reviewInput = new ReviewInput("Looking good!");
        String json = new JSonSupport().toJson((Object)reviewInput);
        ReviewInputTest.assertNotNull((Object)json);
        ReviewInputTest.assertFalse((boolean)json.isEmpty());
        ReviewInputTest.assertEquals((String)this.readFile("testdata/ReviewInput_message.json"), (String)json);
    }

    @Test
    public void testSetNullApprovals() throws Exception {
        ReviewInput reviewInput = new ReviewInput("");
        reviewInput.setApprovals(null);
        String json = new JSonSupport().toJson((Object)reviewInput);
        ReviewInputTest.assertNotNull((Object)json);
        ReviewInputTest.assertFalse((boolean)json.isEmpty());
        ReviewInputTest.assertEquals((String)this.readFile("testdata/ReviewInput_emptyMessage.json"), (String)json);
    }

    @Test
    public void testSetEmptyApprovals() throws Exception {
        ReviewInput reviewInput = new ReviewInput("");
        reviewInput.setApprovals(Collections.emptySet());
        String json = new JSonSupport().toJson((Object)reviewInput);
        ReviewInputTest.assertNotNull((Object)json);
        ReviewInputTest.assertFalse((boolean)json.isEmpty());
        ReviewInputTest.assertEquals((String)this.readFile("testdata/ReviewInput_emptyMessage.json"), (String)json);
    }

    @Test
    public void testSetApprovals() throws Exception {
        ReviewInput reviewInput = new ReviewInput("");
        HashSet<ApprovalCategoryValue.Id> approvals = new HashSet<ApprovalCategoryValue.Id>(1);
        approvals.add(ApprovalUtil.CRVW.getValue((short)1).getId());
        reviewInput.setApprovals(approvals);
        String json = new JSonSupport().toJson((Object)reviewInput);
        ReviewInputTest.assertNotNull((Object)json);
        ReviewInputTest.assertFalse((boolean)json.isEmpty());
        ReviewInputTest.assertEquals((String)this.readFile("testdata/ReviewInput_emptyMessageCodeReviewPlusOne.json"), (String)json);
    }

    private String readFile(String path) throws IOException {
        File file = CommonTestUtil.getFile((Object)((Object)this), (String)path);
        return CommonTestUtil.read((File)file);
    }
}

