/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.gerrit.tests.core.client.rest;

import java.io.File;
import java.io.IOException;
import junit.framework.TestCase;
import org.eclipse.mylyn.commons.sdk.util.CommonTestUtil;
import org.eclipse.mylyn.internal.gerrit.core.client.JSonSupport;
import org.eclipse.mylyn.internal.gerrit.core.client.rest.ReviewInfo;
import org.junit.Test;

public class ReviewInfoTest
extends TestCase {
    @Test
    public void testFromEmptyJson() throws Exception {
        ReviewInfo reviewInfo = this.parseFile("testdata/EmptyWithMagic.json");
        ReviewInfoTest.assertNotNull((Object)reviewInfo);
        ReviewInfoTest.assertNull((Object)reviewInfo.getLabels());
    }

    @Test
    public void testFromInvalid() throws Exception {
        ReviewInfo reviewInfo = this.parseFile("testdata/InvalidWithMagic.json");
        ReviewInfoTest.assertNotNull((Object)reviewInfo);
        ReviewInfoTest.assertNull((Object)reviewInfo.getLabels());
    }

    @Test
    public void testFromCodeReviewMinusOne() throws Exception {
        ReviewInfo reviewInfo = this.parseFile("testdata/ReviewInfo_codeReviewMinusOne.json");
        ReviewInfoTest.assertNotNull((Object)reviewInfo);
        ReviewInfoTest.assertNotNull((Object)reviewInfo.getLabels());
        ReviewInfoTest.assertFalse((boolean)reviewInfo.getLabels().isEmpty());
        ReviewInfoTest.assertNotNull(reviewInfo.getLabels().get("Code-Review"));
        ReviewInfoTest.assertEquals((int)-1, (int)((Short)reviewInfo.getLabels().get("Code-Review")).shortValue());
    }

    @Test
    public void testFromVerifyZero() throws Exception {
        ReviewInfo reviewInfo = this.parseFile("testdata/ReviewInfo_verifyZero.json");
        ReviewInfoTest.assertNotNull((Object)reviewInfo);
        ReviewInfoTest.assertNotNull((Object)reviewInfo.getLabels());
        ReviewInfoTest.assertFalse((boolean)reviewInfo.getLabels().isEmpty());
        ReviewInfoTest.assertNotNull(reviewInfo.getLabels().get("Verify"));
        ReviewInfoTest.assertEquals((int)0, (int)((Short)reviewInfo.getLabels().get("Verify")).shortValue());
    }

    private ReviewInfo parseFile(String path) throws IOException {
        File file = CommonTestUtil.getFile((Object)((Object)this), (String)path);
        String content = CommonTestUtil.read((File)file);
        return (ReviewInfo)new JSonSupport().parseResponse(content, ReviewInfo.class);
    }
}

