/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.gerrit.tests.core.client.rest;

import java.io.File;
import java.io.IOException;
import junit.framework.TestCase;
import org.eclipse.mylyn.commons.sdk.util.CommonTestUtil;
import org.eclipse.mylyn.internal.gerrit.core.client.JSonSupport;
import org.eclipse.mylyn.internal.gerrit.core.client.rest.RestoreInput;
import org.junit.Test;

public class RestoreInputTest
extends TestCase {
    @Test(expected=IllegalArgumentException.class)
    public void testFromNull() throws Exception {
        try {
            new RestoreInput(null);
            RestoreInputTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testFromEmpty() throws Exception {
        RestoreInput restoreInput = new RestoreInput("");
        String json = new JSonSupport().toJson((Object)restoreInput);
        RestoreInputTest.assertNotNull((Object)json);
        RestoreInputTest.assertFalse((boolean)json.isEmpty());
        RestoreInputTest.assertEquals((String)this.readFile("testdata/EmptyMessage.json"), (String)json);
    }

    @Test
    public void testFromValid() throws Exception {
        RestoreInput restoreInput = new RestoreInput("Whatever");
        String json = new JSonSupport().toJson((Object)restoreInput);
        RestoreInputTest.assertNotNull((Object)json);
        RestoreInputTest.assertFalse((boolean)json.isEmpty());
        RestoreInputTest.assertEquals((String)this.readFile("testdata/Message.json"), (String)json);
    }

    private String readFile(String path) throws IOException {
        File file = CommonTestUtil.getFile((Object)((Object)this), (String)path);
        return CommonTestUtil.read((File)file);
    }
}

