/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.gerrit.tests.core.client.rest;

import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import junit.framework.TestCase;
import org.eclipse.mylyn.commons.sdk.util.CommonTestUtil;
import org.eclipse.mylyn.internal.gerrit.core.client.JSonSupport;
import org.eclipse.mylyn.internal.gerrit.core.client.rest.ProjectInfo;
import org.junit.Test;

public class ProjectInfoTest
extends TestCase {
    @Test
    public void testFromEmptyJson() throws Exception {
        ProjectInfo projectInfo = this.parseFile("testdata/EmptyWithMagic.json");
        ProjectInfoTest.assertNotNull((Object)projectInfo);
        ProjectInfoTest.assertNull((Object)projectInfo.getKind());
        ProjectInfoTest.assertNull((Object)projectInfo.getId());
        ProjectInfoTest.assertNull((Object)projectInfo.getName());
        ProjectInfoTest.assertNull((Object)projectInfo.getParent());
        ProjectInfoTest.assertNull((Object)projectInfo.getDescription());
    }

    @Test
    public void testFromInvalid() throws Exception {
        ProjectInfo projectInfo = this.parseFile("testdata/InvalidWithMagic.json");
        ProjectInfoTest.assertNotNull((Object)projectInfo);
        ProjectInfoTest.assertNull((Object)projectInfo.getKind());
        ProjectInfoTest.assertNull((Object)projectInfo.getId());
        ProjectInfoTest.assertNull((Object)projectInfo.getName());
        ProjectInfoTest.assertNull((Object)projectInfo.getParent());
        ProjectInfoTest.assertNull((Object)projectInfo.getDescription());
    }

    @Test
    public void testFromSingleProject() throws Exception {
        ProjectInfo projectInfo = this.parseFile("testdata/ProjectInfo_project.json");
        ProjectInfoTest.assertNotNull((Object)projectInfo);
        ProjectInfoTest.assertEquals((String)"gerritcodereview#project", (String)projectInfo.getKind());
        ProjectInfoTest.assertEquals((String)"plugins%2Freplication", (String)projectInfo.getId());
        ProjectInfoTest.assertEquals((String)"plugins/replication", (String)projectInfo.getName());
        ProjectInfoTest.assertEquals((String)"Public-Plugins", (String)projectInfo.getParent());
        ProjectInfoTest.assertEquals((String)"Copies to other servers using the Git protocol", (String)projectInfo.getDescription());
    }

    @Test
    public void testFromProjects() throws Exception {
        File file = CommonTestUtil.getFile((Object)((Object)this), (String)"testdata/ProjectInfo_projects.json");
        TypeToken<Map<String, ProjectInfo>> resultType = new TypeToken<Map<String, ProjectInfo>>(){};
        String content = CommonTestUtil.read((File)file);
        Map projects = (Map)new JSonSupport().parseResponse(content, resultType.getType());
        ProjectInfoTest.assertNotNull((Object)projects);
        ProjectInfoTest.assertEquals((int)4, (int)projects.size());
        ProjectInfoTest.assertProjectInfo((ProjectInfo)projects.get("external/bison"), "external%2Fbison", "GNU parser generator");
        ProjectInfoTest.assertProjectInfo((ProjectInfo)projects.get("external/gcc"), "external%2Fgcc", null);
        ProjectInfoTest.assertProjectInfo((ProjectInfo)projects.get("external/openssl"), "external%2Fopenssl", "encryption\ncrypto routines");
        ProjectInfoTest.assertProjectInfo((ProjectInfo)projects.get("test"), "test", "<html> is escaped");
    }

    private ProjectInfo parseFile(String path) throws IOException {
        File file = CommonTestUtil.getFile((Object)((Object)this), (String)path);
        String content = CommonTestUtil.read((File)file);
        return (ProjectInfo)new JSonSupport().parseResponse(content, ProjectInfo.class);
    }

    private static void assertProjectInfo(ProjectInfo project, String id, String desc) {
        ProjectInfoTest.assertNotNull((Object)project);
        ProjectInfoTest.assertEquals((String)"gerritcodereview#project", (String)project.getKind());
        ProjectInfoTest.assertEquals((String)id, (String)project.getId());
        ProjectInfoTest.assertNull((Object)project.getName());
        ProjectInfoTest.assertNull((Object)project.getParent());
        ProjectInfoTest.assertEquals((String)desc, (String)project.getDescription());
    }
}

