/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.gerrit.tests.core.client.rest;

import java.io.File;
import java.io.IOException;
import junit.framework.TestCase;
import org.eclipse.mylyn.commons.sdk.util.CommonTestUtil;
import org.eclipse.mylyn.internal.gerrit.core.client.JSonSupport;
import org.eclipse.mylyn.internal.gerrit.core.client.rest.CommentInput;
import org.junit.Test;

public class CommentInputTest
extends TestCase {
    @Test
    public void testFromEmptyJson() throws Exception {
        CommentInput CommentInput2 = this.parseFile("testdata/EmptyWithMagic.json");
        CommentInputTest.assertNotNull((Object)CommentInput2);
        CommentInputTest.assertNull((Object)CommentInput2.getId());
        CommentInputTest.assertEquals((String)"gerritcodereview#comment", (String)CommentInput2.getKind());
        CommentInputTest.assertNull((Object)CommentInput2.getMessage());
        CommentInputTest.assertNull((Object)CommentInput2.getPath());
        CommentInputTest.assertEquals((int)0, (int)CommentInput2.getLine());
    }

    @Test
    public void testFromInvalid() throws Exception {
        CommentInput CommentInput2 = this.parseFile("testdata/InvalidWithMagic.json");
        CommentInputTest.assertNotNull((Object)CommentInput2);
        CommentInputTest.assertNull((Object)CommentInput2.getId());
        CommentInputTest.assertEquals((String)"gerritcodereview#comment", (String)CommentInput2.getKind());
        CommentInputTest.assertNull((Object)CommentInput2.getMessage());
        CommentInputTest.assertNull((Object)CommentInput2.getPath());
        CommentInputTest.assertEquals((int)0, (int)CommentInput2.getLine());
    }

    @Test
    public void testFromCodeReviewMinusOne() throws Exception {
        CommentInput CommentInput2 = this.parseFile("testdata/CommentInput_draft.json");
        CommentInputTest.assertNotNull((Object)CommentInput2);
        CommentInputTest.assertEquals((String)"gerritcodereview#comment", (String)CommentInput2.getKind());
        CommentInputTest.assertEquals((String)"daeb3561_e122c600", (String)CommentInput2.getId());
        CommentInputTest.assertEquals((String)"Line 2 Comment", (String)CommentInput2.getMessage());
        CommentInputTest.assertEquals((int)2, (int)CommentInput2.getLine());
    }

    private CommentInput parseFile(String path) throws IOException {
        File file = CommonTestUtil.getFile((Object)((Object)this), (String)path);
        String content = CommonTestUtil.read((File)file);
        return (CommentInput)new JSonSupport().parseResponse(content, CommentInput.class);
    }
}

