/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.gerrit.tests.core.client.rest;

import com.google.gerrit.common.data.ApprovalDetail;
import com.google.gerrit.common.data.ApprovalType;
import com.google.gerrit.reviewdb.Account;
import com.google.gerrit.reviewdb.ApprovalCategoryValue;
import com.google.gerrit.reviewdb.Change;
import com.google.gerrit.reviewdb.PatchSet;
import com.google.gerrit.reviewdb.PatchSetApproval;
import java.io.File;
import java.io.IOException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import junit.framework.TestCase;
import org.eclipse.mylyn.commons.sdk.util.CommonTestUtil;
import org.eclipse.mylyn.gerrit.tests.core.client.rest.IsEmpty;
import org.eclipse.mylyn.internal.gerrit.core.client.JSonSupport;
import org.eclipse.mylyn.internal.gerrit.core.client.compat.PermissionLabel;
import org.eclipse.mylyn.internal.gerrit.core.client.rest.AccountInfo;
import org.eclipse.mylyn.internal.gerrit.core.client.rest.ApprovalInfo;
import org.eclipse.mylyn.internal.gerrit.core.client.rest.ApprovalUtil;
import org.eclipse.mylyn.internal.gerrit.core.client.rest.ChangeInfo;
import org.eclipse.mylyn.internal.gerrit.core.client.rest.LabelInfo;
import org.eclipse.mylyn.internal.gerrit.core.client.rest.RevisionInfo;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsNot;
import org.junit.Assert;
import org.junit.Test;

public class ChangeInfoTest
extends TestCase {
    @Test
    public void testFromEmptyJson() throws Exception {
        ChangeInfo changeInfo = this.parseFile("testdata/EmptyWithMagic.json");
        ChangeInfoTest.assertNotNull((Object)changeInfo);
        ChangeInfoTest.assertNull((Object)changeInfo.getKind());
        ChangeInfoTest.assertNull((Object)changeInfo.getId());
        ChangeInfoTest.assertNull((Object)changeInfo.getProject());
        ChangeInfoTest.assertNull((Object)changeInfo.getBranch());
        ChangeInfoTest.assertNull((Object)changeInfo.getTopic());
        ChangeInfoTest.assertNull((Object)changeInfo.getChangeId());
        ChangeInfoTest.assertNull((Object)changeInfo.getSubject());
        ChangeInfoTest.assertNull((Object)changeInfo.getStatus());
        ChangeInfoTest.assertNull((Object)changeInfo.getCreated());
        ChangeInfoTest.assertNull((Object)changeInfo.getUpdated());
        ChangeInfoTest.assertEquals((boolean)false, (boolean)changeInfo.isReviewed());
        ChangeInfoTest.assertEquals((boolean)false, (boolean)changeInfo.isMergeable());
        ChangeInfoTest.assertNull((Object)changeInfo.getOwner());
    }

    @Test
    public void testFromInvalid() throws Exception {
        ChangeInfo changeInfo = this.parseFile("testdata/InvalidWithMagic.json");
        ChangeInfoTest.assertNotNull((Object)changeInfo);
        ChangeInfoTest.assertNotNull((Object)changeInfo);
        ChangeInfoTest.assertNull((Object)changeInfo.getKind());
        ChangeInfoTest.assertNull((Object)changeInfo.getId());
        ChangeInfoTest.assertNull((Object)changeInfo.getProject());
        ChangeInfoTest.assertNull((Object)changeInfo.getBranch());
        ChangeInfoTest.assertNull((Object)changeInfo.getTopic());
        ChangeInfoTest.assertNull((Object)changeInfo.getChangeId());
        ChangeInfoTest.assertNull((Object)changeInfo.getSubject());
        ChangeInfoTest.assertNull((Object)changeInfo.getStatus());
        ChangeInfoTest.assertNull((Object)changeInfo.getCreated());
        ChangeInfoTest.assertNull((Object)changeInfo.getUpdated());
        ChangeInfoTest.assertEquals((boolean)false, (boolean)changeInfo.isReviewed());
        ChangeInfoTest.assertEquals((boolean)false, (boolean)changeInfo.isMergeable());
        ChangeInfoTest.assertNull((Object)changeInfo.getOwner());
    }

    @Test
    public void testFromAbandoned() throws Exception {
        ChangeInfo changeInfo = this.parseFile("testdata/ChangeInfo_abandoned.json");
        ChangeInfoTest.assertNotNull((Object)changeInfo);
        ChangeInfoTest.assertEquals((String)changeInfo.getKind(), (String)"gerritcodereview#change");
        ChangeInfoTest.assertEquals((String)changeInfo.getId(), (String)"myProject~master~I8473b95934b5732ac55d26311a706c9c2bde9940");
        ChangeInfoTest.assertEquals((String)changeInfo.getProject(), (String)"myProject");
        ChangeInfoTest.assertEquals((String)changeInfo.getBranch(), (String)"master");
        ChangeInfoTest.assertEquals((String)changeInfo.getTopic(), (String)"My Topic");
        ChangeInfoTest.assertEquals((String)"I8473b95934b5732ac55d26311a706c9c2bde9940", (String)changeInfo.getChangeId());
        ChangeInfoTest.assertEquals((String)"Implementing Feature X", (String)changeInfo.getSubject());
        ChangeInfoTest.assertEquals((Object)Change.Status.ABANDONED, (Object)changeInfo.getStatus());
        ChangeInfoTest.assertEquals((Object)ChangeInfoTest.timestamp("2013-02-01 09:59:32.126"), (Object)changeInfo.getCreated());
        ChangeInfoTest.assertEquals((Object)ChangeInfoTest.timestamp("2013-02-21 11:16:36.775"), (Object)changeInfo.getUpdated());
        ChangeInfoTest.assertEquals((boolean)true, (boolean)changeInfo.isReviewed());
        ChangeInfoTest.assertEquals((boolean)true, (boolean)changeInfo.isMergeable());
        AccountInfo changeOwner = changeInfo.getOwner();
        ChangeInfoTest.assertNotNull((Object)changeOwner);
        ChangeInfoTest.assertEquals((String)"John Doe", (String)changeOwner.getName());
        ChangeInfoTest.assertNull((Object)changeOwner.getEmail());
        ChangeInfoTest.assertNull((Object)changeOwner.getUsername());
        ChangeInfoTest.assertEquals((int)-1, (int)changeOwner.getId());
    }

    @Test
    public void testNewChangeInfo() {
        ChangeInfo changeInfo = new ChangeInfo();
        Assert.assertThat((Object)changeInfo.getLabels(), (Matcher)Matchers.nullValue());
        Assert.assertThat((Object)changeInfo.convertToApprovalDetails(), IsEmpty.empty());
        Assert.assertThat((Object)changeInfo.convertToApprovalTypes(), (Matcher)Matchers.nullValue());
        Assert.assertThat((Object)changeInfo.getRevisions(), (Matcher)Matchers.nullValue());
    }

    @Test
    public void testNoReviews() throws Exception {
        ChangeInfo changeInfo = this.parseFile("testdata/ChangeInfo_NoReviews.json");
        ChangeInfoTest.assertHasCodeReviewLabels(changeInfo);
        Assert.assertThat((Object)((LabelInfo)changeInfo.getLabels().get("Code-Review")).getAll(), (Matcher)Matchers.nullValue());
        Assert.assertThat((Object)changeInfo.convertToApprovalDetails(), IsEmpty.empty());
        ChangeInfoTest.assertHasCodeReviewApprovalType(changeInfo.convertToApprovalTypes());
        ChangeInfoTest.assertHasRevisions(changeInfo, 1);
        Account account = new Account(new Account.Id(1000001));
        PatchSet.Id patchSetId = ChangeInfoTest.createCurrentPatchSetId(2, 1);
        Assert.assertThat((Object)changeInfo.convertToPatchSetApprovals(patchSetId, account), IsEmpty.empty());
    }

    @Test
    public void testCodeReviewMinusOne() throws IOException {
        ChangeInfo changeInfo = this.parseFile("testdata/ChangeInfo_CodeReviewMinusOne.json");
        ChangeInfoTest.assertHasCodeReviewLabels(changeInfo);
        ChangeInfoTest.assertHasApprovalInfo(((LabelInfo)changeInfo.getLabels().get("Code-Review")).getAll(), -1);
        ChangeInfoTest.assertHasApprovalDetail(changeInfo.convertToApprovalDetails(), -1);
        ChangeInfoTest.assertHasCodeReviewApprovalType(changeInfo.convertToApprovalTypes());
        ChangeInfoTest.assertHasCodeReviewPermissionLabels(changeInfo);
        ChangeInfoTest.assertHasRevisions(changeInfo, 1);
        ChangeInfoTest.assertGiven(changeInfo, ChangeInfoTest.createCurrentPatchSetId(2, 1), 1000001, -1);
    }

    @Test
    public void testTwoRevisions() throws IOException {
        ChangeInfo changeInfo = this.parseFile("testdata/ChangeInfo_TwoRevisions.json");
        ChangeInfoTest.assertHasCodeReviewLabels(changeInfo);
        ChangeInfoTest.assertHasApprovalInfo(((LabelInfo)changeInfo.getLabels().get("Code-Review")).getAll(), 0);
        ChangeInfoTest.assertHasApprovalDetail(changeInfo.convertToApprovalDetails(), 0);
        ChangeInfoTest.assertHasCodeReviewApprovalType(changeInfo.convertToApprovalTypes());
        ChangeInfoTest.assertHasRevisions(changeInfo, 2);
        ChangeInfoTest.assertGiven(changeInfo, ChangeInfoTest.createCurrentPatchSetId(1, 2), 1000001, 0);
    }

    @Test
    public void testThreeApprovalTypes() throws IOException {
        ChangeInfo changeInfo = this.parseFile("testdata/ChangeInfo_ThreeApprovalTypes.json");
        Map labels = changeInfo.getLabels();
        ChangeInfoTest.assertNotNull((Object)labels);
        ChangeInfoTest.assertEquals((int)3, (int)labels.size());
        Set approvalTypes = changeInfo.convertToApprovalTypes();
        ChangeInfoTest.assertNotNull((Object)approvalTypes);
        ChangeInfoTest.assertEquals((int)3, (int)approvalTypes.size());
        Iterator it = approvalTypes.iterator();
        ChangeInfoTest.assertCategoriesEqual(ApprovalUtil.VRIF, (ApprovalType)it.next());
        ChangeInfoTest.assertCategoriesEqual(ApprovalUtil.CRVW, (ApprovalType)it.next());
        ChangeInfoTest.assertCategoriesEqual(ApprovalUtil.IPCL, (ApprovalType)it.next());
        PatchSet.Id patchSetId = ChangeInfoTest.createCurrentPatchSetId(12850, -1);
        ChangeInfoTest.assertGiven(changeInfo, patchSetId, 4, -1, 0, -1);
        ChangeInfoTest.assertGiven(changeInfo, patchSetId, 118, 0, 0, 0);
        ChangeInfoTest.assertGiven(changeInfo, patchSetId, 442, 0, 1, 0);
    }

    @Test
    public void testCustomApprovalType() throws IOException {
        ChangeInfo changeInfo = this.parseFile("testdata/ChangeInfo_CustomApprovalType.json");
        Map labels = changeInfo.getLabels();
        ChangeInfoTest.assertNotNull((Object)labels);
        ChangeInfoTest.assertEquals((int)2, (int)labels.size());
        Set approvalTypes = changeInfo.convertToApprovalTypes();
        ChangeInfoTest.assertNotNull((Object)approvalTypes);
        ChangeInfoTest.assertEquals((int)2, (int)approvalTypes.size());
        Iterator it = approvalTypes.iterator();
        ChangeInfoTest.assertCategoriesEqual(ApprovalUtil.CRVW, (ApprovalType)it.next());
        ApprovalType custom = (ApprovalType)it.next();
        ChangeInfoTest.assertEquals((String)"Non-Author-Code-Review", (String)custom.getCategory().getName());
        ChangeInfoTest.assertNull((Object)custom.getCategory().getAbbreviatedName());
        ChangeInfoTest.assertTrue((boolean)custom.getValues().isEmpty());
        Account account = new Account(new Account.Id(1000001));
        PatchSet.Id patchSetId = ChangeInfoTest.createCurrentPatchSetId(1, -1);
        Assert.assertThat((Object)changeInfo.convertToPatchSetApprovals(patchSetId, account), IsEmpty.empty());
    }

    public static void assertHasCodeReviewLabels(ChangeInfo changeInfo) {
        ChangeInfoTest.assertHasCodeReviewLabels(changeInfo, false);
    }

    public static void assertHasCodeReviewLabels(ChangeInfo changeInfo, boolean version29) {
        Assert.assertThat((Object)changeInfo, (Matcher)Matchers.notNullValue());
        Map labels = changeInfo.getLabels();
        Assert.assertThat((Object)labels, (Matcher)IsNot.not(IsEmpty.empty()));
        Assert.assertThat((Object)labels.size(), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)labels, (Matcher)Matchers.hasKey((Object)"Code-Review"));
        Map values = ((LabelInfo)labels.get("Code-Review")).getValues();
        Assert.assertThat((Object)values, (Matcher)IsNot.not(IsEmpty.empty()));
        Assert.assertThat((Object)values.size(), (Matcher)Matchers.is((Object)5));
        Assert.assertThat((Object)values, (Matcher)Matchers.hasKey((Object)"-2"));
        Assert.assertThat((Object)values, (Matcher)Matchers.hasKey((Object)"-1"));
        Assert.assertThat((Object)values, (Matcher)Matchers.hasKey((Object)" 0"));
        Assert.assertThat((Object)values, (Matcher)Matchers.hasKey((Object)"+1"));
        Assert.assertThat((Object)values, (Matcher)Matchers.hasKey((Object)"+2"));
        if (version29) {
            Assert.assertThat((Object)((String)values.get("-2")), (Matcher)Matchers.equalTo((Object)"This shall not be merged"));
            Assert.assertThat((Object)((String)values.get("-1")), (Matcher)Matchers.equalTo((Object)"I would prefer this is not merged as is"));
        } else {
            Assert.assertThat((Object)((String)values.get("-2")), (Matcher)Matchers.equalTo((Object)ApprovalUtil.CRVW.getValue((short)-2).getName()));
            Assert.assertThat((Object)((String)values.get("-1")), (Matcher)Matchers.equalTo((Object)ApprovalUtil.CRVW.getValue((short)-1).getName()));
        }
        Assert.assertThat((Object)((String)values.get(" 0")), (Matcher)Matchers.equalTo((Object)ApprovalUtil.CRVW.getValue((short)0).getName()));
        Assert.assertThat((Object)((String)values.get("+1")), (Matcher)Matchers.equalTo((Object)ApprovalUtil.CRVW.getValue((short)1).getName()));
        Assert.assertThat((Object)((String)values.get("+2")), (Matcher)Matchers.equalTo((Object)ApprovalUtil.CRVW.getValue((short)2).getName()));
    }

    private static Timestamp timestamp(String date) throws ParseException {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        cal.setTime(sdf.parse(date));
        cal.add(14, TimeZone.getDefault().getRawOffset());
        return new Timestamp(cal.getTimeInMillis());
    }

    private ChangeInfo parseFile(String path) throws IOException {
        File file = CommonTestUtil.getFile((Object)((Object)this), (String)path);
        String content = CommonTestUtil.read((File)file);
        return (ChangeInfo)new JSonSupport().parseResponse(content, ChangeInfo.class);
    }

    private static void assertHasCodeReviewApprovalType(Set<ApprovalType> approvalTypes) {
        Assert.assertThat(approvalTypes, (Matcher)IsNot.not(IsEmpty.empty()));
        Assert.assertThat((Object)approvalTypes.size(), (Matcher)Matchers.is((Object)1));
        ApprovalType approvalType = approvalTypes.iterator().next();
        Assert.assertThat((Object)approvalType.getCategory().getId(), (Matcher)Matchers.equalTo((Object)ApprovalUtil.CRVW.getCategory().getId()));
        Assert.assertThat((Object)approvalType.getCategory().getName(), (Matcher)Matchers.is((Object)"Code Review"));
        Assert.assertThat((Object)approvalType.getValues().size(), (Matcher)Matchers.is((Object)5));
        for (ApprovalCategoryValue approvalCategoryValue : ApprovalUtil.CRVW.getValues()) {
            ChangeInfoTest.assertHasItem(approvalType.getValues(), ApprovalCategoryValueComparator.INSTANCE, approvalCategoryValue);
        }
    }

    private static void assertHasApprovalInfo(List<ApprovalInfo> all, int value) {
        Assert.assertThat(all, (Matcher)IsNot.not(IsEmpty.empty()));
        Assert.assertThat((Object)all.size(), (Matcher)Matchers.is((Object)1));
        ApprovalInfo approvalInfo = all.get(0);
        Assert.assertThat((Object)approvalInfo, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)approvalInfo.getValue(), (Matcher)Matchers.is((Object)((short)value)));
        Assert.assertThat((Object)approvalInfo.getEmail(), (Matcher)Matchers.equalTo((Object)"tests@mylyn.eclipse.org"));
    }

    private static void assertHasApprovalDetail(Set<ApprovalDetail> approvalDetails, int value) {
        Assert.assertThat(approvalDetails, (Matcher)IsNot.not(IsEmpty.empty()));
        Assert.assertThat((Object)approvalDetails.size(), (Matcher)Matchers.is((Object)1));
        ApprovalDetail approvalDetail = approvalDetails.iterator().next();
        Assert.assertThat((Object)approvalDetail, (Matcher)Matchers.notNullValue());
        Map approvalMap = approvalDetail.getApprovalMap();
        Assert.assertThat((Object)approvalMap, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)approvalMap, (Matcher)Matchers.hasKey((Object)ApprovalUtil.CRVW.getCategory().getId()));
        PatchSetApproval patchSetApproval = (PatchSetApproval)approvalMap.get(ApprovalUtil.CRVW.getCategory().getId());
        Assert.assertThat((Object)patchSetApproval.getValue(), (Matcher)Matchers.is((Object)((short)value)));
    }

    public static void assertHasCodeReviewPermissionLabels(ChangeInfo changeInfo) {
        Map permittedLabels = changeInfo.getPermittedLabels();
        Assert.assertThat((Object)permittedLabels, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)permittedLabels, (Matcher)IsNot.not(IsEmpty.empty()));
        Assert.assertThat((Object)permittedLabels.size(), (Matcher)Matchers.is((Object)1));
        String[] crvwPermittedLabels = (String[])permittedLabels.get(ApprovalUtil.toNameWithDash((String)ApprovalUtil.CRVW.getCategory().getName()));
        Assert.assertThat((Object)crvwPermittedLabels, (Matcher)IsNot.not(IsEmpty.empty()));
        Assert.assertThat((Object)crvwPermittedLabels.length, (Matcher)Matchers.is((Object)3));
        Assert.assertThat((Object)crvwPermittedLabels[0], (Matcher)Matchers.is((Object)ApprovalUtil.CRVW.getValue((short)-1).formatValue()));
        Assert.assertThat((Object)crvwPermittedLabels[1], (Matcher)Matchers.is((Object)ApprovalUtil.CRVW.getValue((short)0).formatValue()));
        Assert.assertThat((Object)crvwPermittedLabels[2], (Matcher)Matchers.is((Object)ApprovalUtil.CRVW.getValue((short)1).formatValue()));
        List permissionLabels = changeInfo.convertToPermissionLabels();
        Assert.assertThat((Object)permissionLabels, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)permissionLabels, (Matcher)IsNot.not(IsEmpty.empty()));
        Assert.assertThat((Object)permissionLabels.size(), (Matcher)Matchers.is((Object)1));
        PermissionLabel crvwAllowed = (PermissionLabel)permissionLabels.get(0);
        Assert.assertThat((Object)crvwAllowed.getName(), (Matcher)Matchers.is((Object)PermissionLabel.toLabelName((String)ApprovalUtil.toNameWithDash((String)ApprovalUtil.CRVW.getCategory().getName()))));
        Assert.assertThat((Object)crvwAllowed.getMin(), (Matcher)Matchers.is((Object)-1));
        Assert.assertThat((Object)crvwAllowed.getMax(), (Matcher)Matchers.is((Object)1));
    }

    private static void assertHasRevisions(ChangeInfo changeInfo, int patchSetNr) {
        Assert.assertThat((Object)changeInfo, (Matcher)Matchers.notNullValue());
        String currentRevision = changeInfo.getCurrentRevision();
        Assert.assertThat((Object)currentRevision, (Matcher)Matchers.notNullValue());
        Map revisions = changeInfo.getRevisions();
        Assert.assertThat((Object)revisions, (Matcher)IsNot.not(IsEmpty.empty()));
        Assert.assertThat((Object)revisions.size(), (Matcher)Matchers.is((Object)1));
        RevisionInfo currentRevisionInfo = (RevisionInfo)revisions.get(currentRevision);
        Assert.assertThat((Object)currentRevisionInfo, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)currentRevisionInfo.isDraft(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)currentRevisionInfo.getNumber(), (Matcher)Matchers.is((Object)patchSetNr));
    }

    private static <T> void assertHasItem(Collection<T> collection, Comparator<T> comparator, T itemToFind) {
        for (T item : collection) {
            if (comparator.compare(item, itemToFind) != 0) continue;
            return;
        }
        ChangeInfoTest.fail((String)("Item " + itemToFind + " not found in " + collection));
    }

    private static void assertCategoriesEqual(ApprovalType expected, ApprovalType actual) {
        ChangeInfoTest.assertEquals((String)expected.getCategory().getId().get(), (String)actual.getCategory().getId().get());
    }

    private static void assertGiven(ChangeInfo changeInfo, PatchSet.Id patchSetId, int accountId, int ... approvals) {
        Account account = new Account(new Account.Id(accountId));
        Map given = changeInfo.convertToPatchSetApprovals(patchSetId, account);
        ChangeInfoTest.assertNotNull((Object)given);
        ChangeInfoTest.assertEquals((int)approvals.length, (int)given.size());
        if (approvals.length > 0) {
            ChangeInfoTest.assertEquals((short)((short)approvals[0]), (short)((PatchSetApproval)given.get(ApprovalUtil.CRVW.getCategory().getId())).getValue());
        }
        if (approvals.length > 1) {
            ChangeInfoTest.assertEquals((short)((short)approvals[1]), (short)((PatchSetApproval)given.get(ApprovalUtil.VRIF.getCategory().getId())).getValue());
        }
        if (approvals.length > 2) {
            ChangeInfoTest.assertEquals((short)((short)approvals[2]), (short)((PatchSetApproval)given.get(ApprovalUtil.IPCL.getCategory().getId())).getValue());
        }
    }

    private static PatchSet.Id createCurrentPatchSetId(int changeNumber, int patchSetNumber) {
        Change.Id changeId = new Change.Id(changeNumber);
        return new PatchSet.Id(changeId, patchSetNumber);
    }

    private static class ApprovalCategoryValueComparator
    implements Comparator<ApprovalCategoryValue> {
        private static final Comparator<ApprovalCategoryValue> INSTANCE = new ApprovalCategoryValueComparator();

        private ApprovalCategoryValueComparator() {
        }

        @Override
        public int compare(ApprovalCategoryValue acv1, ApprovalCategoryValue acv2) {
            return acv1.format().compareTo(acv2.format());
        }
    }
}

