/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.gerrit.tests.core.client.rest;

import java.io.File;
import java.io.IOException;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.mylyn.commons.sdk.util.CommonTestUtil;
import org.eclipse.mylyn.internal.gerrit.core.client.JSonSupport;
import org.eclipse.mylyn.internal.gerrit.core.client.rest.AddReviewerResult;
import org.eclipse.mylyn.internal.gerrit.core.client.rest.ReviewerInfo;
import org.junit.Test;

public class AddReviewerResultTest
extends TestCase {
    @Test
    public void testFromEmptyJson() throws Exception {
        AddReviewerResult addReviewerResult = this.parseFile("testdata/EmptyWithMagic.json");
        AddReviewerResultTest.assertNotNull((Object)addReviewerResult);
        AddReviewerResultTest.assertNull((Object)addReviewerResult.getError());
        AddReviewerResultTest.assertNull((Object)addReviewerResult.getReviewers());
    }

    @Test
    public void testFromInvalid() throws Exception {
        AddReviewerResult addReviewerResult = this.parseFile("testdata/InvalidWithMagic.json");
        AddReviewerResultTest.assertNotNull((Object)addReviewerResult);
        AddReviewerResultTest.assertNull((Object)addReviewerResult.getError());
        AddReviewerResultTest.assertNull((Object)addReviewerResult.getReviewers());
    }

    @Test
    public void testFromValid() throws Exception {
        AddReviewerResult addReviewerResult = this.parseFile("testdata/AddReviewerResult_reviewers.json");
        AddReviewerResultTest.assertNotNull((Object)addReviewerResult);
        AddReviewerResultTest.assertNull((Object)addReviewerResult.getError());
        List reviewers = addReviewerResult.getReviewers();
        AddReviewerResultTest.assertNotNull((Object)reviewers);
        AddReviewerResultTest.assertEquals((int)2, (int)reviewers.size());
        ReviewerInfo johnDoe = (ReviewerInfo)reviewers.get(0);
        ReviewerInfo janeRoe = (ReviewerInfo)reviewers.get(1);
        AddReviewerResultTest.assertAccountInfo(johnDoe, 1000096, "John Doe", "john.doe@example.com");
        AddReviewerResultTest.assertAccountInfo(janeRoe, 1000097, "Jane Roe", "jane.roe@example.com");
        AddReviewerResultTest.assertApprovals(johnDoe, "+1", "+2");
        AddReviewerResultTest.assertApprovals(janeRoe, " 0", "-1");
    }

    private static void assertAccountInfo(ReviewerInfo reviewerInfo, int id, String name, String email) {
        AddReviewerResultTest.assertEquals((int)id, (int)reviewerInfo.getId());
        AddReviewerResultTest.assertEquals((String)name, (String)reviewerInfo.getName());
        AddReviewerResultTest.assertEquals((String)email, (String)reviewerInfo.getEmail());
        AddReviewerResultTest.assertNull((Object)reviewerInfo.getUsername());
    }

    private static void assertApprovals(ReviewerInfo reviewerInfo, String verified, String codeReview) {
        AddReviewerResultTest.assertNotNull((Object)reviewerInfo.getApprovals());
        AddReviewerResultTest.assertEquals((int)2, (int)reviewerInfo.getApprovals().size());
        AddReviewerResultTest.assertEquals((String)verified, (String)((String)reviewerInfo.getApprovals().get("Verified")));
        AddReviewerResultTest.assertEquals((String)codeReview, (String)((String)reviewerInfo.getApprovals().get("Code-Review")));
    }

    private AddReviewerResult parseFile(String path) throws IOException {
        File file = CommonTestUtil.getFile((Object)((Object)this), (String)path);
        String content = CommonTestUtil.read((File)file);
        return (AddReviewerResult)new JSonSupport().parseResponse(content, AddReviewerResult.class);
    }
}

