/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.gerrit.tests.core.client.rest;

import java.io.File;
import java.io.IOException;
import junit.framework.TestCase;
import org.eclipse.mylyn.commons.sdk.util.CommonTestUtil;
import org.eclipse.mylyn.internal.gerrit.core.client.JSonSupport;
import org.eclipse.mylyn.internal.gerrit.core.client.rest.AccountInfo;
import org.junit.Test;

public class AccountInfoTest
extends TestCase {
    @Test
    public void testFromEmptyJson() throws Exception {
        AccountInfo accountInfo = this.parseFile("testdata/EmptyWithMagic.json");
        AccountInfoTest.assertNotNull((Object)accountInfo);
        AccountInfoTest.assertEquals((int)-1, (int)accountInfo.getId());
        AccountInfoTest.assertNull((Object)accountInfo.getName());
        AccountInfoTest.assertNull((Object)accountInfo.getEmail());
        AccountInfoTest.assertNull((Object)accountInfo.getUsername());
    }

    @Test
    public void testFromInvalid() throws Exception {
        AccountInfo accountInfo = this.parseFile("testdata/InvalidWithMagic.json");
        AccountInfoTest.assertNotNull((Object)accountInfo);
        AccountInfoTest.assertEquals((int)-1, (int)accountInfo.getId());
        AccountInfoTest.assertNull((Object)accountInfo.getName());
        AccountInfoTest.assertNull((Object)accountInfo.getEmail());
        AccountInfoTest.assertNull((Object)accountInfo.getUsername());
    }

    @Test
    public void testFromValid() throws IOException {
        AccountInfo accountInfo = this.parseFile("testdata/AccountInfo_johnDoe.json");
        AccountInfoTest.assertEquals((int)1000195, (int)accountInfo.getId());
        AccountInfoTest.assertEquals((String)"John Doe", (String)accountInfo.getName());
        AccountInfoTest.assertEquals((String)"john.doe@example.com", (String)accountInfo.getEmail());
        AccountInfoTest.assertNull((Object)accountInfo.getUsername());
    }

    private AccountInfo parseFile(String path) throws IOException {
        File file = CommonTestUtil.getFile((Object)((Object)this), (String)path);
        String content = CommonTestUtil.read((File)file);
        return (AccountInfo)new JSonSupport().parseResponse(content, AccountInfo.class);
    }
}

