/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.gerrit.tests.core.client.compat;

import java.io.File;
import java.io.IOException;
import junit.framework.TestCase;
import org.eclipse.mylyn.commons.sdk.util.CommonTestUtil;
import org.eclipse.mylyn.internal.gerrit.core.client.JSonSupport;
import org.eclipse.mylyn.internal.gerrit.core.client.compat.PatchScriptX;
import org.junit.Test;

public class PatchScriptXTest
extends TestCase {
    @Test
    public void testPatchScriptIsNotBinary() throws Exception {
        PatchScriptX patchScript = this.parseFile("testdata/PatchScript_java.json");
        PatchScriptXTest.assertFalse((boolean)patchScript.isBinary());
    }

    @Test
    public void testPatchScriptIsBinary() throws Exception {
        PatchScriptX patchScript = this.parseFile("testdata/PatchScript_gif.json");
        PatchScriptXTest.assertTrue((boolean)patchScript.isBinary());
    }

    private PatchScriptX parseFile(String path) throws IOException {
        File file = CommonTestUtil.getFile((Object)((Object)this), (String)path);
        String content = CommonTestUtil.read((File)file);
        PatchScriptXAsResult result = (PatchScriptXAsResult)new JSonSupport().parseResponse(content, PatchScriptXAsResult.class);
        PatchScriptXTest.assertEquals((String)"2.0", (String)result.jsonrpc);
        PatchScriptXTest.assertTrue((result.id > 0 ? 1 : 0) != 0);
        PatchScriptXTest.assertNotNull((Object)result.result);
        return result.result;
    }

    private class PatchScriptXAsResult {
        private String jsonrpc;
        private int id;
        private PatchScriptX result;

        private PatchScriptXAsResult() {
        }
    }
}

