/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.gerrit.tests.core.client.compat;

import com.google.gerrit.common.data.ApprovalType;
import com.google.gerrit.common.data.ApprovalTypes;
import com.google.gerrit.reviewdb.ChangeMessage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import junit.framework.TestCase;
import org.eclipse.mylyn.commons.sdk.util.CommonTestUtil;
import org.eclipse.mylyn.internal.gerrit.core.client.JSonSupport;
import org.eclipse.mylyn.internal.gerrit.core.client.compat.ChangeDetailX;
import org.eclipse.mylyn.internal.gerrit.core.client.compat.GerritConfigX;
import org.eclipse.mylyn.internal.gerrit.core.client.compat.SubmitRecord;
import org.eclipse.mylyn.internal.gerrit.core.client.rest.ApprovalUtil;
import org.junit.Test;

public class ChangeDetailXTest
extends TestCase {
    @Test
    public void testCustomLabel() throws Exception {
        ChangeDetailXAsResult result = this.parseFile("testdata/ChangeDetailX.json");
        ChangeDetailXTest.assertEquals((String)"2.0", (String)result.jsonrpc);
        ChangeDetailXTest.assertEquals((int)1, (int)result.id);
        ChangeDetailXTest.assertNotNull((Object)result.result);
        ChangeDetailX changeDetailX = result.result;
        ChangeDetailXTest.assertNull((Object)changeDetailX.getApprovalTypes());
        ChangeDetailXTest.assertEquals((int)1, (int)changeDetailX.getSubmitRecords().size());
        SubmitRecord submitRecord = (SubmitRecord)changeDetailX.getSubmitRecords().get(0);
        ChangeDetailXTest.assertEquals((String)"NOT_READY", (String)submitRecord.getStatus());
        ChangeDetailXTest.assertEquals((int)3, (int)submitRecord.getLabels().size());
        Iterator labels = submitRecord.getLabels().iterator();
        this.assertLabelEqual("Non-Author-Code-Review", (SubmitRecord.Label)labels.next());
        this.assertLabelEqual("Verified", (SubmitRecord.Label)labels.next());
        this.assertLabelEqual("Code-Review", (SubmitRecord.Label)labels.next());
        changeDetailX.convertSubmitRecordsToApprovalTypes(ChangeDetailXTest.getTestConfig().getApprovalTypes());
        ChangeDetailXTest.assertNotNull((Object)changeDetailX.getApprovalTypes());
        ChangeDetailXTest.assertEquals((int)3, (int)changeDetailX.getApprovalTypes().size());
        Iterator approvalTypes = changeDetailX.getApprovalTypes().iterator();
        ApprovalType custom = (ApprovalType)approvalTypes.next();
        ChangeDetailXTest.assertEquals((String)"Non-Author-Code-Review", (String)custom.getCategory().getName());
        ChangeDetailXTest.assertNull((Object)custom.getCategory().getAbbreviatedName());
        ChangeDetailXTest.assertTrue((boolean)custom.getValues().isEmpty());
        ChangeDetailXTest.assertCategoriesEqual(ApprovalUtil.VRIF, (ApprovalType)approvalTypes.next());
        ChangeDetailXTest.assertCategoriesEqual(ApprovalUtil.CRVW, (ApprovalType)approvalTypes.next());
    }

    @Test
    public void testConvertWhenApprovalTypesNotNull() throws Exception {
        ChangeDetailX changeDetailX = new ChangeDetailX();
        changeDetailX.setApprovalTypes(Collections.singleton(ApprovalUtil.CRVW));
        try {
            changeDetailX.convertSubmitRecordsToApprovalTypes(ChangeDetailXTest.getTestConfig().getApprovalTypes());
            ChangeDetailXTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testAbandoned() throws Exception {
        ChangeDetailXAsResult result = this.parseFile("testdata/ChangeDetailX_abandoned.json");
        ChangeDetailXTest.assertEquals((String)"2.0", (String)result.jsonrpc);
        ChangeDetailXTest.assertEquals((int)3, (int)result.id);
        ChangeDetailXTest.assertNotNull((Object)result.result);
        ChangeDetailX changeDetailX = result.result;
        ChangeDetailXTest.assertNull((Object)changeDetailX.getApprovalTypes());
        ChangeDetailXTest.assertNull((Object)changeDetailX.getSubmitRecords());
        changeDetailX.convertSubmitRecordsToApprovalTypes(ChangeDetailXTest.getTestConfig().getApprovalTypes());
        ChangeDetailXTest.assertNull((Object)changeDetailX.getApprovalTypes());
    }

    @Test
    public void testContinousIntegrationCommentsAreRemoved() throws Exception {
        ChangeDetailXAsResult result = this.parseFile("testdata/ChangeDetailX_hudson.json");
        ChangeDetailX changeDetailX = result.result;
        ChangeDetailXTest.assertEquals((int)1, (int)changeDetailX.getMessages().size());
        ChangeMessage lastMessageLeft = (ChangeMessage)changeDetailX.getMessages().get(0);
        ChangeDetailXTest.assertFalse((boolean)lastMessageLeft.getMessage().contains("hudson.eclipse.org"));
    }

    private void assertLabelEqual(String expectedLabel, SubmitRecord.Label label) {
        ChangeDetailXTest.assertEquals((String)expectedLabel, (String)label.getLabel());
        ChangeDetailXTest.assertEquals((String)"NEED", (String)label.getStatus());
        ChangeDetailXTest.assertNull((Object)label.getAppliedBy());
    }

    private static void assertCategoriesEqual(ApprovalType expected, ApprovalType actual) {
        ChangeDetailXTest.assertEquals((String)expected.getCategory().getId().get(), (String)actual.getCategory().getId().get());
    }

    private static GerritConfigX getTestConfig() {
        GerritConfigX result = new GerritConfigX();
        ArrayList<ApprovalType> approvals = new ArrayList<ApprovalType>(3);
        approvals.add(ApprovalUtil.CRVW);
        approvals.add(ApprovalUtil.VRIF);
        approvals.add(ApprovalUtil.IPCL);
        result.setApprovalTypes(new ApprovalTypes(approvals, null));
        return result;
    }

    private ChangeDetailXAsResult parseFile(String path) throws IOException {
        File file = CommonTestUtil.getFile((Object)((Object)this), (String)path);
        String content = CommonTestUtil.read((File)file);
        return (ChangeDetailXAsResult)new JSonSupport().parseResponse(content, ChangeDetailXAsResult.class);
    }

    private class ChangeDetailXAsResult {
        private String jsonrpc;
        private int id;
        private ChangeDetailX result;

        private ChangeDetailXAsResult() {
        }
    }
}

