/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.gerrit.tests.core.client;

import java.io.IOException;
import junit.framework.TestCase;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.GetMethod;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mylyn.commons.net.AbstractWebLocation;
import org.eclipse.mylyn.commons.net.UnsupportedRequestException;
import org.eclipse.mylyn.commons.net.WebLocation;
import org.eclipse.mylyn.gerrit.tests.support.GerritFixture;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritCapabilities;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritHttpClient;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritLoginException;
import org.eclipse.mylyn.internal.gerrit.core.client.IOpenIdLocation;
import org.eclipse.mylyn.internal.gerrit.core.client.OpenIdAuthenticationRequest;
import org.eclipse.mylyn.internal.gerrit.core.client.OpenIdAuthenticationResponse;

public class OpenIdAuthenticationTest
extends TestCase {
    private static String PROVIDER_URL = "https://www.google.com/accounts/o8/id";
    StubRepositoryLocation location = new StubRepositoryLocation(GerritFixture.current().repository().getRepositoryUrl());
    GerritHttpClient client = new GerritHttpClient((AbstractWebLocation)this.location, GerritCapabilities.MAXIMUM_SUPPORTED_VERSION);

    public void testExecuteNullOpenIdProviderNullCredentials() throws Exception {
        this.client.execute(this.createRequest(), null);
    }

    public void testExecuteOpenIdProviderNullCredentials() throws Exception {
        this.location.providerUrl = PROVIDER_URL;
        try {
            this.client.execute(this.createRequest(), null);
            OpenIdAuthenticationTest.fail((String)"Expected GerritLoginException");
        }
        catch (GerritLoginException gerritLoginException) {
            // empty catch block
        }
    }

    private GerritHttpClient.Request<Object> createRequest() {
        return new GerritHttpClient.Request<Object>(){

            public HttpMethodBase createMethod() throws IOException {
                return new GetMethod();
            }

            public Object process(HttpMethodBase method) throws IOException {
                return null;
            }
        };
    }

    private class StubRepositoryLocation
    extends WebLocation
    implements IOpenIdLocation {
        String providerUrl;

        public StubRepositoryLocation(String url) {
            super(url);
        }

        public String getProviderUrl() {
            return this.providerUrl;
        }

        public OpenIdAuthenticationResponse requestAuthentication(OpenIdAuthenticationRequest request, IProgressMonitor monitor) throws UnsupportedRequestException {
            return new OpenIdAuthenticationResponse(null, null);
        }
    }
}

