/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.gerrit.tests.core.client;

import junit.framework.TestCase;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritVersion;
import org.junit.Test;
import org.osgi.framework.Version;

public class GerritVersionTest
extends TestCase {
    @Test
    public void testParse_null() throws Exception {
        try {
            GerritVersion.parseGerritVersion(null);
            GerritVersionTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testParse_empty() throws Exception {
        try {
            GerritVersion.parseGerritVersion((String)"");
            GerritVersionTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testParse_invalid() throws Exception {
        try {
            GerritVersion.parseGerritVersion((String)"invalid");
            GerritVersionTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            GerritVersionTest.assertTrue((boolean)e.getMessage().startsWith("Unrecognized version"));
        }
    }

    @Test
    public void testParse_21() throws Exception {
        Version v = GerritVersion.parseGerritVersion((String)"2.1");
        GerritVersionTest.assertEquals((int)2, (int)v.getMajor());
        GerritVersionTest.assertEquals((int)1, (int)v.getMinor());
        GerritVersionTest.assertEquals((int)0, (int)v.getMicro());
        GerritVersionTest.assertTrue((boolean)v.getQualifier().isEmpty());
    }

    @Test
    public void testParse_254() throws Exception {
        Version v = GerritVersion.parseGerritVersion((String)"2.5.4");
        GerritVersionTest.assertEquals((int)2, (int)v.getMajor());
        GerritVersionTest.assertEquals((int)5, (int)v.getMinor());
        GerritVersionTest.assertEquals((int)4, (int)v.getMicro());
        GerritVersionTest.assertTrue((boolean)v.getQualifier().isEmpty());
    }

    @Test
    public void testParse_26rc3() throws Exception {
        Version v = GerritVersion.parseGerritVersion((String)"2.6-rc3");
        GerritVersionTest.assertEquals((int)2, (int)v.getMajor());
        GerritVersionTest.assertEquals((int)6, (int)v.getMinor());
        GerritVersionTest.assertEquals((int)0, (int)v.getMicro());
        GerritVersionTest.assertEquals((String)"rc3", (String)v.getQualifier());
    }

    @Test
    public void testParse_27rc2637g76c7890() throws Exception {
        Version v = GerritVersion.parseGerritVersion((String)"2.7-rc2-637-g76c7890");
        GerritVersionTest.assertEquals((int)2, (int)v.getMajor());
        GerritVersionTest.assertEquals((int)7, (int)v.getMinor());
        GerritVersionTest.assertEquals((int)0, (int)v.getMicro());
        GerritVersionTest.assertEquals((String)"rc2-637-g76c7890", (String)v.getQualifier());
    }

    @Test
    public void testParse_V221NQT012() throws Exception {
        Version v = GerritVersion.parseGerritVersion((String)"V2.2.1-NQT-012");
        GerritVersionTest.assertEquals((int)2, (int)v.getMajor());
        GerritVersionTest.assertEquals((int)2, (int)v.getMinor());
        GerritVersionTest.assertEquals((int)1, (int)v.getMicro());
        GerritVersionTest.assertEquals((String)"NQT-012", (String)v.getQualifier());
    }

    @Test
    public void testParse_123q() throws Exception {
        Version v = GerritVersion.parseGerritVersion((String)"1.2.3-q");
        GerritVersionTest.assertEquals((int)1, (int)v.getMajor());
        GerritVersionTest.assertEquals((int)2, (int)v.getMinor());
        GerritVersionTest.assertEquals((int)3, (int)v.getMicro());
        GerritVersionTest.assertEquals((String)"q", (String)v.getQualifier());
    }

    @Test
    public void testParse_27xxx31() throws Exception {
        Version v = GerritVersion.parseGerritVersion((String)"2.7-xxx3.1");
        GerritVersionTest.assertEquals((int)2, (int)v.getMajor());
        GerritVersionTest.assertEquals((int)7, (int)v.getMinor());
        GerritVersionTest.assertEquals((int)0, (int)v.getMicro());
        GerritVersionTest.assertEquals((String)"xxx3", (String)v.getQualifier());
    }

    @Test
    public void testParse_2861() throws Exception {
        Version v = GerritVersion.parseGerritVersion((String)"2.8.6.1");
        GerritVersionTest.assertEquals((int)2, (int)v.getMajor());
        GerritVersionTest.assertEquals((int)8, (int)v.getMinor());
        GerritVersionTest.assertEquals((int)6, (int)v.getMicro());
        GerritVersionTest.assertEquals((String)"1", (String)v.getQualifier());
    }

    @Test
    public void testIsVersion2112OrLater() throws Exception {
        GerritVersionTest.assertFalse((boolean)GerritVersion.isVersion2112OrLater((Version)GerritVersion.parseGerritVersion((String)"2.9.9")));
        GerritVersionTest.assertFalse((boolean)GerritVersion.isVersion2112OrLater((Version)GerritVersion.parseGerritVersion((String)"2.9.9-q")));
        GerritVersionTest.assertFalse((boolean)GerritVersion.isVersion2112OrLater((Version)GerritVersion.parseGerritVersion((String)"2.10")));
        GerritVersionTest.assertFalse((boolean)GerritVersion.isVersion2112OrLater((Version)GerritVersion.parseGerritVersion((String)"2.10-q")));
        GerritVersionTest.assertFalse((boolean)GerritVersion.isVersion2112OrLater((Version)GerritVersion.parseGerritVersion((String)"2.10.0")));
        GerritVersionTest.assertFalse((boolean)GerritVersion.isVersion2112OrLater((Version)GerritVersion.parseGerritVersion((String)"2.10.0-q")));
        GerritVersionTest.assertFalse((boolean)GerritVersion.isVersion2112OrLater((Version)GerritVersion.parseGerritVersion((String)"2.10.0-rc2")));
        GerritVersionTest.assertFalse((boolean)GerritVersion.isVersion2112OrLater((Version)GerritVersion.parseGerritVersion((String)"2.10.1")));
        GerritVersionTest.assertFalse((boolean)GerritVersion.isVersion2112OrLater((Version)GerritVersion.parseGerritVersion((String)"2.10.1-q")));
        GerritVersionTest.assertFalse((boolean)GerritVersion.isVersion2112OrLater((Version)GerritVersion.parseGerritVersion((String)"2.10.1-rc2")));
        GerritVersionTest.assertFalse((boolean)GerritVersion.isVersion2112OrLater((Version)GerritVersion.parseGerritVersion((String)"2.11")));
        GerritVersionTest.assertFalse((boolean)GerritVersion.isVersion2112OrLater((Version)GerritVersion.parseGerritVersion((String)"2.11.0")));
        GerritVersionTest.assertFalse((boolean)GerritVersion.isVersion2112OrLater((Version)GerritVersion.parseGerritVersion((String)"2.11-rc2")));
        GerritVersionTest.assertTrue((boolean)GerritVersion.isVersion2112OrLater((Version)GerritVersion.parseGerritVersion((String)"2.11.2")));
        GerritVersionTest.assertTrue((boolean)GerritVersion.isVersion2112OrLater((Version)GerritVersion.parseGerritVersion((String)"2.11.2-q")));
        GerritVersionTest.assertTrue((boolean)GerritVersion.isVersion2112OrLater((Version)GerritVersion.parseGerritVersion((String)"2.11.2")));
        GerritVersionTest.assertTrue((boolean)GerritVersion.isVersion2112OrLater((Version)GerritVersion.parseGerritVersion((String)"2.11.2-q")));
        GerritVersionTest.assertTrue((boolean)GerritVersion.isVersion2112OrLater((Version)GerritVersion.parseGerritVersion((String)"2.11.2-rc2")));
        GerritVersionTest.assertTrue((boolean)GerritVersion.isVersion2112OrLater((Version)GerritVersion.parseGerritVersion((String)"2.11.3")));
        GerritVersionTest.assertTrue((boolean)GerritVersion.isVersion2112OrLater((Version)GerritVersion.parseGerritVersion((String)"2.11.3-q")));
        GerritVersionTest.assertTrue((boolean)GerritVersion.isVersion2112OrLater((Version)GerritVersion.parseGerritVersion((String)"2.11.3-rc2")));
    }
}

