/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.gerrit.tests.core.client;

import com.google.common.collect.ImmutableList;
import com.google.gerrit.reviewdb.Account;
import com.google.gerrit.reviewdb.Patch;
import com.google.gerrit.reviewdb.PatchSet;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.EnumSet;
import java.util.List;
import junit.framework.TestCase;
import org.apache.commons.httpclient.Cookie;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.mylyn.commons.net.AbstractWebLocation;
import org.eclipse.mylyn.commons.net.WebLocation;
import org.eclipse.mylyn.commons.net.WebUtil;
import org.eclipse.mylyn.commons.repositories.core.auth.UserCredentials;
import org.eclipse.mylyn.commons.sdk.util.CommonTestUtil;
import org.eclipse.mylyn.gerrit.tests.support.GerritFixture;
import org.eclipse.mylyn.gerrit.tests.support.GerritHarness;
import org.eclipse.mylyn.internal.gerrit.core.GerritUtil;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritAuthenticationState;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritClient;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritClient212;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritConfiguration;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritException;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritSystemInfo;
import org.eclipse.mylyn.internal.gerrit.core.client.compat.PatchScriptX;
import org.eclipse.mylyn.internal.gerrit.core.client.data.GerritQueryResult;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class GerritClientTest
extends TestCase {
    private static final String GET_LABELS_OPTION = "LABELS";
    private static final String GET_DETAILED_ACCOUNTS_OPTION = "DETAILED_ACCOUNTS";
    private GerritHarness harness;
    private GerritClient client;

    @Before
    public void setUp() throws Exception {
        this.harness = GerritFixture.current().harness();
        this.client = this.harness.client();
    }

    @After
    public void tearDown() throws Exception {
        this.harness.dispose();
    }

    @Test
    public void testRefreshConfig() throws Exception {
        GerritConfiguration config = this.client.refreshConfig((IProgressMonitor)new NullProgressMonitor());
        GerritClientTest.assertNotNull((Object)config);
        GerritClientTest.assertNotNull((Object)config.getGerritConfig());
        GerritClientTest.assertNotNull((Object)config.getProjects());
        GerritClientTest.assertNotNull((Object)config.getGerritConfig().getWildProject());
        GerritClientTest.assertEquals((String)"All-Projects", (String)config.getGerritConfig().getWildProject().toString());
        if (this.client.getVersion().getMinor() >= 12) {
            GerritClientTest.assertNotNull((Object)config.getGerritConfig().getSchemes());
        }
    }

    @Test
    public void testGetAccount() throws Exception {
        if (!GerritFixture.current().canAuthenticate()) {
            return;
        }
        Account account = this.client.getAccount((IProgressMonitor)new NullProgressMonitor());
        GerritClientTest.assertEquals((String)CommonTestUtil.getShortUserName((UserCredentials)this.harness.readCredentials()), (String)account.getUserName());
    }

    @Test
    public void testGetAccountAnonymous() throws Exception {
        this.client = this.harness.clientAnonymous();
        try {
            this.client.getAccount((IProgressMonitor)new NullProgressMonitor());
            GerritClientTest.fail((String)"Expected GerritException");
        }
        catch (GerritException e) {
            GerritClientTest.assertEquals((String)"Not Signed In", (String)e.getMessage());
        }
    }

    @Test
    public void testGetInfo() throws Exception {
        GerritSystemInfo info = this.client.getInfo((IProgressMonitor)new NullProgressMonitor());
        if (GerritFixture.current().canAuthenticate()) {
            GerritClientTest.assertEquals((String)CommonTestUtil.getShortUserName((UserCredentials)this.harness.readCredentials()), (String)info.getFullName());
        } else {
            GerritClientTest.assertEquals((String)"Anonymous", (String)info.getFullName());
        }
    }

    @Test
    public void testInvalidXrsfKey() throws Exception {
        if (!GerritFixture.current().canAuthenticate()) {
            return;
        }
        WebLocation location = this.harness.location();
        GerritAuthenticationState authState = new GerritAuthenticationState();
        authState.setCookie(new Cookie(WebUtil.getHost((String)location.getUrl()), "xrsfKey", "invalid"));
        this.client = GerritClient.create(null, (AbstractWebLocation)location, null, (GerritAuthenticationState)authState, (String)"invalid", null);
        this.client.getAccount(null);
    }

    @Test
    public void testGetVersion() throws Exception {
        GerritClientTest.assertEquals((Object)GerritFixture.current().getGerritVersion(), (Object)this.client.getVersion((IProgressMonitor)new NullProgressMonitor()));
    }

    private List<GerritQueryResult> executeQuery(String query) throws GerritException {
        return this.client.getRestClient().executeQuery((IProgressMonitor)new NullProgressMonitor(), query);
    }

    private List<GerritQueryResult> executeQuery(String query, List<String> options) throws GerritException {
        return this.client.getRestClient().executeQuery((IProgressMonitor)new NullProgressMonitor(), query, options);
    }

    @Test
    public void testExecuteQueryWithoutOption() throws Exception {
        String query = "status:open";
        List<GerritQueryResult> results = this.executeQuery(query);
        GerritClientTest.assertNotNull(results);
    }

    @Test
    public void testExecuteQueryWithNullOption() throws Exception {
        String query = "status:open";
        List<String> options = null;
        List<GerritQueryResult> results = this.executeQuery(query, options);
        GerritClientTest.assertNotNull(results);
    }

    @Test
    public void testExecuteQueryWithEmptyList() throws Exception {
        String query = "status:open";
        ImmutableList options = ImmutableList.of();
        List<GerritQueryResult> results = this.executeQuery(query, (List<String>)options);
        GerritClientTest.assertNotNull(results);
    }

    @Test
    public void testExecuteQueryWithEmptyOption() throws Exception {
        String query = "status:open";
        ImmutableList options = ImmutableList.of((Object)"");
        List<GerritQueryResult> results = this.executeQuery(query, (List<String>)options);
        GerritClientTest.assertNotNull(results);
    }

    @Test
    public void testExecuteQueryWithOption() throws Exception {
        String query = "status:open";
        ImmutableList options = ImmutableList.of((Object)GET_LABELS_OPTION);
        List<GerritQueryResult> results = this.executeQuery(query, (List<String>)options);
        GerritClientTest.assertNotNull(results);
        for (GerritQueryResult result : results) {
            GerritClientTest.assertNotNull((Object)result);
            GerritClientTest.assertNotNull((Object)result.getReviewLabel());
        }
    }

    @Test
    public void testExecuteQueryWithMultipleOptions() throws Exception {
        String query = "status:open";
        ImmutableList options = ImmutableList.of((Object)GET_LABELS_OPTION, (Object)GET_DETAILED_ACCOUNTS_OPTION);
        List<GerritQueryResult> results = this.executeQuery(query, (List<String>)options);
        GerritClientTest.assertNotNull(results);
        for (GerritQueryResult result : results) {
            GerritClientTest.assertNotNull((Object)result);
            GerritClientTest.assertNotNull((Object)result.getReviewLabel());
        }
    }

    @Test
    public void testExecuteQueryAllMerged() throws GerritException {
        String query = "status:merged";
        ImmutableList options = ImmutableList.of((Object)GET_LABELS_OPTION);
        List<GerritQueryResult> results = this.executeQuery(query, (List<String>)options);
        GerritClientTest.assertNotNull(results);
    }

    @Test
    public void testExecuteQueryAllAbandoned() throws GerritException {
        String query = "status:abandoned";
        ImmutableList options = ImmutableList.of((Object)GET_LABELS_OPTION);
        List<GerritQueryResult> results = this.executeQuery(query, (List<String>)options);
        GerritClientTest.assertNotNull(results);
    }

    @Test
    public void testExecuteQueryisStarred() throws GerritException {
        String query = "is:starred status:open";
        ImmutableList options = ImmutableList.of((Object)GET_LABELS_OPTION);
        List<GerritQueryResult> results = this.executeQuery(query, (List<String>)options);
        GerritClientTest.assertNotNull(results);
    }

    @Test
    public void testExecuteQueryHasComments() throws GerritException {
        String query = "has:draft";
        List<GerritQueryResult> results = this.executeQuery(query);
        GerritClientTest.assertNotNull(results);
    }

    @Test
    public void testExecuteQueryDraftsCommentsReviews() throws GerritException {
        String query = "has:draft";
        List<GerritQueryResult> results = this.executeQuery(query);
        GerritClientTest.assertNotNull(results);
    }

    @Test
    public void testExecuteQueryDraftsReviews() throws GerritException {
        String query = "is:draft";
        List<GerritQueryResult> results = this.executeQuery(query);
        GerritClientTest.assertNotNull(results);
    }

    @Test
    public void testToReviewId() throws GerritException {
        GerritClientTest.assertEquals((String)"123", (String)this.client.toReviewId("123", null));
        GerritClientTest.assertEquals((String)"1", (String)this.client.toReviewId("1", null));
    }

    @Test
    public void testToReviewIdWithInvalidId() {
        try {
            this.client.toReviewId("invalidid", null);
            GerritClientTest.fail((String)"Expected GerritException");
        }
        catch (GerritException e) {
            GerritClientTest.assertEquals((String)"invalidid is not a valid review ID", (String)e.getMessage());
        }
    }

    @Test
    public void testToReviewIdWithChangeId() throws Exception {
        this.harness.ensureOneReviewExists();
        List<GerritQueryResult> results = this.executeQuery("status:open");
        GerritQueryResult result = results.get(0);
        String reviewId = Integer.toString(result.getNumber());
        String changeId = GerritUtil.toChangeId((String)result.getId());
        GerritClientTest.assertEquals((String)reviewId, (String)this.client.toReviewId(changeId, null));
    }

    @Test
    public void testIsZippedContent() throws Exception {
        GerritClientTest.assertTrue((boolean)GerritClient.isZippedContent((byte[])"PK\u0003\u0004somezippedcontent".getBytes()));
        GerritClientTest.assertFalse((boolean)GerritClient.isZippedContent((byte[])"PK\u0003notzippedcontent".getBytes()));
        GerritClientTest.assertFalse((boolean)GerritClient.isZippedContent((byte[])"PKnotzippedcontent".getBytes()));
        GerritClientTest.assertFalse((boolean)GerritClient.isZippedContent((byte[])"notzippedcontent".getBytes()));
        GerritClientTest.assertFalse((boolean)GerritClient.isZippedContent((byte[])"PK".getBytes()));
        GerritClientTest.assertFalse((boolean)GerritClient.isZippedContent((byte[])"".getBytes()));
        GerritClientTest.assertFalse((boolean)GerritClient.isZippedContent(null));
    }

    @Test
    public void testFetchLeftBinaryContent() throws Exception {
        this.fetchBinaryContentForSide(false);
    }

    @Test
    public void testFetchRightBinaryContent() throws Exception {
        this.fetchBinaryContentForSide(true);
    }

    private void fetchBinaryContentForSide(boolean rightSide) throws Exception, GerritException {
        PatchSet.Id ps2 = PatchSet.Id.fromRef((String)"refs/changes/34/1234/2");
        PatchSet.Id ps4 = PatchSet.Id.fromRef((String)"refs/changes/34/1234/4");
        Patch.Key key = new Patch.Key(ps4, "/mylyn/gerrit/File.jpg");
        PatchScriptX script = (PatchScriptX)Mockito.mock(PatchScriptX.class);
        Patch.ChangeType[] changeTypeArray = Patch.ChangeType.values();
        int n = changeTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Patch.ChangeType type = changeTypeArray[n2];
            TestGerritClient client = this.createSpy();
            ((TestGerritClient)((Object)Mockito.doReturn(null).when((Object)client))).fetchBinaryContent((String)ArgumentMatchers.any(String.class), (IProgressMonitor)ArgumentMatchers.any(IProgressMonitor.class));
            Mockito.when((Object)script.getChangeType()).thenReturn((Object)type);
            VerificationMode fetchBinaryContentExpected = Mockito.times((int)1);
            if (rightSide) {
                client.fetchRightBinaryContent(script, key, ps2, (IProgressMonitor)new NullProgressMonitor());
                if (type == Patch.ChangeType.DELETED) {
                    fetchBinaryContentExpected = Mockito.never();
                }
            } else {
                client.fetchLeftBinaryContent(script, key, ps2, (IProgressMonitor)new NullProgressMonitor());
                if (!EnumSet.of(Patch.ChangeType.DELETED, Patch.ChangeType.MODIFIED).contains(type)) {
                    fetchBinaryContentExpected = Mockito.never();
                }
            }
            ((TestGerritClient)((Object)Mockito.verify((Object)((Object)client), (VerificationMode)fetchBinaryContentExpected))).fetchBinaryContent((String)ArgumentMatchers.any(String.class), (IProgressMonitor)ArgumentMatchers.any(IProgressMonitor.class));
            ++n2;
        }
    }

    @Test
    public void testGetUrlForPatchSet() throws Exception {
        TestGerritClient client = this.createSpy();
        PatchSet.Id ps2 = PatchSet.Id.fromRef((String)"refs/changes/34/1234/2");
        PatchSet.Id ps4 = PatchSet.Id.fromRef((String)"refs/changes/34/1234/4");
        Patch.Key key = new Patch.Key(ps4, "/mylyn/gerrit/File.jpg");
        GerritClientTest.assertEquals((String)this.encode("1234,4,/mylyn/gerrit/File.jpg^1"), (String)client.getUrlForPatchSetOrBase(key, null));
        GerritClientTest.assertEquals((String)this.encode("1234,2,/mylyn/gerrit/File.jpg^0"), (String)client.getUrlForPatchSetOrBase(key, ps2));
        GerritClientTest.assertEquals((String)this.encode("1234,4,/mylyn/gerrit/File.jpg^0"), (String)client.getUrlForPatchSetOrBase(key, ps4));
        GerritClientTest.assertEquals((String)this.encode("1234,2,/mylyn/gerrit/File.jpg^0"), (String)client.getUrlForPatchSet(key, ps2));
        GerritClientTest.assertEquals((String)this.encode("1234,4,/mylyn/gerrit/File.jpg^0"), (String)client.getUrlForPatchSet(key, ps4));
    }

    private TestGerritClient createSpy() throws Exception {
        return (TestGerritClient)((Object)Mockito.spy((Object)((Object)new TestGerritClient(GerritFixture.current().repository(), GerritFixture.current().location()))));
    }

    private String encode(String s) throws UnsupportedEncodingException {
        return URLEncoder.encode(s, "UTF-8");
    }

    public class TestGerritClient
    extends GerritClient212 {
        public TestGerritClient(TaskRepository repository, AbstractWebLocation location) {
            super(repository, GerritFixture.current().getGerritVersion());
            this.initialize(location, null, null, null, null);
        }

        protected byte[] fetchBinaryContent(String url, IProgressMonitor monitor) throws GerritException {
            return super.fetchBinaryContent(url, monitor);
        }

        protected void fetchRightBinaryContent(PatchScriptX patchScript, Patch.Key key, PatchSet.Id rightId, IProgressMonitor monitor) throws GerritException {
            super.fetchRightBinaryContent(patchScript, key, rightId, monitor);
        }

        protected void fetchLeftBinaryContent(PatchScriptX patchScript, Patch.Key key, PatchSet.Id leftId, IProgressMonitor monitor) throws GerritException {
            super.fetchLeftBinaryContent(patchScript, key, leftId, monitor);
        }

        protected String getUrlForPatchSet(Patch.Key key, PatchSet.Id id) throws GerritException {
            return super.getUrlForPatchSet(key, id);
        }

        protected String getUrlForPatchSetOrBase(Patch.Key key, PatchSet.Id id) throws GerritException {
            return super.getUrlForPatchSetOrBase(key, id);
        }
    }
}

