/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.gerrit.tests.core;

import com.google.gerrit.reviewdb.Project;
import java.io.File;
import java.util.Collections;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.mylyn.commons.net.AbstractWebLocation;
import org.eclipse.mylyn.commons.sdk.util.UiTestUtil;
import org.eclipse.mylyn.gerrit.tests.support.GerritFixture;
import org.eclipse.mylyn.gerrit.tests.support.GerritHarness;
import org.eclipse.mylyn.internal.gerrit.core.GerritConnector;
import org.eclipse.mylyn.internal.gerrit.core.GerritCorePlugin;
import org.eclipse.mylyn.internal.gerrit.core.GerritTaskSchema;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritClient;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritException;
import org.eclipse.mylyn.internal.gerrit.ui.GerritUiPlugin;
import org.eclipse.mylyn.internal.reviews.ui.RemoteUiFactoryProviderConfigurer;
import org.eclipse.mylyn.internal.tasks.core.ITasksCoreConstants;
import org.eclipse.mylyn.internal.tasks.core.RepositoryQuery;
import org.eclipse.mylyn.internal.tasks.core.TaskList;
import org.eclipse.mylyn.internal.tasks.core.data.TaskDataManager;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.reviews.core.spi.remote.RemoteFactoryProviderConfigurer;
import org.eclipse.mylyn.reviews.core.spi.remote.emf.AbstractRemoteEmfFactoryProvider;
import org.eclipse.mylyn.reviews.spi.edit.remote.AbstractRemoteEditFactoryProvider;
import org.eclipse.mylyn.reviews.spi.edit.remote.review.ReviewsRemoteEditFactoryProvider;
import org.eclipse.mylyn.reviews.ui.spi.remote.RemoteUiService;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskCommentMapper;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.sync.SynchronizationJob;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.tests.util.TestFixture;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class GerritSynchronizationTest
extends TestCase {
    private GerritHarness harness;
    private TaskRepository repository;
    private TaskDataManager taskDataManager;
    private TaskList taskList;
    private GerritClient client;

    @Before
    public void setUp() throws Exception {
        GerritUiPlugin.getDefault();
        TasksUiPlugin.getDefault().getPreferenceStore().setValue("org.eclipse.mylyn.tasks.ui.repositories.synch.schedule", false);
        Job.getJobManager().cancel(ITasksCoreConstants.JOB_FAMILY_SYNCHRONIZATION);
        TestFixture.resetTaskListAndRepositories();
        this.harness = GerritFixture.current().harness();
        this.repository = GerritFixture.current().singleRepository();
        GerritCorePlugin.getDefault().getConnector().setFactoryProviderConfigurer((RemoteFactoryProviderConfigurer)new RemoteUiFactoryProviderConfigurer());
        this.client = GerritCorePlugin.getDefault().getConnector().getClient(this.repository);
        AbstractRemoteEditFactoryProvider abstractRemoteEditFactoryProvider = (AbstractRemoteEditFactoryProvider)this.client.getFactoryProvider();
        GerritCorePlugin.getDefault().getConnector().getFactoryProviderConfigurer().configure((AbstractRemoteEmfFactoryProvider)abstractRemoteEditFactoryProvider);
        Assert.assertThat((Object)abstractRemoteEditFactoryProvider.getService(), (Matcher)Matchers.instanceOf(RemoteUiService.class));
        this.taskList = TasksUiPlugin.getTaskList();
        this.taskDataManager = TasksUiPlugin.getTaskDataManager();
        this.harness.ensureOneReviewExists();
    }

    @After
    public void tearDown() throws Exception {
        this.harness.dispose();
        TestFixture.resetTaskListAndRepositories();
        TasksUiPlugin.getRepositoryModel().clear();
    }

    @Test
    public void testSynchronizeBackgroundQueryTaskUpdated() throws Exception {
        ITask task = this.createAndSynchronizeQuery(false);
        String message = this.addComment(task);
        RepositoryQuery query = (RepositoryQuery)this.taskList.getQueries().iterator().next();
        this.synchronizeQuery(query, false);
        this.assertHasNewComment(task, message);
    }

    @Test
    public void testSynchronizeBackgroundTaskUpdated() throws Exception {
        ITask task = this.createAndSynchronizeQuery(false);
        String message = this.addComment(task);
        this.synchronizeTask(task, false);
        this.assertHasNewComment(task, message);
    }

    @Test
    public void testSynchronizeQueryNewTask() throws Exception {
        this.createAndSynchronizeQuery(true);
    }

    @Test
    public void testSynchronizeQueryTaskUpdated() throws Exception {
        ITask task = this.createAndSynchronizeQuery(true);
        String message = this.addComment(task);
        RepositoryQuery query = (RepositoryQuery)this.taskList.getQueries().iterator().next();
        this.synchronizeQuery(query, true);
        this.assertHasNewComment(task, message);
    }

    @Test
    public void testSynchronizeTaskUpdated() throws Exception {
        ITask task = this.createAndSynchronizeQuery(true);
        String message = this.addComment(task);
        this.synchronizeTask(task, true);
        this.assertHasNewComment(task, message);
    }

    @Test
    public void testGetFromChangeId() throws Exception {
        ITask task = this.createAndSynchronizeQuery(true);
        AbstractRepositoryConnector connector = TasksUi.getRepositoryConnector((String)this.repository.getConnectorKind());
        GerritClient client = ((GerritConnector)connector).getClient(this.repository);
        Project.NameKey project = new Project.NameKey(this.taskDataManager.getTaskData(task).getRoot().getMappedAttribute("task.common.product").getValue());
        client.clearCachedBranches(project);
        GerritSynchronizationTest.assertNull((Object)client.getCachedBranches(project));
        TaskData taskData = connector.getTaskData(this.repository, task.getTaskId(), (IProgressMonitor)new NullProgressMonitor());
        GerritSynchronizationTest.assertEquals((String)task.getTaskId(), (String)taskData.getTaskId());
        GerritSynchronizationTest.assertNotNull((Object)client.getCachedBranches(project));
        TaskAttribute changeIdAttribute = taskData.getRoot().getAttribute(GerritTaskSchema.getDefault().CHANGE_ID.getKey());
        GerritSynchronizationTest.assertNotNull((Object)changeIdAttribute);
        Assert.assertThat((Object)task.getTaskId(), (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)changeIdAttribute.getValue())));
        TaskData taskDataFromChangeId = connector.getTaskData(this.repository, changeIdAttribute.getValue(), (IProgressMonitor)new NullProgressMonitor());
        GerritSynchronizationTest.assertEquals((String)task.getTaskId(), (String)taskDataFromChangeId.getTaskId());
        GerritSynchronizationTest.assertEquals((String)taskData.getRoot().toString(), (String)taskDataFromChangeId.getRoot().toString());
    }

    private String addComment(ITask task) throws GerritException {
        this.taskDataManager.setTaskRead(task, true);
        GerritClient client = GerritClient.create(null, (AbstractWebLocation)this.harness.location());
        String message = "new comment, time: " + System.currentTimeMillis();
        client.publishComments(task.getTaskId(), 1, message, Collections.emptySet(), null);
        return message;
    }

    private void assertHasNewComment(ITask task, String message) throws CoreException {
        GerritSynchronizationTest.assertEquals((Object)ITask.SynchronizationState.INCOMING, (Object)task.getSynchronizationState());
        TaskData taskData = this.taskDataManager.getTaskData(task);
        List comments = taskData.getAttributeMapper().getAttributesByType(taskData, "comment");
        TaskCommentMapper lastComment = TaskCommentMapper.createFrom((TaskAttribute)((TaskAttribute)comments.get(comments.size() - 1)));
        GerritSynchronizationTest.assertEquals((String)("Failure on " + GerritFixture.current().getRepositoryUrl() + "/" + task.getTaskId()), (String)("Patch Set 1:\n\n" + message), (String)lastComment.getText());
    }

    private ITask assertTaskListHasOneTask() throws CoreException {
        GerritSynchronizationTest.assertTrue((this.taskList.getAllTasks().size() >= 1 ? 1 : 0) != 0);
        ITask task = (ITask)this.taskList.getAllTasks().iterator().next();
        GerritSynchronizationTest.assertEquals((String)this.repository.getUrl(), (String)task.getRepositoryUrl());
        GerritSynchronizationTest.assertTrue((boolean)this.taskDataManager.hasTaskData(task));
        return task;
    }

    private ITask createAndSynchronizeQuery(boolean user) throws Exception {
        IRepositoryQuery query = TasksUi.getRepositoryModel().createRepositoryQuery(this.repository);
        query.setAttribute("gerrit query type", "custom");
        query.setAttribute("gerrit query string", this.harness.defaultQuery());
        this.taskList.addQuery((RepositoryQuery)query);
        this.synchronizeQuery((RepositoryQuery)query, user);
        ITask task = this.assertTaskListHasOneTask();
        GerritSynchronizationTest.assertEquals((Object)ITask.SynchronizationState.INCOMING_NEW, (Object)task.getSynchronizationState());
        String filePath = this.client.getFactoryProvider().getDataLocator().getModelPath() + File.separator + "org.eclipse.mylyn.gerrit-" + ReviewsRemoteEditFactoryProvider.asFileName((String)this.repository.getUrl()) + File.separator + "Review" + File.separator + task.getTaskId() + ".reviews";
        File file = new File(filePath);
        Assert.assertThat((String)("File should exist at: " + filePath), (Object)file.exists(), (Matcher)Matchers.is((Object)true));
        return task;
    }

    private void synchronizeQuery(RepositoryQuery query, boolean user) throws InterruptedException {
        AbstractRepositoryConnector connector = TasksUiPlugin.getRepositoryManager().getRepositoryConnector(this.repository.getConnectorKind());
        SynchronizationJob job = TasksUiPlugin.getTaskJobFactory().createSynchronizeQueriesJob(connector, this.repository, Collections.singleton(query));
        job.setUser(user);
        job.schedule();
        job.join();
        boolean synchronizing = true;
        while (synchronizing) {
            try {
                Job.getJobManager().join(ITasksCoreConstants.JOB_FAMILY_SYNCHRONIZATION, null);
                synchronizing = false;
            }
            catch (InterruptedException e) {
                UiTestUtil.waitForDisplay();
            }
        }
    }

    private void synchronizeTask(ITask task, boolean user) throws InterruptedException {
        SynchronizationJob job = TasksUiPlugin.getTaskJobFactory().createSynchronizeTasksJob(TasksUi.getRepositoryConnector((String)this.repository.getConnectorKind()), this.repository, Collections.singleton(task));
        job.setUser(user);
        job.schedule();
        boolean synchronizing = true;
        while (synchronizing) {
            try {
                job.join();
                synchronizing = false;
            }
            catch (InterruptedException e) {
                UiTestUtil.waitForDisplay();
            }
        }
    }
}

