/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.gerrit.tests.core;

import junit.framework.TestCase;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.mylyn.commons.net.AuthenticationType;
import org.eclipse.mylyn.gerrit.tests.support.GerritFixture;
import org.eclipse.mylyn.gerrit.tests.support.GerritHarness;
import org.eclipse.mylyn.internal.gerrit.core.GerritConnector;
import org.eclipse.mylyn.internal.gerrit.core.GerritTaskSchema;
import org.eclipse.mylyn.internal.tasks.core.RepositoryQuery;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.data.TaskDataCollector;
import org.eclipse.mylyn.tests.util.InMemoryTaskDataCollector;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class GerritConnectorTest
extends TestCase {
    private GerritHarness harness;
    private GerritConnector connector;
    private TaskRepository repository;

    @Before
    public void setUp() throws Exception {
        this.harness = GerritFixture.current().harness();
        this.connector = new GerritConnector();
        this.repository = GerritFixture.current().singleRepository();
        this.harness.ensureOneReviewExists();
    }

    @After
    public void tearDown() throws Exception {
        this.harness.dispose();
    }

    @Test
    public void testPerformQueryAnonymous() throws Exception {
        this.repository.setCredentials(AuthenticationType.REPOSITORY, null, false);
        RepositoryQuery query = new RepositoryQuery(this.repository.getConnectorKind(), "query");
        query.setAttribute("gerrit query type", "all open changes");
        query.setAttribute("gerrit query string", "all open changes");
        InMemoryTaskDataCollector resultCollector = new InMemoryTaskDataCollector();
        IStatus status = this.connector.performQuery(this.repository, (IRepositoryQuery)query, (TaskDataCollector)resultCollector, null, (IProgressMonitor)new NullProgressMonitor());
        GerritConnectorTest.assertEquals((Object)Status.OK_STATUS, (Object)status);
        GerritConnectorTest.assertTrue((resultCollector.getResults().size() > 0 ? 1 : 0) != 0);
        for (TaskData result : resultCollector.getResults()) {
            GerritConnectorTest.assertTrue((boolean)result.isPartial());
            GerritConnectorTest.assertNull((Object)result.getRoot().getAttribute(GerritTaskSchema.getDefault().UPLOADED.getKey()));
            TaskAttribute key = result.getRoot().getAttribute(GerritTaskSchema.getDefault().KEY.getKey());
            GerritConnectorTest.assertNotNull((Object)key);
            String value = key.getValue();
            GerritConnectorTest.assertNotNull((Object)value);
            GerritConnectorTest.assertTrue((boolean)value.startsWith("I"));
            String objId = StringUtils.rightPad((String)value.substring(1), (int)40, (char)'a');
            GerritConnectorTest.assertTrue((boolean)ObjectId.isId((String)objId));
            TaskAttribute owner = result.getRoot().getAttribute(GerritTaskSchema.getDefault().OWNER.getKey());
            GerritConnectorTest.assertNotNull((Object)owner);
            GerritConnectorTest.assertTrue((boolean)StringUtils.isNotBlank((String)owner.getValue()));
        }
    }
}

