/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gerrit.core.remote;

import com.google.gerrit.common.data.ChangeInfo;
import com.google.gerrit.reviewdb.Change;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.mylyn.internal.gerrit.core.remote.GerritRemoteFactoryProvider;
import org.eclipse.mylyn.internal.gerrit.core.remote.GerritReviewRemoteFactory;
import org.eclipse.mylyn.reviews.core.model.IChange;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class GerritReviewRemoteFactoryTest {
    @Test
    public void isDependenciesDifferent() throws Exception {
        GerritReviewRemoteFactory factory = new GerritReviewRemoteFactory((GerritRemoteFactoryProvider)Mockito.mock(GerritRemoteFactoryProvider.class));
        Assert.assertFalse((boolean)factory.isDependenciesDifferent(Collections.emptyList(), Collections.emptyList()));
        Assert.assertFalse((boolean)factory.isDependenciesDifferent(GerritReviewRemoteFactoryTest.changes(1), GerritReviewRemoteFactoryTest.changeInfos(1)));
        Assert.assertFalse((boolean)factory.isDependenciesDifferent(GerritReviewRemoteFactoryTest.changes(1, 2, 3), GerritReviewRemoteFactoryTest.changeInfos(3, 1, 2)));
        Assert.assertTrue((boolean)factory.isDependenciesDifferent(GerritReviewRemoteFactoryTest.changes(1), Collections.emptyList()));
        Assert.assertTrue((boolean)factory.isDependenciesDifferent(Collections.emptyList(), GerritReviewRemoteFactoryTest.changeInfos(1)));
        Assert.assertTrue((boolean)factory.isDependenciesDifferent(GerritReviewRemoteFactoryTest.changes(1), GerritReviewRemoteFactoryTest.changeInfos(2)));
        Assert.assertTrue((boolean)factory.isDependenciesDifferent(GerritReviewRemoteFactoryTest.changes(1), GerritReviewRemoteFactoryTest.changeInfos(2, 3)));
        Assert.assertTrue((boolean)factory.isDependenciesDifferent(GerritReviewRemoteFactoryTest.changes(1, 2), GerritReviewRemoteFactoryTest.changeInfos(2, 3)));
    }

    private static List<IChange> changes(int ... ids) {
        ArrayList<IChange> result = new ArrayList<IChange>(ids.length);
        int[] nArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            int id = nArray[n2];
            IChange change = (IChange)Mockito.mock(IChange.class);
            Mockito.when((Object)change.getId()).thenReturn((Object)Integer.toString(id));
            result.add(change);
            ++n2;
        }
        return result;
    }

    private static List<ChangeInfo> changeInfos(int ... ids) {
        ArrayList<ChangeInfo> result = new ArrayList<ChangeInfo>(ids.length);
        int[] nArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            int id = nArray[n2];
            ChangeInfo changeInfo = (ChangeInfo)Mockito.mock(ChangeInfo.class);
            Mockito.when((Object)changeInfo.getId()).thenReturn((Object)new Change.Id(id));
            result.add(changeInfo);
            ++n2;
        }
        return result;
    }
}

