/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gerrit.core.egit;

import com.google.gerrit.common.data.GerritConfig;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.egit.core.RepositoryCache;
import org.eclipse.egit.core.RepositoryUtil;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.mylyn.internal.gerrit.core.egit.GerritToGitMapping;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class GerritToGitMappingTest {
    private static final String GERRIT_GIT_HOST = "egit.eclipse.org";
    private static final String GERRIT_PROJECT = "jgit";

    @Test
    public void testFindNoMatchingEmptyList() throws Exception {
        GerritToGitMapping mapping = this.createTestMapping(this.createRepositories(new String[0]));
        Assert.assertNull((Object)mapping.find());
    }

    @Test
    public void testFindNoMatching() throws Exception {
        GerritToGitMapping mapping = this.createTestMapping(this.createRepositories("project1", "project2"));
        Assert.assertNull((Object)mapping.find());
    }

    @Test
    public void testFindMatching() throws Exception {
        GerritToGitMapping mapping = this.createTestMapping(this.createRepositories("project1", GERRIT_PROJECT));
        Assert.assertNotNull((Object)mapping.find());
    }

    private Repository[] createRepositories(String ... projects) {
        ArrayList<Repository> repos = new ArrayList<Repository>();
        String[] stringArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            String project = stringArray[n2];
            repos.add(this.createRepository(project));
            ++n2;
        }
        return repos.toArray(new Repository[repos.size()]);
    }

    private Repository createRepository(String project) {
        StoredConfig config = (StoredConfig)Mockito.mock(StoredConfig.class);
        HashSet<String> configSubSections = new HashSet<String>();
        String remoteName = "remotename";
        configSubSections.add(remoteName);
        String remoteSection = "remote";
        Mockito.when((Object)config.getSubsections(remoteSection)).thenReturn(configSubSections);
        Mockito.when((Object)config.getStringList((String)ArgumentMatchers.eq((Object)remoteSection), (String)ArgumentMatchers.eq((Object)remoteName), ArgumentMatchers.anyString())).thenReturn((Object)new String[0]);
        Mockito.when((Object)config.getStringList((String)ArgumentMatchers.eq((Object)remoteSection), (String)ArgumentMatchers.eq((Object)remoteName), ArgumentMatchers.matches((String)"url"))).thenReturn((Object)new String[]{"git://egit.eclipse.org/" + project});
        Repository repo = (Repository)Mockito.mock(Repository.class);
        Mockito.when((Object)repo.getConfig()).thenReturn((Object)config);
        return repo;
    }

    private GerritToGitMapping createTestMapping(Repository[] repositories) throws Exception {
        List<String> repoDirList = this.createRepositoryDirList(repositories.length);
        final RepositoryUtil util = (RepositoryUtil)Mockito.mock(RepositoryUtil.class);
        Mockito.when((Object)util.getConfiguredRepositories()).thenReturn(repoDirList);
        final RepositoryCache cache = (RepositoryCache)Mockito.mock(RepositoryCache.class);
        for (String dir : repoDirList) {
            Mockito.when((Object)cache.lookupRepository(new File(dir))).thenReturn((Object)repositories[Integer.parseInt(dir)]);
        }
        TaskRepository repository = new TaskRepository("org.eclipse.mylyn.gerrit", "http://egit.eclipse.org");
        return new GerritToGitMapping(repository, new GerritConfig(), GERRIT_PROJECT){

            RepositoryCache getRepositoryCache() {
                return cache;
            }

            RepositoryUtil getRepositoryUtil() {
                return util;
            }
        };
    }

    private List<String> createRepositoryDirList(int length) {
        ArrayList<String> repoList = new ArrayList<String>(length);
        int i = 0;
        while (i < length) {
            repoList.add(String.valueOf(new String()) + i);
            ++i;
        }
        return repoList;
    }

    @Test
    public void testCalcGit() throws Exception {
        URIish uri = new URIish("git://egit.eclipse.org/jgit");
        Assert.assertThat((Object)GerritToGitMapping.calcProjectNameFromUri((URIish)uri), (Matcher)Is.is((Object)GERRIT_PROJECT));
    }

    @Test
    public void testCalcGitWithDotGitSuffix() throws Exception {
        URIish uri = new URIish("git://egit.eclipse.org/jgit.git");
        Assert.assertThat((Object)GerritToGitMapping.calcProjectNameFromUri((URIish)uri), (Matcher)Is.is((Object)GERRIT_PROJECT));
    }

    @Test
    public void testCalcGitWithGerritHttpPrefix() throws Exception {
        URIish uri = new URIish("git://egit.eclipse.org/p/jgit");
        Assert.assertThat((Object)GerritToGitMapping.calcProjectNameFromUri((URIish)uri), (Matcher)Is.is((Object)"p/jgit"));
    }

    @Test
    public void testCalcSsh() throws Exception {
        URIish uri = new URIish("ssh://user@egit.eclipse.org:29418/jgit");
        Assert.assertThat((Object)GerritToGitMapping.calcProjectNameFromUri((URIish)uri), (Matcher)Is.is((Object)GERRIT_PROJECT));
    }

    @Test
    public void testCalcHttp() throws Exception {
        URIish uri = new URIish("http://egit.eclipse.org/p/jgit");
        Assert.assertThat((Object)GerritToGitMapping.calcProjectNameFromUri((URIish)uri), (Matcher)Is.is((Object)GERRIT_PROJECT));
    }

    @Test
    public void testCalcHttps() throws Exception {
        URIish uri = new URIish("https://egit.eclipse.org/p/jgit");
        Assert.assertThat((Object)GerritToGitMapping.calcProjectNameFromUri((URIish)uri), (Matcher)Is.is((Object)GERRIT_PROJECT));
    }

    @Test
    public void testCalcHttpWithPort() throws Exception {
        URIish uri = new URIish("http://egit.eclipse.org:8080/p/jgit");
        Assert.assertThat((Object)GerritToGitMapping.calcProjectNameFromUri((URIish)uri), (Matcher)Is.is((Object)GERRIT_PROJECT));
    }

    @Test
    public void testCalcHttpWithUser() throws Exception {
        URIish uri = new URIish("http://user@egit.eclipse.org/p/jgit");
        Assert.assertThat((Object)GerritToGitMapping.calcProjectNameFromUri((URIish)uri), (Matcher)Is.is((Object)GERRIT_PROJECT));
    }

    @Test
    public void testCalcHttpWithPrefix() throws Exception {
        URIish uri = new URIish("http://egit.eclipse.org/r/p/jgit");
        Assert.assertThat((Object)GerritToGitMapping.calcProjectNameFromUri((URIish)uri), (Matcher)Is.is((Object)GERRIT_PROJECT));
    }

    @Test
    public void testCalcHttpWithSubProject() throws Exception {
        URIish uri = new URIish("http://egit.eclipse.org/p/jgit/subproj");
        Assert.assertThat((Object)GerritToGitMapping.calcProjectNameFromUri((URIish)uri), (Matcher)Is.is((Object)"jgit/subproj"));
    }

    @Test
    public void testCalcHttpWithoutGerritPrefix() throws Exception {
        URIish uri = new URIish("http://egit.eclipse.org/jgit");
        Assert.assertThat((Object)GerritToGitMapping.calcProjectNameFromUri((URIish)uri), (Matcher)Is.is((Object)GERRIT_PROJECT));
    }

    @Test
    public void testCalcUnknownProtocol() throws Exception {
        URIish uri = new URIish("xyz://user@egit.eclipse.org:29418/jgit");
        Assert.assertThat((Object)GerritToGitMapping.calcProjectNameFromUri((URIish)uri), (Matcher)Is.is((Object)GERRIT_PROJECT));
    }
}

