/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gerrit.core.client;

import java.sql.Timestamp;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.eclipse.mylyn.internal.gerrit.core.client.JSonSupport;
import org.junit.Assert;
import org.junit.Test;

public class JSonSupportTest {
    @Test
    public void testParseDate() {
        JSonSupport json = new JSonSupport();
        GregorianCalendar c = new GregorianCalendar(2012, 0, 26, 12, 33, 11);
        c.set(14, 110);
        ((Calendar)c).setTimeZone(TimeZone.getTimeZone("UTC"));
        Assert.assertEquals((Object)new Timestamp(c.getTimeInMillis()), (Object)json.parseResponse("\"2012-01-26 12:33:11.110000000\"", Timestamp.class));
        c = new GregorianCalendar(2012, 10, 8, 21, 38, 35);
        c.set(14, 337);
        ((Calendar)c).setTimeZone(TimeZone.getTimeZone("UTC"));
        Assert.assertEquals((Object)new Timestamp(c.getTimeInMillis()), (Object)json.parseResponse("\"2012-11-08 21:38:35.337000000\"", Timestamp.class));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testParseResponseNull() {
        new JSonSupport().parseResponse(null, Timestamp.class);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testParseResponseEmpty() {
        new JSonSupport().parseResponse("", Timestamp.class);
    }
}

