/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gerrit.core.client;

import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.eclipse.core.runtime.AssertionFailedException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.mylyn.commons.net.AbstractWebLocation;
import org.eclipse.mylyn.commons.net.AuthenticationCredentials;
import org.eclipse.mylyn.commons.net.AuthenticationType;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritCapabilities;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritException;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritHttpClient;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritLoginException;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class GerritHttpClientTest {
    @Mock
    AbstractWebLocation abstractWebLocation;
    @Mock
    IProgressMonitor progressMonitor;

    @Test(expected=AssertionFailedException.class)
    public void constructorNull() {
        new GerritHttpClient(null, GerritCapabilities.MAXIMUM_SUPPORTED_VERSION);
    }

    @Test(expected=AssertionFailedException.class)
    public void postJsonRequestNullServiceUri() throws IOException, GerritException {
        GerritHttpClient gerritHttpClient = new GerritHttpClient(this.abstractWebLocation, GerritCapabilities.MAXIMUM_SUPPORTED_VERSION);
        gerritHttpClient.postJsonRequest(null, new GerritHttpClient.JsonEntity(){

            public String getContent() {
                return "[]";
            }
        }, this.progressMonitor);
    }

    @Test(expected=AssertionFailedException.class)
    public void postJsonRequestNullJsonEntity() throws IOException, GerritException {
        GerritHttpClient gerritHttpClient = new GerritHttpClient(this.abstractWebLocation, GerritCapabilities.MAXIMUM_SUPPORTED_VERSION);
        gerritHttpClient.postJsonRequest("not null", null, this.progressMonitor);
    }

    @Test
    public void restRequestCanReturnBinaryContent() throws IOException {
        TypeToken<Byte[]> byteArrayType = new TypeToken<Byte[]>(){};
        GerritHttpClient gerritHttpClient = new GerritHttpClient(this.abstractWebLocation, GerritCapabilities.MAXIMUM_SUPPORTED_VERSION);
        gerritHttpClient.getClass();
        GerritHttpClient.RestRequest request = new GerritHttpClient.RestRequest(gerritHttpClient, GerritHttpClient.Request.HttpMethod.GET, "serviceUri", null, byteArrayType.getType(), null);
        HttpMethodBase httpMethodBase = (HttpMethodBase)Mockito.mock(HttpMethodBase.class);
        byte[] binary = "binary".getBytes();
        Mockito.when((Object)httpMethodBase.getResponseBody()).thenReturn((Object)binary);
        byte[] result = (byte[])request.process(httpMethodBase);
        Assert.assertArrayEquals((byte[])binary, (byte[])result);
    }

    @Test
    public void authenticateForm() throws IOException, GerritException {
        GerritHttpClient client = (GerritHttpClient)Mockito.spy((Object)((Object)new TestGerritHttpClient(this.abstractWebLocation, 400)));
        int result = client.authenticateForm(new AuthenticationCredentials("", ""), (IProgressMonitor)new NullProgressMonitor());
        Assert.assertEquals((long)404L, (long)result);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{client});
        ((GerritHttpClient)inOrder.verify((Object)client)).execute((HttpMethod)ArgumentMatchers.isA(PostMethod.class), (IProgressMonitor)ArgumentMatchers.any(IProgressMonitor.class));
        ((GerritHttpClient)inOrder.verify((Object)client)).execute((HttpMethod)ArgumentMatchers.isA(GetMethod.class), (IProgressMonitor)ArgumentMatchers.any(IProgressMonitor.class));
        client = (GerritHttpClient)Mockito.spy((Object)((Object)new TestGerritHttpClient(this.abstractWebLocation, 405)));
        result = client.authenticateForm(new AuthenticationCredentials("", ""), (IProgressMonitor)new NullProgressMonitor());
        Assert.assertEquals((long)404L, (long)result);
        inOrder = Mockito.inOrder((Object[])new Object[]{client});
        ((GerritHttpClient)inOrder.verify((Object)client)).execute((HttpMethod)ArgumentMatchers.isA(PostMethod.class), (IProgressMonitor)ArgumentMatchers.any(IProgressMonitor.class));
        ((GerritHttpClient)inOrder.verify((Object)client)).execute((HttpMethod)ArgumentMatchers.isA(GetMethod.class), (IProgressMonitor)ArgumentMatchers.any(IProgressMonitor.class));
        client = (GerritHttpClient)Mockito.spy((Object)((Object)new TestGerritHttpClient(this.abstractWebLocation, 401)));
        result = client.authenticateForm(new AuthenticationCredentials("", ""), (IProgressMonitor)new NullProgressMonitor());
        Assert.assertEquals((long)-1L, (long)result);
        ((GerritHttpClient)Mockito.verify((Object)client)).execute((HttpMethod)ArgumentMatchers.isA(PostMethod.class), (IProgressMonitor)ArgumentMatchers.any(IProgressMonitor.class));
        ((GerritHttpClient)Mockito.verify((Object)client, (VerificationMode)Mockito.never())).execute((HttpMethod)ArgumentMatchers.isA(GetMethod.class), (IProgressMonitor)ArgumentMatchers.any(IProgressMonitor.class));
    }

    public class TestGerritHttpClient
    extends GerritHttpClient {
        private final int code;

        private TestGerritHttpClient(AbstractWebLocation location, int code) {
            super(location, GerritCapabilities.MAXIMUM_SUPPORTED_VERSION);
            this.code = code;
        }

        public int execute(HttpMethod method, IProgressMonitor monitor) throws IOException {
            return this.code;
        }

        void requestCredentials(IProgressMonitor monitor, AuthenticationType authenticationType) throws GerritLoginException {
        }

        String getUrl() {
            return "http://mock";
        }
    }
}

