/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gerrit.core;

import com.google.common.collect.ImmutableList;
import org.eclipse.mylyn.internal.gerrit.core.HudsonCommentParser;
import org.eclipse.mylyn.reviews.internal.core.BuildResult;
import org.junit.Assert;
import org.junit.Test;

public class HudsonCommentParserTest {
    private final HudsonCommentParser parser = new HudsonCommentParser();

    @Test
    public void canParseBuildStartedMessage() {
        String message = "Patch Set 1:\r\nBuild Started https://hudson.eclipse.org/mylyn/job/gerrit-mylyn-reviews/1017/";
        ImmutableList results = this.parser.getBuildResult(message);
        Assert.assertEquals((long)1L, (long)results.size());
        BuildResult result = (BuildResult)results.get(0);
        Assert.assertEquals((long)1L, (long)result.getPatchSetNumber());
        Assert.assertEquals((long)1017L, (long)result.getBuildNumber());
        Assert.assertEquals((Object)"https://hudson.eclipse.org/mylyn/job/gerrit-mylyn-reviews/1017/", (Object)result.getBuildUrl());
        Assert.assertEquals((Object)"https://hudson.eclipse.org/mylyn/job/gerrit-mylyn-reviews", (Object)result.getJobName());
        Assert.assertEquals((Object)BuildResult.BuildStatus.STARTED, (Object)result.getBuildStatus());
    }

    @Test
    public void canParseBuildGenericMessage() {
        String message = "Patch Set 4: Verified+1\r\n\r\nBuild Successful\r\n\r\nhttps://hudson.eclipse.org/mylyn/job/gerrit-mylyn-reviews/1023/ : SUCCESS";
        ImmutableList results = this.parser.getBuildResult(message);
        Assert.assertEquals((long)1L, (long)results.size());
        BuildResult result = (BuildResult)results.get(0);
        Assert.assertEquals((long)4L, (long)result.getPatchSetNumber());
        Assert.assertEquals((long)1023L, (long)result.getBuildNumber());
        Assert.assertEquals((Object)"https://hudson.eclipse.org/mylyn/job/gerrit-mylyn-reviews/1023/", (Object)result.getBuildUrl());
        Assert.assertEquals((Object)"https://hudson.eclipse.org/mylyn/job/gerrit-mylyn-reviews", (Object)result.getJobName());
        Assert.assertEquals((Object)BuildResult.BuildStatus.SUCCESS, (Object)result.getBuildStatus());
        String failedMessage = "Patch Set 9: Verified -1\r\n\r\nBuild failure\r\n\r\nhttps://hudson.eclipse.org/mylyn/job/gerrit-mylyn-reviews/1023/ : ABORTED";
        ImmutableList failedResults = this.parser.getBuildResult(failedMessage);
        Assert.assertEquals((long)1L, (long)failedResults.size());
        BuildResult failedResult = (BuildResult)failedResults.get(0);
        Assert.assertEquals((Object)BuildResult.BuildStatus.ABORTED, (Object)failedResult.getBuildStatus());
    }

    @Test
    public void doesNotParseQuotedHudsonComment() {
        String messageSpacesAfter = "> Patch Set 4: Verified+1\r\n> \r\n> Build Successful\r\n> \r\n> https://hudson.eclipse.org/mylyn/job/gerrit-mylyn-reviews/1023/ : SUCCESS";
        String messageSpacesBeforeAndAfter = " > Patch Set 4: Verified+1\r\n > \r\n > Build Successful\r\n > \r\n > https://hudson.eclipse.org/mylyn/job/gerrit-mylyn-reviews/1023/ : SUCCESS";
        ImmutableList results = this.parser.getBuildResult(messageSpacesAfter);
        Assert.assertEquals((long)0L, (long)results.size());
        ImmutableList resultsForDoubleSpacing = this.parser.getBuildResult(messageSpacesBeforeAndAfter);
        Assert.assertEquals((long)0L, (long)resultsForDoubleSpacing.size());
    }

    @Test
    public void canParseHudson3BuildMessages() {
        String newMessage = "Patch Set 9: Verified -1\r\n\r\nBuild successful\r\n\r\nhttps://hudson.eclipse.org/mylyn/job/gerrit-mylyn-reviews/1023/ : {}";
        BuildResult.BuildStatus[] buildStatusArray = BuildResult.BuildStatus.values();
        int n = buildStatusArray.length;
        int n2 = 0;
        while (n2 < n) {
            BuildResult.BuildStatus status = buildStatusArray[n2];
            String message = newMessage.replace("{}", status.toString());
            ImmutableList results = this.parser.getBuildResult(message);
            Assert.assertEquals((long)1L, (long)results.size());
            BuildResult result = (BuildResult)results.get(0);
            Assert.assertEquals((Object)status, (Object)result.getBuildStatus());
            ++n2;
        }
    }

    @Test
    public void canParseWithIntegerInUrl() {
        String message = "Patch Set 4: Verified+1\r\n\r\nBuild Successful\r\n\r\nhttps://hudson2.eclipse.org/mylyn/job/gerrit-mylyn-reviews/1023/ : SUCCESS";
        ImmutableList results = this.parser.getBuildResult(message);
        Assert.assertEquals((long)1L, (long)results.size());
        BuildResult result = (BuildResult)results.get(0);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)4L, (long)result.getPatchSetNumber());
        Assert.assertEquals((long)1023L, (long)result.getBuildNumber());
    }

    @Test
    public void canParseWithIntegersInJobUrl() {
        String message = "Patch Set 5: Verified+1\r\n\r\nBuild Successful\r\n\r\nhttps://hudson2.eclipse.org/2mylyn/job/2gerrit-mylyn-2reviews/1023/ : SUCCESS";
        ImmutableList results = this.parser.getBuildResult(message);
        Assert.assertEquals((long)1L, (long)results.size());
        BuildResult result = (BuildResult)results.get(0);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)5L, (long)result.getPatchSetNumber());
        Assert.assertEquals((long)1023L, (long)result.getBuildNumber());
    }

    @Test
    public void missingPatchSetNumberShouldReturnEmpty() {
        String message = "Patch Set :\r\nBuild Started https://hudson.eclipse.org/mylyn/job/gerrit-mylyn-reviews/1017/";
        ImmutableList results = this.parser.getBuildResult(message);
        Assert.assertEquals((long)0L, (long)results.size());
    }

    @Test
    public void nonHudsonCommentShouldReturnEmpty() {
        String message = "Uploaded patch set 2.";
        ImmutableList results = this.parser.getBuildResult(message);
        Assert.assertEquals((long)0L, (long)results.size());
    }

    @Test
    public void missingBuildNumberShouldReturnEmpty() {
        String message = "Patch Set 1:\r\nBuild Started https://hudson.eclipse.org/mylyn/job/gerrit-mylyn-reviews/";
        ImmutableList results = this.parser.getBuildResult(message);
        Assert.assertEquals((long)0L, (long)results.size());
    }

    @Test
    public void missingBuildStatusShouldReturnEmpty() {
        String message = "Patch Set 4: Verified+1\r\n\r\nBuild Successful\r\n\r\nhttps://hudson.eclipse.org/mylyn/job/gerrit-mylyn-reviews/1023/ :";
        String message2 = "Patch Set 4: Verified+1\r\n\r\nBuild Successful\r\n\r\nhttps://hudson.eclipse.org/mylyn/job/gerrit-mylyn-reviews/1023/";
        String message3 = "Patch Set 4:\r\nStarted https://hudson.eclipse.org/mylyn/job/gerrit-mylyn-reviews/1017/";
        ImmutableList result = this.parser.getBuildResult(message);
        ImmutableList result2 = this.parser.getBuildResult(message2);
        ImmutableList result3 = this.parser.getBuildResult(message3);
        Assert.assertEquals((long)0L, (long)result.size());
        Assert.assertEquals((long)0L, (long)result2.size());
        Assert.assertEquals((long)0L, (long)result3.size());
    }

    @Test
    public void missingUrlShouldReturnEmpty() {
        String message = "Patch Set 1:\r\nBuild Started";
        ImmutableList results = this.parser.getBuildResult(message);
        Assert.assertEquals((long)0L, (long)results.size());
    }

    @Test
    public void emptyCommentShouldReturnEmpty() {
        String message = "";
        ImmutableList results = this.parser.getBuildResult(message);
        Assert.assertEquals((long)0L, (long)results.size());
    }

    @Test
    public void multipleJobNamesInCommentAreParsedCorrectly() {
        String multipleJobMessage = "Patch Set 1: Verified+1\r\nBuild Successful \r\nhttps://hudson.eclipse.org/sirius/job/sirius.gerrit.tests-mars/2434/ : SUCCESS\r\nhttps://hudson.eclipse.org/sirius/job/sirius.gerrit.build-mars/2584/ : SUCCESS";
        ImmutableList results = this.parser.getBuildResult(multipleJobMessage);
        Assert.assertEquals((long)2L, (long)results.size());
        BuildResult result1 = (BuildResult)results.get(0);
        BuildResult result2 = (BuildResult)results.get(1);
        Assert.assertEquals((long)1L, (long)result1.getPatchSetNumber());
        Assert.assertEquals((long)2434L, (long)result1.getBuildNumber());
        Assert.assertEquals((Object)"https://hudson.eclipse.org/sirius/job/sirius.gerrit.tests-mars/2434/", (Object)result1.getBuildUrl());
        Assert.assertEquals((Object)"https://hudson.eclipse.org/sirius/job/sirius.gerrit.tests-mars", (Object)result1.getJobName());
        Assert.assertEquals((Object)BuildResult.BuildStatus.SUCCESS, (Object)result1.getBuildStatus());
        Assert.assertEquals((long)1L, (long)result2.getPatchSetNumber());
        Assert.assertEquals((long)2584L, (long)result2.getBuildNumber());
        Assert.assertEquals((Object)"https://hudson.eclipse.org/sirius/job/sirius.gerrit.build-mars/2584/", (Object)result2.getBuildUrl());
        Assert.assertEquals((Object)"https://hudson.eclipse.org/sirius/job/sirius.gerrit.build-mars", (Object)result2.getJobName());
        Assert.assertEquals((Object)BuildResult.BuildStatus.SUCCESS, (Object)result2.getBuildStatus());
    }

    @Test
    public void multipleJobNamesWithBadDataIgnoresBadResults() {
        String multipleJobMessage = "Patch Set 1: Verified+1\r\nBuild Successful \r\nhttps://hudson.eclipse.org/sirius/job/sirius.gerrit.tests-mars/2434/ : SUCCESS\r\nhttps://hudson.eclipse.org/sirius/job/sirius.gerrit.build-mars";
        ImmutableList results = this.parser.getBuildResult(multipleJobMessage);
        Assert.assertEquals((long)1L, (long)results.size());
        BuildResult result1 = (BuildResult)results.get(0);
        Assert.assertEquals((long)1L, (long)result1.getPatchSetNumber());
        Assert.assertEquals((long)2434L, (long)result1.getBuildNumber());
        Assert.assertEquals((Object)"https://hudson.eclipse.org/sirius/job/sirius.gerrit.tests-mars/2434/", (Object)result1.getBuildUrl());
        Assert.assertEquals((Object)"https://hudson.eclipse.org/sirius/job/sirius.gerrit.tests-mars", (Object)result1.getJobName());
        Assert.assertEquals((Object)BuildResult.BuildStatus.SUCCESS, (Object)result1.getBuildStatus());
    }
}

