/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gerrit.core;

import com.google.common.collect.ImmutableList;
import com.google.gerrit.common.data.AccountInfo;
import com.google.gerrit.reviewdb.Account;
import com.google.gerrit.reviewdb.Branch;
import com.google.gerrit.reviewdb.Change;
import com.google.gerrit.reviewdb.Project;
import java.sql.Timestamp;
import java.util.Collections;
import org.eclipse.mylyn.internal.gerrit.core.GerritConnector;
import org.eclipse.mylyn.internal.gerrit.core.GerritTaskDataHandler;
import org.eclipse.mylyn.internal.gerrit.core.GerritTaskSchema;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritChange;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritConfiguration;
import org.eclipse.mylyn.internal.gerrit.core.client.compat.GerritConfigX;
import org.eclipse.mylyn.internal.gerrit.core.client.data.GerritPerson;
import org.eclipse.mylyn.internal.gerrit.core.client.data.GerritQueryResult;
import org.eclipse.mylyn.reviews.core.model.IReview;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

public class GerritTaskDataHandlerTest {
    @Test
    public void testCreatePartialTaskData() {
        GerritTaskDataHandler handler = new GerritTaskDataHandler(new GerritConnector());
        TaskRepository repository = new TaskRepository("org.eclipse.mylyn.gerrit", "http://repository");
        TaskData data = handler.createPartialTaskData(repository, "1", null);
        Assert.assertNull((Object)data.getRoot().getAttribute(GerritTaskSchema.getDefault().UPLOADED.getKey()));
        Assert.assertTrue((boolean)data.isPartial());
    }

    @Test
    public void testCreateTaskData() {
        GerritTaskDataHandler handler = new GerritTaskDataHandler(new GerritConnector());
        TaskRepository repository = new TaskRepository("org.eclipse.mylyn.gerrit", "http://repository");
        TaskData data = handler.createTaskData(repository, "1", null);
        TaskData data2 = handler.createTaskData(repository, "2", null);
        Assert.assertEquals((Object)GerritTaskSchema.getDefault().UPLOADED.createAttribute(data2.getRoot()), (Object)data.getRoot().getAttribute(GerritTaskSchema.getDefault().UPLOADED.getKey()));
    }

    @Test
    public void testUpdatePartialTaskData() {
        GerritConnector connector = (GerritConnector)Mockito.mock(GerritConnector.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        GerritConfiguration config = this.createMockConfig();
        Mockito.when((Object)connector.getConfiguration((TaskRepository)ArgumentMatchers.any(TaskRepository.class))).thenReturn((Object)config);
        GerritTaskDataHandler handler = new GerritTaskDataHandler(connector);
        TaskRepository repository = new TaskRepository("org.eclipse.mylyn.gerrit", "http://repository");
        TaskData data = handler.createTaskData(repository, "1", null);
        handler.updatePartialTaskData(repository, data, this.createMockQueryResult("Joel K. User"));
        this.assertAssignee(data, "joel.user@mylyn.org", "Joel K. User");
        handler.updatePartialTaskData(repository, data, this.createMockQueryResult("Jacob F. User"));
        this.assertAssignee(data, "Jacob F. User", "Jacob F. User");
        handler.updatePartialTaskData(repository, data, this.createMockQueryResult(null));
        this.assertAssignee(data, "Anonymous", "Anonymous");
    }

    @Test
    public void testUpdateTaskData() {
        GerritTaskDataHandler handler = new GerritTaskDataHandler(new GerritConnector());
        TaskRepository repository = new TaskRepository("org.eclipse.mylyn.gerrit", "http://repository");
        TaskData data = handler.createTaskData(repository, "1", null);
        handler.updateTaskData(repository, data, this.createMockGerritChange(), this.createMockReview(), false, null);
        this.assertAssignee(data, "joel.user@mylyn.org", "Joel K. User");
        Assert.assertNotNull((Object)data.getRoot().getAttribute("FILE-COMMENTS"));
    }

    private void assertAssignee(TaskData data, String id, String name) {
        TaskAttribute assigneeAttribute = data.getRoot().getAttribute("task.common.user.assigned");
        Assert.assertEquals((Object)id, (Object)assigneeAttribute.getValue());
        Assert.assertEquals((Object)name, (Object)data.getAttributeMapper().getValueLabel(assigneeAttribute));
    }

    private GerritConfiguration createMockConfig() {
        Account account = new Account(new Account.Id(1));
        account.setFullName("Joel K. User");
        account.setPreferredEmail("joel.user@mylyn.org");
        GerritConfiguration value = new GerritConfiguration(new GerritConfigX(), Collections.emptyList(), account);
        return value;
    }

    private GerritQueryResult createMockQueryResult(String userName) {
        GerritQueryResult queryResult = (GerritQueryResult)Mockito.mock(GerritQueryResult.class, (Answer)Mockito.RETURNS_SMART_NULLS);
        Mockito.when((Object)queryResult.getReviewLabel()).thenReturn(null);
        Mockito.when((Object)queryResult.getUpdated()).thenReturn((Object)new Timestamp(1L));
        if (userName == null) {
            Mockito.when((Object)queryResult.getOwner()).thenReturn(null);
        } else {
            GerritPerson person = (GerritPerson)Mockito.mock(GerritPerson.class);
            Mockito.when((Object)person.getName()).thenReturn((Object)userName);
            Mockito.when((Object)queryResult.getOwner()).thenReturn((Object)person);
        }
        return queryResult;
    }

    private GerritChange createMockGerritChange() {
        AccountInfo accountInfo = (AccountInfo)Mockito.mock(AccountInfo.class);
        Mockito.when((Object)accountInfo.getFullName()).thenReturn((Object)"Joel K. User");
        Mockito.when((Object)accountInfo.getPreferredEmail()).thenReturn((Object)"joel.user@mylyn.org");
        GerritChange change = (GerritChange)Mockito.mock(GerritChange.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)change.getChangeDetail().getAccounts().get((Account.Id)ArgumentMatchers.any(Account.Id.class))).thenReturn((Object)accountInfo);
        Mockito.when((Object)change.getChangeDetail().getChange()).thenReturn((Object)this.mockChange());
        return change;
    }

    private IReview createMockReview() {
        IReview review = (IReview)Mockito.mock(IReview.class);
        ((IReview)Mockito.doReturn((Object)ImmutableList.of()).when((Object)review)).getSets();
        return review;
    }

    private Change mockChange() {
        return new Change(new Change.Key("1"), new Change.Id(1), new Account.Id(1), new Branch.NameKey(new Project.NameKey("parent"), "branch"));
    }
}

