/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gerrit.core;

import com.google.gerrit.reviewdb.Project;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.eclipse.mylyn.internal.gerrit.core.GerritConnector;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritClient;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritConfiguration;
import org.eclipse.mylyn.internal.gerrit.core.client.compat.GerritConfigX;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMapper;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class GerritConnectorTest {
    private final GerritConnector connector = new GerritConnector();

    @Test
    public void testCanCreateNewTask() {
        Assert.assertFalse((boolean)this.connector.canCreateNewTask(null));
    }

    @Test
    public void testGetConnectorKind() {
        Assert.assertEquals((Object)"org.eclipse.mylyn.gerrit", (Object)this.connector.getConnectorKind());
    }

    @Test
    public void testGetRepositoryUrlFromTaskUrlInvalid() {
        Assert.assertNull((Object)this.connector.getRepositoryUrlFromTaskUrl(null));
        Assert.assertNull((Object)this.connector.getRepositoryUrlFromTaskUrl(""));
        Assert.assertNull((Object)this.connector.getRepositoryUrlFromTaskUrl("invalid repository url"));
        Assert.assertNull((Object)this.connector.getRepositoryUrlFromTaskUrl("http://invalid.repository.url"));
    }

    @Test
    public void testGetRepositoryUrlFromTaskUrlOld() {
        Assert.assertEquals((Object)"http://review.source.android.com", (Object)this.connector.getRepositoryUrlFromTaskUrl("http://review.source.android.com/#change,13492"));
    }

    @Test
    public void testGetRepositoryUrlFromTaskUrlNew() {
        Assert.assertEquals((Object)"http://review.source.android.com", (Object)this.connector.getRepositoryUrlFromTaskUrl("http://review.source.android.com/#/c/13492"));
        Assert.assertEquals((Object)"http://review.source.android.com", (Object)this.connector.getRepositoryUrlFromTaskUrl("http://review.source.android.com/#/c/13492/"));
        Assert.assertEquals((Object)"http://review.source.android.com", (Object)this.connector.getRepositoryUrlFromTaskUrl("http://review.source.android.com/#/c/13492/1"));
        Assert.assertEquals((Object)"http://review.source.android.com", (Object)this.connector.getRepositoryUrlFromTaskUrl("http://review.source.android.com/#/c/13492/1/2"));
    }

    @Test
    public void testGetTaskIdFromTaskUrlOld() {
        Assert.assertEquals((Object)"13492", (Object)this.connector.getTaskIdFromTaskUrl("http://review.source.android.com/#change,13492"));
    }

    @Test
    public void testGetTaskIdFromTaskUrlInvalid() {
        Assert.assertNull((Object)this.connector.getTaskIdFromTaskUrl(null));
        Assert.assertNull((Object)this.connector.getTaskIdFromTaskUrl(""));
        Assert.assertNull((Object)this.connector.getTaskIdFromTaskUrl("invalid repository url"));
        Assert.assertNull((Object)this.connector.getTaskIdFromTaskUrl("http://invalid.repository.url"));
    }

    public void testGetTaskIdFromTaskUrlNew() {
        Assert.assertEquals((Object)"13492", (Object)this.connector.getTaskIdFromTaskUrl("http://review.source.android.com/#/c/13492"));
        Assert.assertEquals((Object)"13492", (Object)this.connector.getTaskIdFromTaskUrl("http://review.source.android.com/#/c/13492/"));
        Assert.assertEquals((Object)"13492", (Object)this.connector.getTaskIdFromTaskUrl("http://review.source.android.com/#/c/13492/1"));
        Assert.assertEquals((Object)"13492", (Object)this.connector.getTaskIdFromTaskUrl("http://review.source.android.com/#/c/13492/1/2"));
    }

    @Test
    public void testGetTaskUrl() {
        Assert.assertEquals((Object)"http://review.source.android.com/#/c/13492/", (Object)this.connector.getTaskUrl("http://review.source.android.com", "13492"));
    }

    @Test
    public void testGetTaskUrlTrailingSlash() {
        Assert.assertEquals((Object)"http://review.mylyn.org/#/c/4698/", (Object)this.connector.getTaskUrl("http://review.mylyn.org/", "4698"));
    }

    @Test
    public void createReviewClient() {
        TaskRepository repository = new TaskRepository("org.eclipse.mylyn.gerrit", "http://repository");
        GerritClient client = this.connector.createReviewClient(repository, true);
        Assert.assertNull((Object)client.getConfiguration());
        Assert.assertNull((Object)client.getGerritConfig());
    }

    @Test
    public void createReviewClientWithConfiguration() {
        Project project = new Project(new Project.NameKey("name"));
        TaskRepository repository = new TaskRepository("org.eclipse.mylyn.gerrit", "http://repository");
        GerritConfiguration configuration = new GerritConfiguration(new GerritConfigX(), Collections.singletonList(project), null);
        this.connector.saveConfiguration(repository, configuration);
        GerritClient client = this.connector.createReviewClient(repository, true);
        List projects = client.getConfiguration().getProjects();
        Assert.assertNotNull((Object)projects);
        Assert.assertEquals((long)1L, (long)projects.size());
        Assert.assertEquals((Object)project.getNameKey(), (Object)((Project)projects.get(0)).getNameKey());
        Assert.assertNotNull((Object)client.getGerritConfig());
    }

    @Test
    public void createTransientReviewClient() {
        TaskRepository repository = new TaskRepository("org.eclipse.mylyn.gerrit", "http://repository");
        GerritClient client = this.connector.createTransientReviewClient(repository);
        Assert.assertNull((Object)client.getConfiguration());
        Assert.assertNull((Object)client.getGerritConfig());
    }

    @Test
    public void testHasTaskChangedSameDate() {
        Assert.assertFalse((boolean)this.hasTaskChanged(123456000, 123456000));
    }

    @Test
    public void testHasTaskChangedSameDateWithMillis() {
        Assert.assertFalse((boolean)this.hasTaskChanged(123456123, 123456123));
    }

    @Test
    public void testHasTaskChangedMillisMissingFromLocal() {
        Assert.assertFalse((boolean)this.hasTaskChanged(123456000, 123456123));
    }

    @Test
    public void testHasTaskChangedMillisMissingFromLocalRoundedUp() {
        Assert.assertFalse((boolean)this.hasTaskChanged(123456000, 123455911));
    }

    @Test
    public void testHasTaskChangedMillisMissingFromLocalDatesDifferByMoreThanOneSecond() {
        Assert.assertTrue((boolean)this.hasTaskChanged(123456000, 123454123));
        Assert.assertTrue((boolean)this.hasTaskChanged(123456000, 123457123));
    }

    @Test
    public void testHasTaskChangedMillisMissingFromRepository() {
        Assert.assertTrue((boolean)this.hasTaskChanged(123456123, 123456000));
    }

    @Test
    public void testHasTaskChangedMillisDiffer() {
        Assert.assertTrue((boolean)this.hasTaskChanged(123456123, 123456122));
        Assert.assertTrue((boolean)this.hasTaskChanged(123456123, 123456124));
    }

    @Test
    public void testHasTaskChangedSecondsDiffer() {
        Assert.assertTrue((boolean)this.hasTaskChanged(123456123, 123455123));
        Assert.assertTrue((boolean)this.hasTaskChanged(123456123, 123457123));
    }

    private boolean hasTaskChanged(int localDate, int repositoryDate) {
        ITask task = (ITask)Mockito.mock(ITask.class);
        Mockito.when((Object)task.getModificationDate()).thenReturn((Object)new Date(localDate));
        TaskData taskData = new TaskData(new TaskAttributeMapper(new TaskRepository("org.eclipse.mylyn.gerrit", "http://mock")), "org.eclipse.mylyn.gerrit", "http://mock", "1");
        taskData.getRoot().createMappedAttribute("task.common.date.modified").setValue(String.valueOf(repositoryDate));
        return this.connector.hasTaskChanged(null, task, taskData);
    }
}

