/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.discovery.tests.core.util;

import junit.framework.TestCase;
import org.eclipse.mylyn.internal.discovery.core.util.WebUtil;

public class WebUtilTest
extends TestCase {
    public void testGetFileNameForJar() throws Exception {
        WebUtilTest.assertEquals((String)"org.eclipse.mylyn.discovery_3.10.jar", (String)WebUtil.getFileNameFor((String)"org.eclipse.mylyn.discovery-3.10.jar"));
    }

    public void testGetFileNameForUrl() throws Exception {
        WebUtilTest.assertEquals((String)"org.eclipse.mylyn.discovery_3.10.jar", (String)WebUtil.getFileNameFor((String)"http://www.eclipse.org/downloads/download.php?file=/mylyn/discovery/org.eclipse.mylyn.discovery-3.10.jar"));
    }

    public void testGetFileNameForUrlWithQuery() throws Exception {
        WebUtilTest.assertEquals((String)"org.eclipse.mylyn.discovery_3.10.jar_r_1_protocol_http", (String)WebUtil.getFileNameFor((String)"http://www.eclipse.org/downloads/download.php?file=/mylyn/discovery/org.eclipse.mylyn.discovery-3.10.jar&r=1&protocol=http"));
    }

    public void testGetFileNameForUrlEndingWithSlash() throws Exception {
        WebUtilTest.assertEquals((String)"a.jar", (String)WebUtil.getFileNameFor((String)"a.jar/"));
    }

    public void testGetFileNameForUrlWithFilesystemReservedCharacters() throws Exception {
        WebUtilTest.assertEquals((String)"1_2_3_4_5_6_7_8_9_", (String)WebUtil.getFileNameFor((String)"1<2>3:4\"5\\6|7?8*9+"));
    }
}

