/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.discovery.tests.core.mock;

import org.eclipse.mylyn.discovery.tests.core.mock.AbstractMockFactory;
import org.eclipse.mylyn.internal.discovery.core.model.AbstractDiscoverySource;
import org.eclipse.mylyn.internal.discovery.core.model.ConnectorDescriptor;
import org.eclipse.mylyn.internal.discovery.core.model.ConnectorDescriptorKind;
import org.eclipse.mylyn.internal.discovery.core.model.DiscoveryConnector;
import org.eclipse.mylyn.internal.discovery.core.model.FeatureFilter;
import org.eclipse.mylyn.internal.discovery.core.model.Icon;
import org.eclipse.mylyn.internal.discovery.core.model.Overview;

public class DiscoveryConnectorMockFactory
extends AbstractMockFactory<DiscoveryConnector> {
    @Override
    protected void populateMockData() {
        ((DiscoveryConnector)this.getMockObject()).setSource((AbstractDiscoverySource)this.source);
        this.name("Connector " + this.seed).id(String.valueOf(DiscoveryConnectorMockFactory.class.getPackage().getName()) + ".connector" + this.seed).siteUrl("http://example.nodomain/some/path/updateSite3.x/").kind(ConnectorDescriptorKind.TASK).license(this.seed % 2 == 0 ? "EPL 1.0" : "APL 2.0").description("a connector for the Example Task System versions 1.0 - 5.3").categoryId("example").provider("Testing 123 Inc.");
        Icon icon = new Icon();
        icon.setImage128("images/ico128.png");
        icon.setImage16("images/ico16.png");
        icon.setImage32("images/ico32.png");
        icon.setImage64("images/ico64.png");
        Overview overview = new Overview();
        overview.setScreenshot("images/screenshot-main.png");
        overview.setSummary("some long text that summarizes the connector");
        overview.setUrl("http://example.nodomain/some/path/updateSite3.x/overview.html");
        this.icon(icon).overview(overview);
        overview.setConnectorDescriptor((ConnectorDescriptor)this.getMockObject());
    }

    @Override
    protected DiscoveryConnector createMockObject() {
        return new DiscoveryConnector();
    }

    public DiscoveryConnectorMockFactory categoryId(String categoryId) {
        ((DiscoveryConnector)this.getMockObject()).setCategoryId(categoryId);
        return this;
    }

    public DiscoveryConnectorMockFactory description(String description) {
        ((DiscoveryConnector)this.getMockObject()).setDescription(description);
        return this;
    }

    public DiscoveryConnectorMockFactory icon(Icon icon) {
        ((DiscoveryConnector)this.getMockObject()).setIcon(icon);
        return this;
    }

    public DiscoveryConnectorMockFactory id(String id) {
        ((DiscoveryConnector)this.getMockObject()).setId(id);
        return this;
    }

    public DiscoveryConnectorMockFactory kind(ConnectorDescriptorKind kind) {
        ((DiscoveryConnector)this.getMockObject()).getKind().add(kind);
        return this;
    }

    public DiscoveryConnectorMockFactory license(String license) {
        ((DiscoveryConnector)this.getMockObject()).setLicense(license);
        return this;
    }

    public DiscoveryConnectorMockFactory name(String name) {
        ((DiscoveryConnector)this.getMockObject()).setName(name);
        return this;
    }

    public DiscoveryConnectorMockFactory overview(Overview overview) {
        ((DiscoveryConnector)this.getMockObject()).setOverview(overview);
        return this;
    }

    public DiscoveryConnectorMockFactory platformFilter(String platformFilter) {
        ((DiscoveryConnector)this.getMockObject()).setPlatformFilter(platformFilter);
        return this;
    }

    public DiscoveryConnectorMockFactory provider(String provider) {
        ((DiscoveryConnector)this.getMockObject()).setProvider(provider);
        return this;
    }

    public DiscoveryConnectorMockFactory siteUrl(String siteUrl) {
        ((DiscoveryConnector)this.getMockObject()).setSiteUrl(siteUrl);
        return this;
    }

    public DiscoveryConnectorMockFactory featureFilter(String featureId, String versionRange) {
        FeatureFilter featureFilter = new FeatureFilter();
        featureFilter.setConnectorDescriptor((ConnectorDescriptor)this.getMockObject());
        featureFilter.setFeatureId(featureId);
        featureFilter.setVersion(versionRange);
        ((DiscoveryConnector)this.getMockObject()).getFeatureFilter().add(featureFilter);
        return this;
    }
}

