/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.discovery.tests.core;

import java.util.Dictionary;
import java.util.HashMap;
import java.util.Properties;
import junit.framework.TestCase;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.mylyn.discovery.tests.core.mock.DiscoveryConnectorMockFactory;
import org.eclipse.mylyn.discovery.tests.core.mock.MockDiscoveryStrategy;
import org.eclipse.mylyn.internal.discovery.core.model.ConnectorDiscovery;
import org.eclipse.mylyn.internal.discovery.core.model.DiscoveryConnector;
import org.osgi.framework.Version;

public class ConnectorDiscoveryTest
extends TestCase {
    private ConnectorDiscovery connectorDiscovery;
    private MockDiscoveryStrategy mockDiscoveryStrategy;

    protected void setUp() throws Exception {
        super.setUp();
        this.connectorDiscovery = new ConnectorDiscovery();
        this.mockDiscoveryStrategy = new MockDiscoveryStrategy();
        this.connectorDiscovery.getDiscoveryStrategies().add(this.mockDiscoveryStrategy);
    }

    public void testPlatformFilter_None() throws CoreException {
        this.connectorDiscovery.performDiscovery((IProgressMonitor)new NullProgressMonitor());
        ConnectorDiscoveryTest.assertEquals((int)this.mockDiscoveryStrategy.getConnectorCount(), (int)this.connectorDiscovery.getConnectors().size());
    }

    public void testPlatformFilter_NegativeMatch() throws CoreException {
        this.mockDiscoveryStrategy.setConnectorMockFactory(new DiscoveryConnectorMockFactory(){

            @Override
            protected void populateMockData() {
                super.populateMockData();
                this.platformFilter("(& (osgi.os=macosx) (osgi.ws=carbon))");
            }
        });
        Properties environment = new Properties();
        environment.put("osgi.os", "win32");
        environment.put("osgi.ws", "windows");
        this.connectorDiscovery.setEnvironment((Dictionary)environment);
        this.connectorDiscovery.performDiscovery((IProgressMonitor)new NullProgressMonitor());
        ConnectorDiscoveryTest.assertTrue((boolean)this.connectorDiscovery.getConnectors().isEmpty());
    }

    public void testPlatformFilter_PositiveMatch() throws CoreException {
        this.mockDiscoveryStrategy.setConnectorMockFactory(new DiscoveryConnectorMockFactory(){

            @Override
            protected void populateMockData() {
                super.populateMockData();
                this.platformFilter("(& (osgi.os=macosx) (osgi.ws=carbon))");
            }
        });
        Properties environment = new Properties();
        ((Dictionary)environment).put("osgi.os", "macosx");
        ((Dictionary)environment).put("osgi.ws", "carbon");
        this.connectorDiscovery.setEnvironment((Dictionary)environment);
        this.connectorDiscovery.performDiscovery((IProgressMonitor)new NullProgressMonitor());
        ConnectorDiscoveryTest.assertFalse((boolean)this.connectorDiscovery.getConnectors().isEmpty());
        ConnectorDiscoveryTest.assertEquals((int)this.mockDiscoveryStrategy.getConnectorCount(), (int)this.connectorDiscovery.getConnectors().size());
    }

    public void testFeatureFilter_PositiveMatch() throws CoreException {
        this.mockDiscoveryStrategy.setConnectorMockFactory(new DiscoveryConnectorMockFactory(){

            @Override
            protected void populateMockData() {
                super.populateMockData();
                this.featureFilter("com.foo.bar.feature", "[1.0,2.0)");
            }
        });
        HashMap<String, Version> featureToVersion = new HashMap<String, Version>();
        featureToVersion.put("com.foo.bar.feature", new Version("1.1"));
        this.connectorDiscovery.setFeatureToVersion(featureToVersion);
        this.connectorDiscovery.performDiscovery((IProgressMonitor)new NullProgressMonitor());
        ConnectorDiscoveryTest.assertFalse((boolean)this.connectorDiscovery.getConnectors().isEmpty());
        ConnectorDiscoveryTest.assertEquals((int)this.mockDiscoveryStrategy.getConnectorCount(), (int)this.connectorDiscovery.getConnectors().size());
    }

    public void testFeatureFilter_NegativeMatch_VersionMismatch() throws CoreException {
        this.mockDiscoveryStrategy.setConnectorMockFactory(new DiscoveryConnectorMockFactory(){

            @Override
            protected void populateMockData() {
                super.populateMockData();
                this.featureFilter("com.foo.bar.feature", "[1.2,2.0)");
            }
        });
        HashMap<String, Version> featureToVersion = new HashMap<String, Version>();
        featureToVersion.put("com.foo.bar.feature", new Version("1.1"));
        this.connectorDiscovery.setFeatureToVersion(featureToVersion);
        this.connectorDiscovery.performDiscovery((IProgressMonitor)new NullProgressMonitor());
        ConnectorDiscoveryTest.assertTrue((boolean)this.connectorDiscovery.getConnectors().isEmpty());
    }

    public void testFeatureFilter_NegativeMatch_NotPresent() throws CoreException {
        this.mockDiscoveryStrategy.setConnectorMockFactory(new DiscoveryConnectorMockFactory(){

            @Override
            protected void populateMockData() {
                super.populateMockData();
                this.featureFilter("com.foo.bar.feature", "[1.2,2.0)");
            }
        });
        HashMap featureToVersion = new HashMap();
        this.connectorDiscovery.setFeatureToVersion(featureToVersion);
        this.connectorDiscovery.performDiscovery((IProgressMonitor)new NullProgressMonitor());
        ConnectorDiscoveryTest.assertTrue((boolean)this.connectorDiscovery.getConnectors().isEmpty());
    }

    public void testCategorization() throws CoreException {
        this.connectorDiscovery.performDiscovery((IProgressMonitor)new NullProgressMonitor());
        ConnectorDiscoveryTest.assertTrue((!this.connectorDiscovery.getConnectors().isEmpty() ? 1 : 0) != 0);
        ConnectorDiscoveryTest.assertTrue((!this.connectorDiscovery.getCategories().isEmpty() ? 1 : 0) != 0);
        for (DiscoveryConnector connector : this.connectorDiscovery.getConnectors()) {
            ConnectorDiscoveryTest.assertNotNull((Object)connector.getCategory());
            ConnectorDiscoveryTest.assertEquals((String)connector.getCategoryId(), (String)connector.getCategory().getId());
            ConnectorDiscoveryTest.assertTrue((boolean)connector.getCategory().getConnectors().contains(connector));
        }
    }

    public void testMultipleStrategies() throws CoreException {
        MockDiscoveryStrategy strategy = new MockDiscoveryStrategy();
        strategy.setConnectorMockFactory(this.mockDiscoveryStrategy.getConnectorMockFactory());
        strategy.setCategoryMockFactory(this.mockDiscoveryStrategy.getCategoryMockFactory());
        this.connectorDiscovery.getDiscoveryStrategies().add(strategy);
        this.connectorDiscovery.performDiscovery((IProgressMonitor)new NullProgressMonitor());
        ConnectorDiscoveryTest.assertEquals((int)this.mockDiscoveryStrategy.getConnectorMockFactory().getCreatedCount(), (int)this.connectorDiscovery.getConnectors().size());
        ConnectorDiscoveryTest.assertEquals((int)this.mockDiscoveryStrategy.getCategoryMockFactory().getCreatedCount(), (int)this.connectorDiscovery.getCategories().size());
    }
}

