/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.discovery.tests.core;

import java.io.PrintStream;
import junit.framework.TestCase;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.mylyn.commons.sdk.util.CommonTestUtil;
import org.eclipse.mylyn.internal.discovery.core.DiscoveryCore;
import org.eclipse.mylyn.internal.discovery.core.model.ConnectorDiscovery;
import org.eclipse.mylyn.internal.discovery.core.model.DiscoveryConnector;
import org.eclipse.mylyn.internal.discovery.core.model.RemoteBundleDiscoveryStrategy;

public class ConnectorDiscoveryRemoteTest
extends TestCase {
    private ConnectorDiscovery connectorDiscovery;

    protected void setUp() throws Exception {
        if (CommonTestUtil.fixProxyConfiguration()) {
            CommonTestUtil.dumpSystemInfo((PrintStream)System.err);
        }
        this.connectorDiscovery = new ConnectorDiscovery();
        this.connectorDiscovery.setVerifyUpdateSiteAvailability(false);
        this.connectorDiscovery.getDiscoveryStrategies().clear();
        RemoteBundleDiscoveryStrategy remoteStrategy = new RemoteBundleDiscoveryStrategy();
        remoteStrategy.setDirectoryUrl(DiscoveryCore.getDiscoveryUrl());
        this.connectorDiscovery.getDiscoveryStrategies().add(remoteStrategy);
    }

    public void testRemoteDirectory() throws CoreException {
        this.connectorDiscovery.performDiscovery((IProgressMonitor)new NullProgressMonitor());
        ConnectorDiscoveryRemoteTest.assertFalse((boolean)this.connectorDiscovery.getCategories().isEmpty());
        ConnectorDiscoveryRemoteTest.assertFalse((boolean)this.connectorDiscovery.getConnectors().isEmpty());
    }

    public void testVerifyAvailability() throws Exception {
        this.connectorDiscovery.performDiscovery((IProgressMonitor)new NullProgressMonitor());
        for (DiscoveryConnector connector : this.connectorDiscovery.getConnectors()) {
            ConnectorDiscoveryRemoteTest.assertNull((Object)connector.getAvailable());
        }
        this.connectorDiscovery.verifySiteAvailability((IProgressMonitor)new NullProgressMonitor());
        ConnectorDiscoveryRemoteTest.assertFalse((boolean)this.connectorDiscovery.getConnectors().isEmpty());
        int unavailableCount = 0;
        for (DiscoveryConnector connector : this.connectorDiscovery.getConnectors()) {
            if (connector.getAvailable() == null) {
                ConnectorDiscoveryRemoteTest.assertNotNull((String)("Failed to verify availability for " + connector.getId()), connector.getAttributes().get(DiscoveryConnector.ATTRIBUTE_INSTALL_MESSAGE));
                continue;
            }
            if (connector.getAvailable().booleanValue()) continue;
            ++unavailableCount;
        }
        if (unavailableCount > 0) {
            ConnectorDiscoveryRemoteTest.fail((String)String.format("%s unavailable: %s", unavailableCount, this.computeUnavailableConnetorDescriptorNames()));
        }
    }

    private String computeUnavailableConnetorDescriptorNames() {
        String message = "";
        for (DiscoveryConnector connector : this.connectorDiscovery.getConnectors()) {
            if (connector.getAvailable() == null || connector.getAvailable().booleanValue()) continue;
            if (message.length() > 0) {
                message = String.valueOf(message) + ", ";
            }
            message = String.valueOf(message) + connector.getName();
        }
        return message;
    }
}

