/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.debug.ui;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jdt.internal.debug.core.breakpoints.JavaLineBreakpoint;
import org.eclipse.mylyn.commons.sdk.util.CommonTestUtil;
import org.eclipse.mylyn.context.sdk.java.WorkspaceSetupHelper;
import org.eclipse.mylyn.internal.debug.ui.DebugUiPlugin;

public class BreakpointsTestUtil {
    public static IBreakpoint createTestBreakpoint() throws DebugException {
        IResource testClass = ResourcesPlugin.getWorkspace().getRoot().findMember("/test/src/test.java");
        return new JavaLineBreakpoint(testClass, "test", 2, 1, 5, 0, true, new HashMap());
    }

    public static List<IBreakpoint> createTestBreakpoints() throws DebugException {
        ArrayList<IBreakpoint> breakpoints = new ArrayList<IBreakpoint>();
        breakpoints.add(BreakpointsTestUtil.createTestBreakpoint());
        return breakpoints;
    }

    public static IProject createProject() throws Exception {
        IProject project = WorkspaceSetupHelper.createProject((String)"test");
        ZipFile zip = new ZipFile(new File("testdata/projects/project.zip"));
        CommonTestUtil.unzip((ZipFile)zip, (File)project.getLocation().toFile());
        project.refreshLocal(2, null);
        return project;
    }

    public static void setManageBreakpointsPreference(boolean enabled) {
        DebugUiPlugin.getDefault().getPreferenceStore().setValue("org.eclipse.mylyn.context.breakpoints.auto.manage", enabled);
    }
}

