/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.debug.ui;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jdt.internal.debug.core.breakpoints.JavaLineBreakpoint;
import org.eclipse.mylyn.commons.sdk.util.CommonTestUtil;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.context.core.IInteractionContext;
import org.eclipse.mylyn.context.core.IInteractionContextManager;
import org.eclipse.mylyn.context.sdk.java.WorkspaceSetupHelper;
import org.eclipse.mylyn.internal.context.core.ContextCorePlugin;
import org.eclipse.mylyn.internal.debug.ui.BreakpointsContextUtil;
import org.eclipse.mylyn.internal.debug.ui.BreakpointsTestUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BreakpointsContextUtilTest {
    private final String contextFileName = "contextWithBreakpoints.xml.zip";
    private final File contextFile = new File("testdata/contextWithBreakpoints.xml.zip");
    private File tempContextFile;
    private final IInteractionContextManager contextManager = ContextCore.getContextManager();
    private IBreakpointManager breakpointManager;

    @Before
    public void setUp() throws IOException, CoreException {
        BreakpointsTestUtil.setManageBreakpointsPreference(true);
        this.breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
        File contextStore = ContextCorePlugin.getContextStore().getContextDirectory();
        this.tempContextFile = new File(contextStore, "contextWithBreakpoints.xml.zip");
        FileUtils.copyFile((File)this.contextFile, (File)this.tempContextFile);
        Assert.assertTrue((boolean)this.contextFile.exists());
    }

    @After
    public void tearDown() throws Exception {
        if (this.tempContextFile != null && this.tempContextFile.exists()) {
            this.tempContextFile.delete();
        }
        this.contextManager.deactivateContext("contextWithBreakpoints");
        WorkspaceSetupHelper.clearWorkspace();
        this.breakpointManager.removeBreakpoints(this.breakpointManager.getBreakpoints(), true);
    }

    @Test
    public void testImportBreakpointsWithMissingProject() throws Exception {
        this.activateContext();
        IInteractionContext testContext = this.contextManager.getActiveContext();
        List breakpoints = BreakpointsContextUtil.importBreakpoints((IInteractionContext)testContext, null);
        Assert.assertEquals(Collections.emptyList(), (Object)breakpoints);
    }

    @Test
    public void testImportBreakpoints() throws Exception {
        BreakpointsTestUtil.createProject();
        this.activateContext();
        IInteractionContext testContext = this.contextManager.getActiveContext();
        List breakpoints = BreakpointsContextUtil.importBreakpoints((IInteractionContext)testContext, null);
        Assert.assertEquals((long)2L, (long)breakpoints.size());
        Assert.assertTrue((boolean)(breakpoints.get(0) instanceof JavaLineBreakpoint));
        IMarker marker = ((IBreakpoint)breakpoints.get(0)).getMarker();
        Assert.assertEquals((Object)"test.java", (Object)marker.getResource().getName());
        Assert.assertEquals((long)11L, (long)marker.getAttribute("lineNumber", 0));
        Assert.assertTrue((boolean)(breakpoints.get(1) instanceof JavaLineBreakpoint));
        marker = ((IBreakpoint)breakpoints.get(1)).getMarker();
        Assert.assertEquals((Object)"test.java", (Object)marker.getResource().getName());
        Assert.assertEquals((long)10L, (long)marker.getAttribute("lineNumber", 0));
    }

    @Test
    public void testActivateTask() throws Exception {
        BreakpointsTestUtil.createProject();
        Assert.assertEquals((long)0L, (long)this.breakpointManager.getBreakpoints().length);
        this.activateContext();
        Assert.assertEquals((long)2L, (long)this.breakpointManager.getBreakpoints().length);
        this.contextManager.deactivateContext("contextWithBreakpoints");
    }

    @Test
    public void testActivateTaskDisabled() throws Exception {
        BreakpointsTestUtil.setManageBreakpointsPreference(false);
        BreakpointsTestUtil.createProject();
        Assert.assertEquals((long)0L, (long)this.breakpointManager.getBreakpoints().length);
        this.activateContext();
        Assert.assertEquals((long)0L, (long)this.breakpointManager.getBreakpoints().length);
        this.contextManager.deactivateContext("contextWithBreakpoints");
        Assert.assertEquals((long)0L, (long)this.breakpointManager.getBreakpoints().length);
    }

    @Test
    public void testDeactivateTaskDisabled() throws Exception {
        BreakpointsTestUtil.createProject();
        Assert.assertEquals((String)this.getBreakpointsAsString(), (long)0L, (long)this.breakpointManager.getBreakpoints().length);
        this.activateContext();
        try {
            Assert.assertEquals((String)this.getBreakpointsAsString(), (long)2L, (long)this.breakpointManager.getBreakpoints().length);
        }
        catch (AssertionError e) {
            Thread.sleep(100L);
            System.out.println("# Slept once");
            System.out.println(this.getBreakpointsAsString());
            Thread.sleep(1000L);
            System.out.println("# Slept twice");
            System.out.println(this.getBreakpointsAsString());
            throw e;
        }
        BreakpointsTestUtil.setManageBreakpointsPreference(false);
        this.contextManager.deactivateContext("contextWithBreakpoints");
        Assert.assertEquals((String)this.getBreakpointsAsString(), (long)2L, (long)this.breakpointManager.getBreakpoints().length);
    }

    private String getBreakpointsAsString() {
        return Arrays.asList(this.breakpointManager.getBreakpoints()).toString();
    }

    @Test
    public void testExportBreakpoints() throws Exception {
        BreakpointsTestUtil.createProject();
        List<IBreakpoint> breakpoints = BreakpointsTestUtil.createTestBreakpoints();
        InputStream exportedBreakpoints = BreakpointsContextUtil.exportBreakpoints(breakpoints, null);
        List expected = IOUtils.readLines((InputStream)CommonTestUtil.getResource((Object)this, (String)"testdata/breakpointFile.xml"));
        List actual = IOUtils.readLines((InputStream)exportedBreakpoints);
        Collections.sort(expected);
        Collections.sort(actual);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testRemoveBreakpoints() throws Exception {
        BreakpointsTestUtil.createProject();
        IBreakpoint[] breakpoints = this.breakpointManager.getBreakpoints();
        int currentBreakpoints = breakpoints.length;
        IBreakpoint breakpoint = BreakpointsTestUtil.createTestBreakpoint();
        this.breakpointManager.addBreakpoint(breakpoint);
        ArrayList<IBreakpoint> breakpointsToRemove = new ArrayList<IBreakpoint>();
        breakpointsToRemove.add(breakpoint);
        this.breakpointManager.addBreakpoint(breakpoint);
        Assert.assertEquals((long)(currentBreakpoints + 1), (long)this.breakpointManager.getBreakpoints().length);
        BreakpointsContextUtil.removeBreakpoints(breakpointsToRemove);
        Assert.assertEquals((long)currentBreakpoints, (long)this.breakpointManager.getBreakpoints().length);
    }

    private void activateContext() throws OperationCanceledException, InterruptedException {
        this.contextManager.activateContext("contextWithBreakpoints");
        Job.getJobManager().join((Object)"org.eclipse.mylyn.debug.job.family", null);
    }
}

