/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.context.tests.support;

import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Locale;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.mylyn.context.core.IInteractionContext;
import org.eclipse.mylyn.internal.commons.core.XmlStringConverter;
import org.eclipse.mylyn.internal.context.core.AggregateInteractionEvent;
import org.eclipse.mylyn.internal.context.core.IInteractionContextWriter;
import org.eclipse.mylyn.monitor.core.InteractionEvent;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DomContextWriter
implements IInteractionContextWriter {
    private DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
    private Document doc = this.dbf.newDocumentBuilder().newDocument();
    private Element root = null;
    private OutputStream outputStream = null;
    private Result result = null;

    public void writeContextToStream(IInteractionContext context) throws IOException {
        if (this.outputStream == null) {
            IOException ioe = new IOException("OutputStream not set");
            throw ioe;
        }
        this.clearDocument();
        this.root = this.doc.createElement("InteractionHistory");
        this.root.setAttribute("Version", "1");
        this.root.setAttribute("Id", context.getHandleIdentifier());
        for (InteractionEvent ie : context.getInteractionHistory()) {
            this.writeInteractionEvent(ie);
        }
        this.doc.appendChild(this.root);
        this.writeDOMtoStream(this.doc);
    }

    private void writeDOMtoStream(Document document) {
        DOMSource source = new DOMSource(document);
        this.result = new StreamResult(this.outputStream);
        Transformer xformer = null;
        try {
            xformer = TransformerFactory.newInstance().newTransformer();
            xformer.transform(source, this.result);
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
        }
        catch (TransformerFactoryConfigurationError e) {
            e.printStackTrace();
        }
        catch (TransformerException e1) {
            e1.printStackTrace();
        }
    }

    private void writeInteractionEvent(InteractionEvent e) {
        Element node = this.doc.createElement("InteractionEvent");
        String f = "yyyy-MM-dd HH:mm:ss.S z";
        SimpleDateFormat format = new SimpleDateFormat(f, Locale.ENGLISH);
        node.setAttribute("Kind", e.getKind().toString());
        node.setAttribute("StartDate", format.format(e.getDate()));
        node.setAttribute("EndDate", format.format(e.getEndDate()));
        node.setAttribute("OriginId", XmlStringConverter.convertToXmlString((String)e.getOriginId()));
        node.setAttribute("StructureKind", XmlStringConverter.convertToXmlString((String)e.getStructureKind()));
        node.setAttribute("StructureHandle", XmlStringConverter.convertToXmlString((String)e.getStructureHandle()));
        node.setAttribute("Navigation", XmlStringConverter.convertToXmlString((String)e.getNavigation()));
        node.setAttribute("Delta", XmlStringConverter.convertToXmlString((String)e.getDelta()));
        node.setAttribute("Interest", "" + e.getInterestContribution());
        if (e instanceof AggregateInteractionEvent) {
            this.root.setAttribute("NumEvents", "" + ((AggregateInteractionEvent)e).getNumCollapsedEvents());
            this.root.setAttribute("CreationCount", "" + ((AggregateInteractionEvent)e).getEventCountOnCreation());
        }
        this.root.appendChild(node);
    }

    public void writeEventToStream(InteractionEvent e) throws IOException {
        if (this.outputStream == null) {
            IOException ioe = new IOException("OutputStream not set");
            throw ioe;
        }
        this.clearDocument();
        this.root = this.doc.createElement("InteractionEvent");
        String f = "yyyy-MM-dd HH:mm:ss.S z";
        SimpleDateFormat format = new SimpleDateFormat(f, Locale.ENGLISH);
        this.root.setAttribute("Kind", e.getKind().toString());
        this.root.setAttribute("StartDate", format.format(e.getDate()));
        this.root.setAttribute("EndDate", format.format(e.getEndDate()));
        this.root.setAttribute("OriginId", XmlStringConverter.convertToXmlString((String)e.getOriginId()));
        this.root.setAttribute("StructureKind", XmlStringConverter.convertToXmlString((String)e.getStructureKind()));
        this.root.setAttribute("StructureHandle", XmlStringConverter.convertToXmlString((String)e.getStructureHandle()));
        this.root.setAttribute("Navigation", XmlStringConverter.convertToXmlString((String)e.getNavigation()));
        this.root.setAttribute("Delta", XmlStringConverter.convertToXmlString((String)e.getDelta()));
        this.root.setAttribute("Interest", "" + e.getInterestContribution());
        if (e instanceof AggregateInteractionEvent) {
            this.root.setAttribute("NumEvents", "" + ((AggregateInteractionEvent)e).getNumCollapsedEvents());
            this.root.setAttribute("CreationCount", "" + ((AggregateInteractionEvent)e).getEventCountOnCreation());
        }
        this.writeDOMtoStream(this.doc);
    }

    private void clearDocument() {
        try {
            this.doc = this.dbf.newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public void setOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }
}

