/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.context.tests.support;

import java.io.File;
import java.io.IOException;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.commons.sdk.util.CommonTestUtil;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.internal.monitor.ui.MonitorUiPlugin;
import org.eclipse.pde.internal.core.natures.PluginProject;

@Deprecated
public class ContextTestUtil {
    private static boolean contextUiLazyStarted;
    private static final int MAX_RETRY = 10;
    private static final IProgressMonitor NULL_MONITOR;

    static {
        NULL_MONITOR = new NullProgressMonitor();
    }

    public static IJavaProject createJavaPluginProjectFromZip(String projectName, String zipFileName) throws CoreException, ZipException, IOException {
        IProject project = ContextTestUtil.createProject(projectName);
        ZipFile zip = new ZipFile(CommonTestUtil.getFile(ContextTestUtil.class, (String)("testdata/projects/" + zipFileName)));
        CommonTestUtil.unzip((ZipFile)zip, (File)project.getLocation().toFile());
        project.refreshLocal(2, null);
        IJavaProject javaProject = ContextTestUtil.createPluginProject(project);
        return javaProject;
    }

    private static IJavaProject createPluginProject(IProject project) throws CoreException, JavaModelException {
        if (project == null) {
            return null;
        }
        IJavaProject javaProject = JavaCore.create((IProject)project);
        IFolder binFolder = project.getFolder("bin");
        if (!binFolder.exists()) {
            binFolder.create(false, true, null);
        }
        IProjectDescription description = project.getDescription();
        description.setNatureIds(new String[]{"org.eclipse.pde.PluginNature", "org.eclipse.jdt.core.javanature"});
        project.setDescription(description, null);
        IPath outputLocation = binFolder.getFullPath();
        javaProject.setOutputLocation(outputLocation, null);
        PluginProject pluginProject = new PluginProject();
        pluginProject.setProject(project);
        pluginProject.configure();
        return javaProject;
    }

    private static IProject createProject(String projectName) throws CoreException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject(projectName);
        if (!project.exists()) {
            project.create(NULL_MONITOR);
        } else {
            project.refreshLocal(2, null);
        }
        if (!project.isOpen()) {
            project.open(NULL_MONITOR);
        }
        return project;
    }

    public static void delete(final IResource resource) throws CoreException {
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                int i = 0;
                while (i < 10) {
                    try {
                        resource.delete(true, null);
                        i = 10;
                    }
                    catch (CoreException e) {
                        if (i == 9) {
                            StatusHandler.log((IStatus)e.getStatus());
                            throw e;
                        }
                        System.gc();
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    ++i;
                }
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, null);
    }

    public static void deleteProject(String projectName) throws CoreException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject(projectName);
        if (project.exists()) {
            ContextTestUtil.delete((IResource)project);
        }
    }

    public static void triggerContextUiLazyStart() {
        if (contextUiLazyStarted) {
            return;
        }
        contextUiLazyStarted = true;
        MonitorUiPlugin.getDefault();
        ContextCore.getContextManager().activateContext("startup");
        ContextCore.getContextManager().deactivateContext("startup");
    }
}

