/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.context.tests;

import java.lang.reflect.Method;
import java.util.List;
import org.eclipse.mylyn.context.core.AbstractContextStructureBridge;
import org.eclipse.mylyn.context.sdk.util.AbstractContextTest;
import org.eclipse.mylyn.internal.context.core.ContextCorePlugin;

public class ShadowsBridgeTest
extends AbstractContextTest {
    static final String BASE_CONTENT_TYPE = "BASE_CONTENT_TYPE";
    static final String SHADOWS_CONTENT_TYPE = "SHADOWS_CONTENT_TYPE";
    static final String BASE_IDENTIFIER = "BASE_IDENTIFIER";
    static final String SHADOWS_IDENTIFIER = "SHADOWS_IDENTIFIER";
    static final String BASE_LABEL = "BASE_LABEL";
    static final String SHADOWS_LABEL = "SHADOWS_LABEL";
    static final Object BASE_OBJECT = new Object();
    static final Object SHADOWS_OBJECT = new Object();

    public void testShadowsStructureBridge() throws Exception {
        BaseContentStructureBridge baseBridge = new BaseContentStructureBridge();
        ContextCorePlugin context = ContextCorePlugin.getDefault();
        context.addStructureBridge((AbstractContextStructureBridge)baseBridge);
        AbstractContextStructureBridge otherBridge = context.getStructureBridge(BASE_CONTENT_TYPE);
        ShadowsBridgeTest.assertEquals((String)("Should be the same bridges: " + (Object)((Object)baseBridge) + " " + otherBridge), (Object)((Object)baseBridge), (Object)otherBridge);
        otherBridge = context.getStructureBridge(BASE_OBJECT);
        ShadowsBridgeTest.assertEquals((String)("Should be the same bridges: " + (Object)((Object)baseBridge) + " " + otherBridge), (Object)((Object)baseBridge), (Object)otherBridge);
        otherBridge = context.getStructureBridge(SHADOWS_OBJECT);
        ShadowsBridgeTest.assertEquals((String)("Should be the same bridges: " + (Object)((Object)baseBridge) + " " + otherBridge), (Object)((Object)baseBridge), (Object)otherBridge);
        ShadowsContentStructureBridge shadowsBridge = new ShadowsContentStructureBridge();
        context.addStructureBridge((AbstractContextStructureBridge)shadowsBridge);
        Method addShadowsContentMethod = ContextCorePlugin.class.getDeclaredMethod("addShadowsContent", String.class, String.class);
        addShadowsContentMethod.setAccessible(true);
        addShadowsContentMethod.invoke((Object)context, BASE_CONTENT_TYPE, SHADOWS_CONTENT_TYPE);
        otherBridge = context.getStructureBridge(BASE_CONTENT_TYPE);
        ShadowsBridgeTest.assertEquals((String)("Should be the same bridges: " + (Object)((Object)shadowsBridge) + " " + otherBridge), (Object)((Object)shadowsBridge), (Object)otherBridge);
        otherBridge = context.getStructureBridge(SHADOWS_CONTENT_TYPE);
        ShadowsBridgeTest.assertEquals((String)("Should be the same bridges: " + (Object)((Object)shadowsBridge) + " " + otherBridge), (Object)((Object)shadowsBridge), (Object)otherBridge);
        otherBridge = context.getStructureBridge(SHADOWS_OBJECT);
        ShadowsBridgeTest.assertEquals((String)("Should be the same bridges: " + (Object)((Object)shadowsBridge) + " " + otherBridge), (Object)((Object)shadowsBridge), (Object)otherBridge);
        otherBridge = context.getStructureBridge(BASE_OBJECT);
        ShadowsBridgeTest.assertEquals((String)("Should be the same bridges: " + (Object)((Object)baseBridge) + " " + otherBridge), (Object)((Object)baseBridge), (Object)otherBridge);
    }

    class BaseContentStructureBridge
    extends AbstractContextStructureBridge {
        BaseContentStructureBridge() {
        }

        public boolean acceptsObject(Object object) {
            return object == BASE_OBJECT || object == SHADOWS_OBJECT;
        }

        public boolean canBeLandmark(String handle) {
            return false;
        }

        public boolean canFilter(Object element) {
            return false;
        }

        public List<String> getChildHandles(String handle) {
            return null;
        }

        public String getContentType() {
            return ShadowsBridgeTest.BASE_CONTENT_TYPE;
        }

        public String getContentType(String elementHandle) {
            if (elementHandle == ShadowsBridgeTest.BASE_IDENTIFIER) {
                return ShadowsBridgeTest.BASE_CONTENT_TYPE;
            }
            if (elementHandle == ShadowsBridgeTest.SHADOWS_IDENTIFIER) {
                return ShadowsBridgeTest.SHADOWS_IDENTIFIER;
            }
            return null;
        }

        public String getHandleForOffsetInObject(Object resource, int offset) {
            if (resource == BASE_OBJECT) {
                return ShadowsBridgeTest.BASE_IDENTIFIER;
            }
            if (resource == SHADOWS_OBJECT) {
                return ShadowsBridgeTest.SHADOWS_IDENTIFIER;
            }
            return null;
        }

        public String getHandleIdentifier(Object object) {
            if (object == BASE_OBJECT) {
                return ShadowsBridgeTest.BASE_IDENTIFIER;
            }
            if (object == SHADOWS_OBJECT) {
                return ShadowsBridgeTest.SHADOWS_IDENTIFIER;
            }
            return null;
        }

        public String getLabel(Object object) {
            if (object == BASE_OBJECT) {
                return ShadowsBridgeTest.BASE_LABEL;
            }
            if (object == SHADOWS_OBJECT) {
                return ShadowsBridgeTest.SHADOWS_LABEL;
            }
            return null;
        }

        public Object getObjectForHandle(String handle) {
            if (handle == ShadowsBridgeTest.BASE_IDENTIFIER) {
                return BASE_OBJECT;
            }
            if (handle == ShadowsBridgeTest.SHADOWS_IDENTIFIER) {
                return SHADOWS_OBJECT;
            }
            return null;
        }

        public String getParentHandle(String handle) {
            return null;
        }

        public boolean isDocument(String handle) {
            return false;
        }
    }

    class ShadowsContentStructureBridge
    extends AbstractContextStructureBridge {
        ShadowsContentStructureBridge() {
        }

        public boolean acceptsObject(Object object) {
            return object == SHADOWS_OBJECT;
        }

        public boolean canBeLandmark(String handle) {
            return false;
        }

        public boolean canFilter(Object element) {
            return false;
        }

        public List<String> getChildHandles(String handle) {
            return null;
        }

        public String getContentType() {
            return ShadowsBridgeTest.SHADOWS_CONTENT_TYPE;
        }

        public String getContentType(String elementHandle) {
            if (elementHandle == ShadowsBridgeTest.SHADOWS_IDENTIFIER) {
                return ShadowsBridgeTest.SHADOWS_IDENTIFIER;
            }
            return null;
        }

        public String getHandleForOffsetInObject(Object resource, int offset) {
            if (resource == SHADOWS_OBJECT) {
                return ShadowsBridgeTest.SHADOWS_IDENTIFIER;
            }
            return null;
        }

        public String getHandleIdentifier(Object object) {
            if (object == SHADOWS_OBJECT) {
                return ShadowsBridgeTest.SHADOWS_IDENTIFIER;
            }
            return null;
        }

        public String getLabel(Object object) {
            if (object == SHADOWS_OBJECT) {
                return ShadowsBridgeTest.SHADOWS_LABEL;
            }
            return null;
        }

        public Object getObjectForHandle(String handle) {
            if (handle == ShadowsBridgeTest.SHADOWS_IDENTIFIER) {
                return SHADOWS_OBJECT;
            }
            return null;
        }

        public String getParentHandle(String handle) {
            return null;
        }

        public boolean isDocument(String handle) {
            return false;
        }
    }
}

