/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.context.tests;

import org.eclipse.mylyn.context.core.IInteractionContextScaling;
import org.eclipse.mylyn.context.sdk.util.AbstractContextTest;
import org.eclipse.mylyn.internal.context.core.InteractionContext;
import org.eclipse.mylyn.internal.context.core.InteractionContextScaling;
import org.eclipse.mylyn.monitor.core.InteractionEvent;

public class InteractionContextTest
extends AbstractContextTest {
    public void testReset() {
        InteractionEvent event = this.mockSelection("aaaaa");
        InteractionContext context = new InteractionContext("test", (IInteractionContextScaling)new InteractionContextScaling());
        context.parseEvent(event);
        InteractionContextTest.assertEquals((int)1, (int)context.getUserEventCount());
        InteractionContextTest.assertEquals((int)1, (int)context.getInteractionHistory().size());
        context.reset();
        InteractionContextTest.assertEquals((int)0, (int)context.getUserEventCount());
        InteractionContextTest.assertEquals((int)0, (int)context.getInteractionHistory().size());
    }

    public void testParseEventWithNullHandle() {
        InteractionEvent event = this.mockSelection(null);
        InteractionContext context = new InteractionContext("test", (IInteractionContextScaling)new InteractionContextScaling());
        InteractionContextTest.assertNull((Object)context.parseEvent(event));
    }

    public void testSetScalingFactors() {
        InteractionContextScaling oldScalingFactors = new InteractionContextScaling();
        InteractionContext globalContext = new InteractionContext("global", (IInteractionContextScaling)oldScalingFactors);
        InteractionContextTest.assertEquals((Object)oldScalingFactors, (Object)globalContext.getScaling());
        ((InteractionContextScaling)globalContext.getScaling()).set(InteractionEvent.Kind.EDIT, 10.0f);
        InteractionContextTest.assertEquals((Object)Float.valueOf(10.0f), (Object)Float.valueOf(globalContext.getScaling().get(InteractionEvent.Kind.EDIT)));
    }

    public void testScalingFactorSet() {
        InteractionContextScaling scalingFactors = new InteractionContextScaling();
        scalingFactors.setDecay(0.0f);
        InteractionContext context = new InteractionContext("test", (IInteractionContextScaling)scalingFactors);
        InteractionContextTest.assertEquals((Object)Float.valueOf(0.0f), (Object)Float.valueOf(context.getScaling().getDecay()));
    }

    public void testIsInteresting() {
        InteractionContext context = new InteractionContext("test", (IInteractionContextScaling)new InteractionContextScaling());
        InteractionContextTest.assertFalse((boolean)context.isInteresting("1"));
        context.parseEvent(this.mockSelection("1"));
        InteractionContextTest.assertTrue((boolean)context.isInteresting("1"));
        context.parseEvent(this.mockInterestContribution("1", -10.0f));
        InteractionContextTest.assertFalse((boolean)context.isInteresting("1"));
        InteractionContextTest.assertNotNull((Object)context.get("1"));
    }
}

