/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.context.tests;

import junit.framework.TestCase;
import org.eclipse.mylyn.context.core.AbstractContextListener;
import org.eclipse.mylyn.context.core.ContextChangeEvent;
import org.eclipse.mylyn.context.core.IInteractionContextScaling;
import org.eclipse.mylyn.internal.context.core.CompositeInteractionContext;
import org.eclipse.mylyn.internal.context.core.ContextCorePlugin;
import org.eclipse.mylyn.internal.context.core.InteractionContext;
import org.eclipse.mylyn.internal.context.core.InteractionContextManager;
import org.eclipse.mylyn.internal.context.core.InteractionContextScaling;

public class InteractionContextListeningTest
extends TestCase {
    private final InteractionContext mockContext = new InteractionContext("doitest", (IInteractionContextScaling)new InteractionContextScaling());
    private InteractionContextManager contextManager;

    protected void tearDown() throws Exception {
        super.tearDown();
        this.contextManager.deactivateAllContexts();
    }

    public void testAddRemoveListenerInContextActivated() {
        this.contextManager = ContextCorePlugin.getContextManager();
        ((CompositeInteractionContext)this.contextManager.getActiveContext()).getContextMap().put("handle", this.mockContext);
        final StubContextListener listener = new StubContextListener();
        try {
            this.contextManager.addListener(new AbstractContextListener(){

                public void contextChanged(ContextChangeEvent event) {
                    switch (event.getEventKind()) {
                        case ACTIVATED: {
                            InteractionContextListeningTest.this.contextManager.addListener((AbstractContextListener)listener);
                            InteractionContextListeningTest.this.contextManager.removeListener((AbstractContextListener)listener);
                        }
                    }
                }
            });
            this.contextManager.activateContext("handle");
            this.contextManager.deactivateContext("handle");
            this.contextManager.activateContext("handle");
            InteractionContextListeningTest.assertEquals((int)0, (int)listener.activationEventCount);
        }
        finally {
            this.contextManager.removeListener((AbstractContextListener)listener);
        }
    }

    private class StubContextListener
    extends AbstractContextListener {
        private int activationEventCount;

        private StubContextListener() {
        }

        public void contextChanged(ContextChangeEvent event) {
            switch (event.getEventKind()) {
                case ACTIVATED: {
                    InteractionContextListeningTest.this.contextManager.removeListener((AbstractContextListener)this);
                    ++this.activationEventCount;
                }
            }
        }
    }
}

