/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.context.tests;

import org.eclipse.mylyn.context.core.IInteractionContextScaling;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.mylyn.context.core.IInteractionRelation;
import org.eclipse.mylyn.context.sdk.util.AbstractContextTest;
import org.eclipse.mylyn.internal.context.core.InteractionContext;
import org.eclipse.mylyn.internal.context.core.InteractionContextScaling;

public class ContextTest
extends AbstractContextTest {
    private InteractionContext context;
    private InteractionContextScaling scaling;

    protected void setUp() throws Exception {
        super.setUp();
        this.scaling = new InteractionContextScaling();
        this.context = new InteractionContext("0", (IInteractionContextScaling)this.scaling);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testEquality() {
        InteractionContext context1 = new InteractionContext("1", (IInteractionContextScaling)this.scaling);
        context1.parseEvent(this.mockSelection("1"));
        InteractionContext context2 = new InteractionContext("2", (IInteractionContextScaling)this.scaling);
        context2.parseEvent(this.mockSelection("2"));
        ContextTest.assertFalse((boolean)context1.equals((Object)context2));
    }

    public void testReset() {
        this.context.parseEvent(this.mockSelection());
        this.context.reset();
        ContextTest.assertNull((Object)this.context.getActiveNode());
    }

    public void testManipulation() {
        IInteractionElement node = this.context.parseEvent(this.mockSelection("1"));
        this.context.parseEvent(this.mockSelection("1"));
        this.context.parseEvent(this.mockInterestContribution("1", 40.0f));
        ContextTest.assertEquals((Object)Float.valueOf(42.0f - this.scaling.getDecay() * 1.0f), (Object)Float.valueOf(node.getInterest().getValue()));
        this.context.parseEvent(this.mockInterestContribution("1", -20.0f));
        ContextTest.assertEquals((Object)Float.valueOf(22.0f - this.scaling.getDecay() * 1.0f), (Object)Float.valueOf(node.getInterest().getValue()));
    }

    public void testPropagatedInterest() {
        IInteractionElement node = this.context.parseEvent(this.mockPropagation("1"));
        ContextTest.assertTrue((boolean)node.getInterest().isPropagated());
        this.context.parseEvent(this.mockSelection("1"));
        this.context.parseEvent(this.mockInterestContribution("1", -10.0f));
        ContextTest.assertFalse((boolean)node.getInterest().isPropagated());
    }

    public void testEdges() {
        IInteractionElement node = this.context.parseEvent(this.mockSelection("1"));
        this.context.parseEvent(this.mockNavigation("2"));
        IInteractionRelation edge = node.getRelation("2");
        ContextTest.assertNotNull((Object)edge);
        ContextTest.assertEquals((String)edge.getTarget().getHandleIdentifier(), (String)"2");
    }

    public void testDecay() {
        float decay = this.scaling.getDecay();
        IInteractionElement node1 = this.context.parseEvent(this.mockSelection("1"));
        this.context.parseEvent(this.mockSelection("2"));
        int i = 0;
        while (i < 98) {
            this.context.parseEvent(this.mockSelection("1"));
            ++i;
        }
        ContextTest.assertEquals((Object)Float.valueOf(99.0f - decay * 99.0f), (Object)Float.valueOf(node1.getInterest().getValue()));
    }

    public void testLandmarkScaling() {
        IInteractionElement node1 = this.context.parseEvent(this.mockSelection("1"));
        int i = 0;
        while ((float)i < this.scaling.getLandmark() - 2.0f + this.scaling.getLandmark() * this.scaling.getDecay()) {
            this.context.parseEvent(this.mockSelection("1"));
            ++i;
        }
        ContextTest.assertTrue((boolean)node1.getInterest().isInteresting());
        ContextTest.assertFalse((boolean)node1.getInterest().isLandmark());
        this.context.parseEvent(this.mockSelection("1"));
        this.context.parseEvent(this.mockSelection("1"));
        ContextTest.assertTrue((boolean)node1.getInterest().isLandmark());
    }

    public void testSelections() {
        IInteractionElement missing = this.context.get("0");
        ContextTest.assertNull((Object)missing);
        IInteractionElement node = this.context.parseEvent(this.mockSelection());
        ContextTest.assertTrue((boolean)node.getInterest().isInteresting());
        this.context.parseEvent(this.mockSelection());
        ContextTest.assertTrue((boolean)node.getInterest().isInteresting());
        this.context.parseEvent(this.mockSelection());
        float doi = node.getInterest().getEncodedValue();
        ContextTest.assertEquals((Object)Float.valueOf(3.0f - 2.0f * this.scaling.getDecay()), (Object)Float.valueOf(doi));
    }
}

