/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.context.tasks.tests;

import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Set;
import junit.framework.TestCase;
import org.eclipse.mylyn.commons.sdk.util.CommonTestUtil;
import org.eclipse.mylyn.context.core.IInteractionContextScaling;
import org.eclipse.mylyn.internal.context.core.ContextCorePlugin;
import org.eclipse.mylyn.internal.context.core.InteractionContext;
import org.eclipse.mylyn.internal.context.core.InteractionContextManager;
import org.eclipse.mylyn.internal.context.core.InteractionContextScaling;
import org.eclipse.mylyn.internal.context.core.LegacyActivityAdaptor;
import org.eclipse.mylyn.internal.context.tasks.ui.TaskActivityMonitor;
import org.eclipse.mylyn.internal.monitor.ui.MonitorUiPlugin;
import org.eclipse.mylyn.internal.tasks.core.DateRange;
import org.eclipse.mylyn.internal.tasks.core.ITaskList;
import org.eclipse.mylyn.internal.tasks.core.LocalTask;
import org.eclipse.mylyn.internal.tasks.core.ScheduledTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.TaskActivityManager;
import org.eclipse.mylyn.internal.tasks.core.TaskActivityUtil;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.monitor.core.InteractionEvent;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.tests.util.TestFixture;

public class TaskActivityTimingTest
extends TestCase {
    private TaskActivityManager activityManager;
    private TaskActivityMonitor activityMonitor;
    private ITaskList taskList;

    protected void setUp() throws Exception {
        this.activityManager = (TaskActivityManager)TasksUi.getTaskActivityManager();
        this.taskList = TasksUiInternal.getTaskList();
        TestFixture.resetTaskListAndRepositories();
        TestFixture.saveAndReadTasklist();
        ContextCorePlugin.getContextManager().getActivityMetaContext().reset();
        ContextCorePlugin.getContextManager().saveActivityMetaContext();
        this.activityMonitor = (TaskActivityMonitor)TasksUiPlugin.getTaskActivityMonitor();
        this.activityMonitor.reloadActivityTime();
    }

    protected void tearDown() throws Exception {
        ContextCorePlugin.getContextManager().getActivityMetaContext().reset();
        TestFixture.resetTaskList();
    }

    public void testLoadCorruptContext() throws Exception {
        String contextPath = String.valueOf(TasksUiPlugin.getDefault().getDataDirectory()) + '/' + "contexts" + '/';
        File contexts = new File(contextPath);
        if (!contexts.exists()) {
            contexts.mkdir();
        }
        File backup = new File(contexts, ".activity.xml.zip");
        File good = CommonTestUtil.getFile((Object)((Object)this), (String)"testdata/activityTests/.activity.xml.zip");
        CommonTestUtil.copy((File)good, (File)backup);
        File corrupt = new File(contexts, "activity.xml.zip");
        File corruptSource = CommonTestUtil.getFile((Object)((Object)this), (String)"testdata/activityTests/.activity.xml.zip");
        CommonTestUtil.copy((File)corruptSource, (File)corrupt);
        InteractionContextManager manager = ContextCorePlugin.getContextManager();
        manager.loadActivityMetaContext();
        TaskActivityTimingTest.assertFalse((boolean)manager.getActivityMetaContext().getInteractionHistory().isEmpty());
    }

    public void testConstantWriting() throws Exception {
        String contextPath = String.valueOf(TasksUiPlugin.getDefault().getDataDirectory()) + '/' + "contexts" + '/';
        File contexts = new File(contextPath);
        if (!contexts.exists()) {
            contexts.mkdir();
        }
        File backup = new File(contexts, ".activity.xml.zip");
        File good = CommonTestUtil.getFile((Object)((Object)this), (String)"testdata/activityTests/.activity.xml.zip");
        CommonTestUtil.copy((File)good, (File)backup);
        InteractionContextManager manager = ContextCorePlugin.getContextManager();
        manager.loadActivityMetaContext();
        TaskActivityTimingTest.assertFalse((boolean)manager.getActivityMetaContext().getInteractionHistory().isEmpty());
        int i = 0;
        while (i < 50) {
            manager.saveActivityMetaContext();
            ++i;
        }
        manager.loadActivityMetaContext();
        TaskActivityTimingTest.assertFalse((boolean)manager.getActivityMetaContext().getInteractionHistory().isEmpty());
    }

    public void testActivityWithNoTaskActive() {
        Calendar start = Calendar.getInstance();
        Calendar end = Calendar.getInstance();
        end.setTimeInMillis(start.getTimeInMillis());
        end.add(11, 2);
        Calendar start2 = Calendar.getInstance();
        start2.add(5, 1);
        Calendar end2 = Calendar.getInstance();
        end2.setTime(start2.getTime());
        end2.add(11, 2);
        InteractionEvent event1 = new InteractionEvent(InteractionEvent.Kind.ATTENTION, "workingset", "none", "originId", "navigatedRelation", "added", 2.0f, start.getTime(), end.getTime());
        InteractionEvent event2 = new InteractionEvent(InteractionEvent.Kind.ATTENTION, "workingset", "none", "originId", "navigatedRelation", "added", 2.0f, start2.getTime(), end2.getTime());
        this.activityMonitor.parseInteractionEvent(event1, false);
        this.activityMonitor.parseInteractionEvent(event2, false);
        long expectedTotalTime = end.getTime().getTime() - start.getTime().getTime();
        TaskActivityTimingTest.assertEquals((long)(2L * expectedTotalTime), (long)this.activityManager.getElapsedForWorkingSet("none", start, end2));
    }

    public void testActivityWithNoTaskActive2() {
        Calendar start = Calendar.getInstance();
        Calendar end = Calendar.getInstance();
        end.setTimeInMillis(start.getTimeInMillis());
        end.add(11, 2);
        Calendar start2 = Calendar.getInstance();
        start2.add(5, 1);
        Calendar end2 = Calendar.getInstance();
        end2.setTime(start2.getTime());
        end2.add(11, 2);
        InteractionEvent event1 = new InteractionEvent(InteractionEvent.Kind.ATTENTION, "workingset", "set 1", "originId", "navigatedRelation", "added", 2.0f, start.getTime(), end.getTime());
        InteractionEvent event2 = new InteractionEvent(InteractionEvent.Kind.ATTENTION, "workingset", "set 2", "originId", "navigatedRelation", "added", 2.0f, start2.getTime(), end2.getTime());
        this.activityMonitor.parseInteractionEvent(event1, false);
        this.activityMonitor.parseInteractionEvent(event2, false);
        long expectedTotalTime = end.getTime().getTime() - start.getTime().getTime();
        TaskActivityTimingTest.assertEquals((long)0L, (long)this.activityManager.getElapsedForWorkingSet("bogus", start, end2));
        TaskActivityTimingTest.assertEquals((long)0L, (long)this.activityManager.getElapsedForWorkingSet("none", start, end2));
        TaskActivityTimingTest.assertEquals((long)expectedTotalTime, (long)this.activityManager.getElapsedForWorkingSet("set 1", start, end2));
        TaskActivityTimingTest.assertEquals((long)expectedTotalTime, (long)this.activityManager.getElapsedForWorkingSet("set 2", start, end2));
        TaskActivityTimingTest.assertTrue((boolean)this.activityManager.getWorkingSets().contains("set 1"));
        TaskActivityTimingTest.assertTrue((boolean)this.activityManager.getWorkingSets().contains("set 2"));
    }

    public void testActivityCaptured() {
        LocalTask task1 = new LocalTask("task 1", "Task 1");
        this.taskList.addTask((ITask)task1);
        TaskActivityTimingTest.assertEquals((long)0L, (long)this.activityManager.getElapsedTime((ITask)task1));
        Calendar start = Calendar.getInstance();
        Calendar end = Calendar.getInstance();
        end.setTimeInMillis(start.getTimeInMillis());
        end.add(11, 2);
        Calendar start2 = Calendar.getInstance();
        start2.add(5, 1);
        Calendar end2 = Calendar.getInstance();
        end2.setTime(start2.getTime());
        end2.add(11, 2);
        InteractionEvent event1 = new InteractionEvent(InteractionEvent.Kind.ATTENTION, "structureKind", task1.getHandleIdentifier(), "originId", "navigatedRelation", "added", 2.0f, start.getTime(), end.getTime());
        InteractionEvent event2 = new InteractionEvent(InteractionEvent.Kind.ATTENTION, "structureKind", task1.getHandleIdentifier(), "originId", "navigatedRelation", "added", 2.0f, start2.getTime(), end2.getTime());
        this.activityMonitor.parseInteractionEvent(event1, false);
        this.activityMonitor.parseInteractionEvent(event2, false);
        long expectedTotalTime = end.getTime().getTime() - start.getTime().getTime();
        TaskActivityTimingTest.assertEquals((long)(2L * expectedTotalTime), (long)this.activityManager.getElapsedTime((ITask)task1));
        Calendar startEarly = Calendar.getInstance();
        startEarly.setTimeInMillis(start.getTimeInMillis());
        startEarly.add(2, -1);
        Calendar endLate = Calendar.getInstance();
        endLate.setTimeInMillis(end.getTimeInMillis() + 300000L);
        TaskActivityTimingTest.assertEquals((long)expectedTotalTime, (long)TasksUiPlugin.getTaskActivityManager().getElapsedTime((ITask)task1, startEarly, end));
        TaskActivityTimingTest.assertEquals((long)expectedTotalTime, (long)TasksUiPlugin.getTaskActivityManager().getElapsedTime((ITask)task1, start2, end2));
        TaskActivityTimingTest.assertEquals((long)(2L * expectedTotalTime), (long)TasksUiPlugin.getTaskActivityManager().getElapsedTime((ITask)task1, start, end2));
    }

    public void testActivityDelete() {
        LocalTask task1 = new LocalTask("1", "Task 1");
        this.taskList.addTask((ITask)task1);
        TaskActivityTimingTest.assertEquals((long)0L, (long)this.activityManager.getElapsedTime((ITask)task1));
        Calendar start = Calendar.getInstance();
        Calendar end = Calendar.getInstance();
        end.setTimeInMillis(start.getTimeInMillis());
        end.add(11, 2);
        Calendar start2 = Calendar.getInstance();
        start2.add(5, 1);
        Calendar end2 = Calendar.getInstance();
        end2.setTime(start2.getTime());
        end2.add(11, 2);
        InteractionEvent event1 = new InteractionEvent(InteractionEvent.Kind.ATTENTION, "structureKind", task1.getHandleIdentifier(), "originId", "navigatedRelation", "added", 2.0f, start.getTime(), end.getTime());
        InteractionEvent event2 = new InteractionEvent(InteractionEvent.Kind.ATTENTION, "structureKind", task1.getHandleIdentifier(), "originId", "navigatedRelation", "added", 2.0f, start2.getTime(), end2.getTime());
        ContextCorePlugin.getContextManager().getActivityMetaContext().parseEvent(event1);
        this.activityMonitor.parseInteractionEvent(event1, false);
        ContextCorePlugin.getContextManager().getActivityMetaContext().parseEvent(event2);
        this.activityMonitor.parseInteractionEvent(event2, false);
        long expectedTotalTime = end.getTime().getTime() - start.getTime().getTime();
        TaskActivityTimingTest.assertEquals((long)(2L * expectedTotalTime), (long)this.activityManager.getElapsedTime((ITask)task1));
        Calendar startEarly = Calendar.getInstance();
        startEarly.setTimeInMillis(start.getTimeInMillis());
        startEarly.add(2, -1);
        Calendar endLate = Calendar.getInstance();
        endLate.setTimeInMillis(end.getTimeInMillis() + 300000L);
        TaskActivityTimingTest.assertEquals((long)expectedTotalTime, (long)TasksUiPlugin.getTaskActivityManager().getElapsedTime((ITask)task1, startEarly, end));
        TaskActivityTimingTest.assertEquals((long)expectedTotalTime, (long)TasksUiPlugin.getTaskActivityManager().getElapsedTime((ITask)task1, start2, end2));
        TaskActivityTimingTest.assertEquals((long)(2L * expectedTotalTime), (long)TasksUiPlugin.getTaskActivityManager().getElapsedTime((ITask)task1, start, end2));
        MonitorUiPlugin.getDefault().getActivityContextManager().removeActivityTime(task1.getHandleIdentifier(), start.getTimeInMillis(), end.getTimeInMillis());
        TaskActivityTimingTest.assertEquals((long)expectedTotalTime, (long)this.activityManager.getElapsedTime((ITask)task1));
        ContextCorePlugin.getContextManager().saveActivityMetaContext();
        ContextCorePlugin.getContextManager().loadActivityMetaContext();
        this.activityMonitor.reloadActivityTime();
        TaskActivityTimingTest.assertEquals((long)expectedTotalTime, (long)this.activityManager.getElapsedTime((ITask)task1));
        MonitorUiPlugin.getDefault().getActivityContextManager().removeActivityTime(task1.getHandleIdentifier(), start2.getTimeInMillis(), end2.getTimeInMillis());
        TaskActivityTimingTest.assertEquals((long)0L, (long)this.activityManager.getElapsedTime((ITask)task1));
    }

    public void testNegativeActivity() {
        LocalTask task1 = new LocalTask("task 1", "Task 1");
        this.taskList.addTask((ITask)task1);
        TaskActivityTimingTest.assertEquals((long)0L, (long)this.activityManager.getElapsedTime((ITask)task1));
        Calendar start = Calendar.getInstance();
        Calendar end = Calendar.getInstance();
        end.setTimeInMillis(start.getTimeInMillis());
        end.add(11, 2);
        Calendar start2 = Calendar.getInstance();
        start2.add(5, 1);
        Calendar end2 = Calendar.getInstance();
        end2.setTime(start2.getTime());
        end2.add(11, 2);
        InteractionEvent event1 = new InteractionEvent(InteractionEvent.Kind.ATTENTION, "structureKind", task1.getHandleIdentifier(), "originId", "navigatedRelation", "added", 2.0f, end.getTime(), start.getTime());
        InteractionEvent event2 = new InteractionEvent(InteractionEvent.Kind.ATTENTION, "structureKind", task1.getHandleIdentifier(), "originId", "navigatedRelation", "added", 2.0f, end2.getTime(), start2.getTime());
        this.activityMonitor.parseInteractionEvent(event1, false);
        this.activityMonitor.parseInteractionEvent(event2, false);
        TaskActivityTimingTest.assertEquals((long)0L, (long)TasksUiPlugin.getTaskActivityManager().getElapsedTime((ITask)task1));
        TaskActivityTimingTest.assertEquals((long)0L, (long)TasksUiPlugin.getTaskActivityManager().getElapsedTime((ITask)task1, start, end));
        TaskActivityTimingTest.assertEquals((long)0L, (long)TasksUiPlugin.getTaskActivityManager().getElapsedTime((ITask)task1, start2, end2));
        TaskActivityTimingTest.assertEquals((long)0L, (long)TasksUiPlugin.getTaskActivityManager().getElapsedTime((ITask)task1, start, end2));
    }

    public void testNullTaskHandle() {
        LocalTask task1 = new LocalTask("task 1", "Task 1");
        this.taskList.addTask((ITask)task1);
        TaskActivityTimingTest.assertEquals((long)0L, (long)this.activityManager.getElapsedTime((ITask)task1));
        Calendar start = Calendar.getInstance();
        Calendar end = Calendar.getInstance();
        end.setTimeInMillis(start.getTimeInMillis());
        end.add(11, 2);
        InteractionEvent event1 = new InteractionEvent(InteractionEvent.Kind.ATTENTION, "structureKind", null, "originId", "navigatedRelation", "added", 2.0f, start.getTime(), end.getTime());
        InteractionEvent event2 = new InteractionEvent(InteractionEvent.Kind.ATTENTION, "structureKind", "", "originId", "navigatedRelation", "added", 2.0f, start.getTime(), end.getTime());
        this.activityMonitor.parseInteractionEvent(event1, false);
        this.activityMonitor.parseInteractionEvent(event2, false);
        TaskActivityTimingTest.assertEquals((long)0L, (long)TasksUiPlugin.getTaskActivityManager().getElapsedTime((ITask)task1));
    }

    public void testActivityNotLoggedTwice() {
        InteractionContext metaContext = ContextCorePlugin.getContextManager().getActivityMetaContext();
        metaContext.reset();
        TaskActivityTimingTest.assertEquals((int)0, (int)metaContext.getInteractionHistory().size());
        LocalTask task1 = new LocalTask("local 1", "Task 1");
        LocalTask task2 = new LocalTask("local 2", "Task 2");
        Calendar startTime1 = Calendar.getInstance();
        TaskActivityUtil.snapStartOfHour((Calendar)startTime1);
        Calendar endTime1 = Calendar.getInstance();
        endTime1.setTime(startTime1.getTime());
        endTime1.add(13, 20);
        Calendar startTime2 = Calendar.getInstance();
        startTime2.setTime(endTime1.getTime());
        startTime2.add(13, 20);
        Calendar endTime2 = Calendar.getInstance();
        endTime2.setTime(startTime2.getTime());
        endTime2.add(12, 2);
        InteractionEvent activityEvent1 = this.createTimingEvent(startTime1, endTime1, (ITask)task1);
        InteractionEvent activityEvent2 = this.createTimingEvent(startTime2, endTime2, (ITask)task1);
        InteractionEvent activityEvent3 = this.createTimingEvent(startTime1, startTime1, (ITask)task2);
        metaContext.parseEvent(activityEvent1);
        metaContext.parseEvent(activityEvent2);
        metaContext.parseEvent(activityEvent3);
        metaContext = ContextCorePlugin.getContextManager().collapseActivityMetaContext(metaContext);
        TaskActivityTimingTest.assertEquals((int)1, (int)metaContext.getInteractionHistory().size());
    }

    public void testDoubleBookKeeping() {
        LocalTask task1 = new LocalTask("testDoubleBookKeeping", "testDoubleBookKeeping");
        TasksUiPlugin.getTaskList().addTask((ITask)task1);
        Calendar startActiveTime = Calendar.getInstance();
        Calendar endActiveTime = Calendar.getInstance();
        endActiveTime.setTime(startActiveTime.getTime());
        endActiveTime.add(13, 20);
        Calendar startTime = Calendar.getInstance();
        startTime.setTime(startActiveTime.getTime());
        startTime.add(13, 5);
        Calendar endTime = Calendar.getInstance();
        endTime.setTime(endActiveTime.getTime());
        endTime.add(13, -5);
        InteractionEvent event1 = new InteractionEvent(InteractionEvent.Kind.SELECTION, "structureKind", task1.getHandleIdentifier(), "org.eclipse.ui.workbench", "navigatedRelation", "activated", 2.0f, startActiveTime.getTime(), startActiveTime.getTime());
        InteractionEvent event2 = new InteractionEvent(InteractionEvent.Kind.SELECTION, "structureKind", task1.getHandleIdentifier(), "org.eclipse.ui.workbench", "navigatedRelation", "deactivated", 2.0f, endActiveTime.getTime(), endActiveTime.getTime());
        InteractionEvent activityEvent1 = this.createTimingEvent(startTime, endTime, (ITask)task1);
        ContextCorePlugin.getContextManager().getActivityMetaContext().parseEvent(event1);
        this.activityMonitor.parseInteractionEvent(event1, false);
        ContextCorePlugin.getContextManager().getActivityMetaContext().parseEvent(activityEvent1);
        this.activityMonitor.parseInteractionEvent(activityEvent1, false);
        ContextCorePlugin.getContextManager().getActivityMetaContext().parseEvent(event2);
        this.activityMonitor.parseInteractionEvent(event2, false);
        long elapsed = TasksUiPlugin.getTaskActivityManager().getElapsedTime((ITask)task1);
        TaskActivityTimingTest.assertEquals((long)10000L, (long)elapsed);
        ContextCorePlugin.getContextManager().getActivityMetaContext().parseEvent(event1);
        this.activityMonitor.parseInteractionEvent(event1, false);
        ContextCorePlugin.getContextManager().getActivityMetaContext().parseEvent(event2);
        this.activityMonitor.parseInteractionEvent(event2, false);
        elapsed = TasksUiPlugin.getTaskActivityManager().getElapsedTime((ITask)task1);
        TaskActivityTimingTest.assertEquals((long)10000L, (long)elapsed);
        TaskActivityTimingTest.assertTrue((boolean)TasksUiPlugin.getTaskActivityManager().isActiveThisWeek((ITask)task1));
        TaskActivityTimingTest.assertEquals((long)10000L, (long)TasksUiPlugin.getTaskActivityManager().getElapsedTime((ITask)task1));
        Calendar startActiveTime2 = Calendar.getInstance();
        Calendar endActiveTime2 = this.createCalendar(startActiveTime2, 20);
        Calendar startTime2 = Calendar.getInstance();
        startTime2.setTimeInMillis(startActiveTime2.getTimeInMillis() + 2000L);
        Calendar endTime2 = Calendar.getInstance();
        endTime2.setTimeInMillis(endActiveTime2.getTimeInMillis() - 2000L);
        event1 = new InteractionEvent(InteractionEvent.Kind.SELECTION, "structureKind", task1.getHandleIdentifier(), "org.eclipse.ui.workbench", "navigatedRelation", "activated", 2.0f, startActiveTime2.getTime(), startActiveTime2.getTime());
        event2 = new InteractionEvent(InteractionEvent.Kind.SELECTION, "structureKind", task1.getHandleIdentifier(), "org.eclipse.ui.workbench", "navigatedRelation", "deactivated", 2.0f, endActiveTime2.getTime(), endActiveTime2.getTime());
        activityEvent1 = this.createTimingEvent(startTime2, endTime2, (ITask)task1);
        ContextCorePlugin.getContextManager().getActivityMetaContext().parseEvent(event1);
        this.activityMonitor.parseInteractionEvent(event1, false);
        ContextCorePlugin.getContextManager().getActivityMetaContext().parseEvent(activityEvent1);
        this.activityMonitor.parseInteractionEvent(activityEvent1, false);
        ContextCorePlugin.getContextManager().getActivityMetaContext().parseEvent(event2);
        this.activityMonitor.parseInteractionEvent(event2, false);
        TaskActivityTimingTest.assertEquals((long)26000L, (long)TasksUiPlugin.getTaskActivityManager().getElapsedTime((ITask)task1));
        ContextCorePlugin.getContextManager().saveActivityMetaContext();
        ContextCorePlugin.getContextManager().loadActivityMetaContext();
        this.activityMonitor.reloadActivityTime();
        TaskActivityTimingTest.assertEquals((long)26000L, (long)TasksUiPlugin.getTaskActivityManager().getElapsedTime((ITask)task1));
    }

    public void testAfterReloading() {
        LocalTask task1 = new LocalTask("task 1", "Task 1");
        TasksUiPlugin.getTaskList().addTask((ITask)task1);
        Calendar startTime = Calendar.getInstance();
        Calendar endTime = this.createCalendar(startTime, 20);
        InteractionEvent event1 = new InteractionEvent(InteractionEvent.Kind.SELECTION, "structureKind", task1.getHandleIdentifier(), "originId", "navigatedRelation", "activated", 2.0f, startTime.getTime(), startTime.getTime());
        InteractionEvent event2 = new InteractionEvent(InteractionEvent.Kind.SELECTION, "structureKind", task1.getHandleIdentifier(), "originId", "navigatedRelation", "deactivated", 2.0f, startTime.getTime(), startTime.getTime());
        InteractionEvent activityEvent1 = this.createTimingEvent(startTime, endTime, (ITask)task1);
        ContextCorePlugin.getContextManager().getActivityMetaContext().parseEvent(event1);
        this.activityMonitor.parseInteractionEvent(event1, false);
        ContextCorePlugin.getContextManager().getActivityMetaContext().parseEvent(activityEvent1);
        this.activityMonitor.parseInteractionEvent(activityEvent1, false);
        ContextCorePlugin.getContextManager().getActivityMetaContext().parseEvent(event2);
        this.activityMonitor.parseInteractionEvent(event2, false);
        TaskActivityTimingTest.assertEquals((long)20000L, (long)TasksUiPlugin.getTaskActivityManager().getElapsedTime((ITask)task1));
        ContextCorePlugin.getContextManager().saveActivityMetaContext();
        ContextCorePlugin.getContextManager().loadActivityMetaContext();
        this.activityMonitor.reloadActivityTime();
        TaskActivityTimingTest.assertEquals((long)20000L, (long)TasksUiPlugin.getTaskActivityManager().getElapsedTime((ITask)task1));
    }

    public void testCollapsedTiming() {
        Calendar startTime1 = this.createCalendar();
        Calendar endTime1 = this.createCalendar(startTime1, 20);
        Calendar startTime2 = this.createCalendar(endTime1, 0);
        Calendar endTime2 = this.createCalendar(startTime2, 20);
        Calendar startTime3 = this.createCalendar(endTime2, 0);
        Calendar endTime3 = this.createCalendar(startTime3, 20);
        InteractionContext mockContext = new InteractionContext("doitest", (IInteractionContextScaling)new InteractionContextScaling());
        InteractionEvent activityEvent1 = this.createTimingEvent(startTime1, endTime1, "handle");
        InteractionEvent activityEvent2 = this.createTimingEvent(startTime2, endTime2, "handle");
        InteractionEvent activityEvent3 = this.createTimingEvent(startTime3, endTime3, "handle");
        mockContext.parseEvent(activityEvent1);
        mockContext.parseEvent(activityEvent2);
        mockContext.parseEvent(activityEvent3);
        TaskActivityTimingTest.assertEquals((int)3, (int)mockContext.getInteractionHistory().size());
        mockContext = ContextCorePlugin.getContextManager().collapseActivityMetaContext(mockContext);
        TaskActivityTimingTest.assertEquals((int)1, (int)mockContext.getInteractionHistory().size());
        TaskActivityTimingTest.assertEquals((long)60000L, (long)(((InteractionEvent)mockContext.getInteractionHistory().get(0)).getEndDate().getTime() - ((InteractionEvent)mockContext.getInteractionHistory().get(0)).getDate().getTime()));
    }

    public void testCollapsedTiming2() {
        Calendar startTime1 = this.createCalendar();
        Calendar endTime1 = this.createCalendar(startTime1, 20);
        Calendar startTime2 = this.createCalendar(endTime1, 0);
        Calendar endTime2 = this.createCalendar(startTime2, 20);
        Calendar startTime3 = this.createCalendar(endTime2, 0);
        Calendar endTime3 = this.createCalendar(startTime3, 50);
        InteractionContext mockContext = new InteractionContext("doitest", (IInteractionContextScaling)new InteractionContextScaling());
        InteractionEvent activityEvent1 = this.createTimingEvent(startTime1, endTime1, "handle");
        InteractionEvent activityEvent3 = this.createTimingEvent(startTime3, endTime3, "handle");
        mockContext.parseEvent(activityEvent1);
        mockContext.parseEvent(activityEvent3);
        TaskActivityTimingTest.assertEquals((int)2, (int)mockContext.getInteractionHistory().size());
        mockContext = ContextCorePlugin.getContextManager().collapseActivityMetaContext(mockContext);
        TaskActivityTimingTest.assertEquals((int)1, (int)mockContext.getInteractionHistory().size());
        TaskActivityTimingTest.assertEquals((long)70000L, (long)(((InteractionEvent)mockContext.getInteractionHistory().get(0)).getEndDate().getTime() - ((InteractionEvent)mockContext.getInteractionHistory().get(0)).getDate().getTime()));
    }

    public void testCollapsedExternalization() throws Exception {
        Calendar startTime1 = Calendar.getInstance();
        Calendar endTime1 = Calendar.getInstance();
        endTime1.setTime(startTime1.getTime());
        endTime1.add(13, 20);
        Calendar startTime2 = Calendar.getInstance();
        startTime2.add(5, 1);
        Calendar endTime2 = Calendar.getInstance();
        endTime2.setTime(startTime2.getTime());
        endTime2.add(13, 20);
        LocalTask task1 = new LocalTask("task 1", "Task 1");
        TasksUiPlugin.getTaskList().addTask((ITask)task1);
        InteractionContext metaContext = ContextCorePlugin.getContextManager().getActivityMetaContext();
        metaContext.reset();
        TaskActivityTimingTest.assertEquals((int)0, (int)metaContext.getInteractionHistory().size());
        TasksUiPlugin.getTaskActivityManager().activateTask((ITask)task1);
        InteractionEvent activityEvent1 = this.createTimingEvent(startTime1, endTime1, (ITask)task1);
        InteractionEvent activityEvent2 = this.createTimingEvent(startTime2, endTime2, (ITask)task1);
        metaContext.parseEvent(activityEvent1);
        this.activityMonitor.parseInteractionEvent(activityEvent1, false);
        metaContext.parseEvent(activityEvent2);
        this.activityMonitor.parseInteractionEvent(activityEvent2, false);
        TasksUiPlugin.getTaskActivityManager().deactivateActiveTask();
        TaskActivityTimingTest.assertEquals((int)4, (int)ContextCorePlugin.getContextManager().getActivityMetaContext().getInteractionHistory().size());
        TestFixture.saveNow();
        ContextCorePlugin.getContextManager().saveActivityMetaContext();
        ContextCorePlugin.getContextManager().getActivityMetaContext().reset();
        TaskActivityTimingTest.assertEquals((int)0, (int)ContextCorePlugin.getContextManager().getActivityMetaContext().getInteractionHistory().size());
        ContextCorePlugin.getContextManager().loadActivityMetaContext();
        TaskActivityTimingTest.assertEquals((int)4, (int)ContextCorePlugin.getContextManager().getActivityMetaContext().getInteractionHistory().size());
        this.activityMonitor.reloadActivityTime();
        TaskActivityTimingTest.assertEquals((long)(endTime1.getTimeInMillis() - startTime1.getTimeInMillis() + (endTime2.getTimeInMillis() - startTime2.getTimeInMillis())), (long)TasksUiPlugin.getTaskActivityManager().getElapsedTime((ITask)task1));
    }

    public void testCollapsedTwoTasks() {
        Calendar startTime1 = Calendar.getInstance();
        Calendar endTime1 = this.createCalendar(startTime1, 20);
        Calendar startTime2 = Calendar.getInstance();
        startTime2.setTime(endTime1.getTime());
        startTime2.add(13, 2);
        Calendar endTime2 = this.createCalendar(startTime2, 20);
        InteractionContext mockContext = new InteractionContext("doitest", (IInteractionContextScaling)new InteractionContextScaling());
        InteractionEvent activityEvent1 = this.createTimingEvent(startTime1, endTime1, "handle1");
        InteractionEvent activityEvent2 = this.createTimingEvent(startTime2, endTime2, "handle2");
        mockContext.parseEvent(activityEvent1);
        mockContext.parseEvent(activityEvent2);
        TaskActivityTimingTest.assertEquals((int)2, (int)mockContext.getInteractionHistory().size());
        mockContext = ContextCorePlugin.getContextManager().collapseActivityMetaContext(mockContext);
        TaskActivityTimingTest.assertEquals((int)2, (int)mockContext.getInteractionHistory().size());
    }

    public void testCollapsedByTheHour() {
        Calendar startTime1 = Calendar.getInstance();
        startTime1.set(12, 2);
        startTime1.set(13, 0);
        startTime1.set(14, 0);
        Calendar endTime1 = Calendar.getInstance();
        endTime1.setTime(startTime1.getTime());
        endTime1.add(12, 2);
        Calendar startTime2 = Calendar.getInstance();
        startTime2.setTime(startTime1.getTime());
        startTime2.add(11, 1);
        Calendar endTime2 = Calendar.getInstance();
        endTime2.setTime(startTime2.getTime());
        endTime2.add(12, 3);
        Calendar startTime3 = Calendar.getInstance();
        startTime3.setTime(startTime1.getTime());
        startTime3.add(11, 1);
        startTime3.set(12, 20);
        Calendar endTime3 = Calendar.getInstance();
        endTime3.setTime(startTime3.getTime());
        endTime3.add(12, 5);
        LocalTask task1 = new LocalTask("task 1", "Task 1");
        TasksUiPlugin.getTaskList().addTask((ITask)task1);
        InteractionEvent activityEvent1 = this.createTimingEvent(startTime1, endTime1, (ITask)task1);
        InteractionEvent activityEvent2 = this.createTimingEvent(startTime2, endTime2, (ITask)task1);
        InteractionEvent activityEvent3 = this.createTimingEvent(startTime3, endTime3, (ITask)task1);
        ArrayList<InteractionEvent> events = new ArrayList<InteractionEvent>();
        events.add(activityEvent1);
        events.add(activityEvent2);
        events.add(activityEvent3);
        List collapsedEvents = ContextCorePlugin.getContextManager().collapseEventsByHour(events);
        TaskActivityTimingTest.assertEquals((int)2, (int)collapsedEvents.size());
    }

    public void testTaskListManagerInactivity() {
        LocalTask task1 = new LocalTask("task 1", "Task 1");
        TasksUiPlugin.getTaskList().addTask((ITask)task1);
        ScheduledTaskContainer activityThisWeek = new ScheduledTaskContainer(TasksUiPlugin.getTaskActivityManager(), (DateRange)TaskActivityUtil.getCurrentWeek());
        TaskActivityTimingTest.assertNotNull((Object)activityThisWeek);
        TaskActivityTimingTest.assertEquals((int)0, (int)activityThisWeek.getChildren().size());
        InteractionEvent event1 = new InteractionEvent(InteractionEvent.Kind.SELECTION, "structureKind", task1.getHandleIdentifier(), "originId", "navigatedRelation", "activated", 2.0f, activityThisWeek.getStart().getTime(), activityThisWeek.getStart().getTime());
        InteractionEvent event2 = new InteractionEvent(InteractionEvent.Kind.SELECTION, "structureKind", task1.getHandleIdentifier(), "originId", "navigatedRelation", "deactivated", 2.0f, activityThisWeek.getEnd().getTime(), activityThisWeek.getEnd().getTime());
        Calendar activityStart = Calendar.getInstance();
        Calendar activityEnd = Calendar.getInstance();
        activityEnd.setTimeInMillis(activityStart.getTimeInMillis());
        activityEnd.add(11, 1);
        InteractionEvent activityEvent = this.createTimingEvent(activityStart, activityEnd, (ITask)task1);
        this.activityMonitor.parseInteractionEvent(event1, false);
        this.activityMonitor.parseInteractionEvent(activityEvent, false);
        this.activityMonitor.parseInteractionEvent(event2, false);
        long expectedTotalTime = activityEnd.getTime().getTime() - activityStart.getTime().getTime();
        TaskActivityTimingTest.assertEquals((long)expectedTotalTime, (long)TasksUiPlugin.getTaskActivityManager().getElapsedTime((ITask)task1));
    }

    public void testElapsedSameAfterRead() throws Exception {
        Calendar startTime1 = Calendar.getInstance();
        startTime1.set(12, 2);
        startTime1.set(13, 0);
        startTime1.set(14, 0);
        Calendar endTime1 = Calendar.getInstance();
        endTime1.setTime(startTime1.getTime());
        endTime1.add(12, 2);
        Calendar startTime2 = Calendar.getInstance();
        startTime2.setTime(startTime1.getTime());
        startTime2.add(11, 1);
        startTime2.set(12, 2);
        startTime2.set(13, 0);
        startTime2.set(14, 0);
        Calendar endTime2 = Calendar.getInstance();
        endTime2.setTime(startTime2.getTime());
        endTime2.add(12, 3);
        Calendar startTime3 = Calendar.getInstance();
        startTime3.setTime(startTime1.getTime());
        startTime3.add(11, 1);
        startTime3.set(12, 20);
        startTime3.set(13, 0);
        startTime3.set(14, 0);
        Calendar endTime3 = Calendar.getInstance();
        endTime3.setTime(startTime3.getTime());
        endTime3.add(12, 5);
        LocalTask task1 = new LocalTask("task 1", "Task 1");
        TasksUiPlugin.getTaskList().addTask((ITask)task1);
        TasksUiPlugin.getTaskActivityManager().activateTask((ITask)task1);
        InteractionContext metaContext = ContextCorePlugin.getContextManager().getActivityMetaContext();
        metaContext.reset();
        TaskActivityTimingTest.assertEquals((int)0, (int)metaContext.getInteractionHistory().size());
        InteractionEvent activityEvent1 = this.createTimingEvent(startTime1, endTime1, (ITask)task1);
        InteractionEvent activityEvent2 = this.createTimingEvent(startTime2, endTime2, (ITask)task1);
        InteractionEvent activityEvent3 = this.createTimingEvent(startTime3, endTime3, (ITask)task1);
        metaContext.parseEvent(activityEvent1);
        this.activityMonitor.parseInteractionEvent(activityEvent1, false);
        metaContext.parseEvent(activityEvent2);
        this.activityMonitor.parseInteractionEvent(activityEvent2, false);
        metaContext.parseEvent(activityEvent3);
        this.activityMonitor.parseInteractionEvent(activityEvent3, false);
        TaskActivityTimingTest.assertEquals((long)600000L, (long)TasksUiPlugin.getTaskActivityManager().getElapsedTime((ITask)task1));
        TaskActivityTimingTest.assertEquals((long)120000L, (long)this.activityManager.getElapsedTime((ITask)task1, startTime1, endTime1));
        TaskActivityTimingTest.assertEquals((long)480000L, (long)this.activityManager.getElapsedTime((ITask)task1, startTime2, endTime2));
        TasksUi.getTaskActivityManager().deactivateActiveTask();
        TaskActivityTimingTest.assertEquals((int)4, (int)ContextCorePlugin.getContextManager().getActivityMetaContext().getInteractionHistory().size());
        TestFixture.saveNow();
        ContextCorePlugin.getContextManager().saveActivityMetaContext();
        ContextCorePlugin.getContextManager().getActivityMetaContext().reset();
        TaskActivityTimingTest.assertEquals((int)0, (int)ContextCorePlugin.getContextManager().getActivityMetaContext().getInteractionHistory().size());
        this.activityMonitor.reloadActivityTime();
        TaskActivityTimingTest.assertEquals((long)0L, (long)this.activityManager.getElapsedTime((ITask)task1));
        TaskActivityTimingTest.assertEquals((long)0L, (long)this.activityManager.getElapsedTime((ITask)task1, startTime1, endTime1));
        TaskActivityTimingTest.assertEquals((long)0L, (long)this.activityManager.getElapsedTime((ITask)task1, startTime2, endTime2));
        ContextCorePlugin.getContextManager().loadActivityMetaContext();
        TaskActivityTimingTest.assertEquals((int)3, (int)ContextCorePlugin.getContextManager().getActivityMetaContext().getInteractionHistory().size());
        this.activityMonitor.reloadActivityTime();
        startTime1 = Calendar.getInstance();
        startTime1.set(12, 0);
        startTime1.set(13, 0);
        startTime1.set(14, 0);
        TaskActivityTimingTest.assertEquals((long)600000L, (long)this.activityManager.getElapsedTime((ITask)task1));
        TaskActivityTimingTest.assertEquals((long)120000L, (long)this.activityManager.getElapsedTime((ITask)task1, startTime1, endTime1));
        TaskActivityTimingTest.assertEquals((long)480000L, (long)this.activityManager.getElapsedTime((ITask)task1, startTime2, endTime2));
    }

    public void testLegacyTimingMigration() {
        LocalTask task1 = new LocalTask("task 1", "Task 1");
        TasksUiPlugin.getTaskList().addTask((ITask)task1);
        Date time1 = new Date(1150007053171L);
        Date time2 = new Date(1150007263468L);
        Date time3 = new Date(1150021535953L);
        Date time4 = new Date(1150021658500L);
        Date time5 = new Date(1150031089250L);
        Date time6 = new Date(1150031111578L);
        Date time7 = new Date(1150031111578L);
        String task1handle = task1.getHandleIdentifier();
        InteractionEvent event1 = new InteractionEvent(InteractionEvent.Kind.SELECTION, "structureKind", task1handle, "originId", "navigatedRelation", "activated", 2.0f, time1, time1);
        InteractionEvent event2 = new InteractionEvent(InteractionEvent.Kind.SELECTION, "structureKind", "attention", "originId", "navigatedRelation", "activated", 2.0f, time1, time2);
        InteractionEvent event3 = new InteractionEvent(InteractionEvent.Kind.SELECTION, "structureKind", "attention", "originId", "navigatedRelation", "activated", 2.0f, time3, time4);
        InteractionEvent event5 = new InteractionEvent(InteractionEvent.Kind.SELECTION, "structureKind", "attention", "originId", "navigatedRelation", "activated", 2.0f, time5, time6);
        InteractionEvent event7 = new InteractionEvent(InteractionEvent.Kind.SELECTION, "structureKind", task1handle, "originId", "navigatedRelation", "deactivated", 2.0f, time7, time7);
        LegacyActivityAdaptor legacyAdaptor = new LegacyActivityAdaptor();
        this.activityMonitor.parseInteractionEvent(legacyAdaptor.parseInteractionEvent(event1), false);
        this.activityMonitor.parseInteractionEvent(legacyAdaptor.parseInteractionEvent(event2), false);
        this.activityMonitor.parseInteractionEvent(legacyAdaptor.parseInteractionEvent(event3), false);
        this.activityMonitor.parseInteractionEvent(legacyAdaptor.parseInteractionEvent(event5), false);
        this.activityMonitor.parseInteractionEvent(legacyAdaptor.parseInteractionEvent(event7), false);
        long expectedTotalTime = time6.getTime() - time5.getTime() + time4.getTime() - time3.getTime() + time2.getTime() - time1.getTime();
        TaskActivityTimingTest.assertEquals((long)expectedTotalTime, (long)TasksUiPlugin.getTaskActivityManager().getElapsedTime((ITask)task1));
    }

    public void testScheduledTaskContainer() {
        Calendar startDate = Calendar.getInstance();
        startDate.setTimeInMillis(1000L);
        Calendar endDate = Calendar.getInstance();
        endDate.setTimeInMillis(2000L);
        LocalTask task1 = new LocalTask("task 1", "Task 1");
        LocalTask task2 = new LocalTask("task 2", "Task 2");
        TasksUiPlugin.getTaskList().addTask((ITask)task1);
        TasksUiPlugin.getTaskList().addTask((ITask)task2);
        InteractionEvent event1 = new InteractionEvent(InteractionEvent.Kind.ATTENTION, "timing", task1.getHandleIdentifier(), "org.eclipse.ui.workbench", null, "added", 2.0f, startDate.getTime(), endDate.getTime());
        InteractionEvent event2 = new InteractionEvent(InteractionEvent.Kind.ATTENTION, "timing", task2.getHandleIdentifier(), "org.eclipse.ui.workbench", null, "added", 2.0f, startDate.getTime(), endDate.getTime());
        this.activityMonitor.parseInteractionEvent(event1, false);
        this.activityMonitor.parseInteractionEvent(event2, false);
        Calendar start = TaskActivityUtil.getCalendar();
        start.setTimeInMillis(0L);
        Calendar end = TaskActivityUtil.getCalendar();
        end.add(12, 2);
        Set tasks = TasksUiPlugin.getTaskActivityManager().getActiveTasks(start, end);
        TaskActivityTimingTest.assertEquals((int)2, (int)tasks.size());
        TaskActivityTimingTest.assertEquals((long)1000L, (long)TasksUiPlugin.getTaskActivityManager().getElapsedTime((ITask)task1));
        TaskActivityTimingTest.assertEquals((long)1000L, (long)TasksUiPlugin.getTaskActivityManager().getElapsedTime((ITask)task2));
    }

    private Calendar createCalendar() {
        Calendar startTime1 = Calendar.getInstance();
        startTime1.add(10, -1);
        startTime1.set(12, 10);
        return startTime1;
    }

    private Calendar createCalendar(Calendar time, int secondsToAdd) {
        Calendar newTime = Calendar.getInstance();
        newTime.setTimeInMillis(time.getTimeInMillis());
        newTime.add(13, secondsToAdd);
        return newTime;
    }

    private InteractionEvent createTimingEvent(Calendar startTime, Calendar endTime, ITask task) {
        return this.createTimingEvent(startTime, endTime, task.getHandleIdentifier());
    }

    private InteractionEvent createTimingEvent(Calendar startTime, Calendar endTime, String handle) {
        return new InteractionEvent(InteractionEvent.Kind.ATTENTION, "timing", handle, "org.eclipse.ui.workbench", null, "added", 1.0f, startTime.getTime(), endTime.getTime());
    }
}

