/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.context.tasks.tests;

import java.util.Calendar;
import junit.framework.TestCase;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.mylyn.internal.context.core.ContextCorePlugin;
import org.eclipse.mylyn.internal.context.core.InteractionContext;
import org.eclipse.mylyn.internal.tasks.core.RepositoryQuery;
import org.eclipse.mylyn.internal.tasks.core.TaskList;
import org.eclipse.mylyn.internal.tasks.ui.RefactorRepositoryUrlOperation;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.monitor.core.InteractionEvent;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.tests.TaskTestUtil;
import org.eclipse.mylyn.tasks.tests.connector.MockRepositoryQuery;
import org.eclipse.mylyn.tasks.tests.connector.MockTask;
import org.junit.Before;
import org.junit.Test;

public class RefactorRepositoryUrlOperationTest
extends TestCase {
    private TaskList taskList;

    @Before
    public void setUp() throws Exception {
        this.taskList = TasksUiPlugin.getTaskList();
        TaskTestUtil.resetTaskList();
    }

    @Test
    public void testMigrateQueryUrlHandles() throws Exception {
        MockRepositoryQuery query = new MockRepositoryQuery("mquery");
        query.setRepositoryUrl("http://foo.bar");
        query.setUrl("http://foo.bar/b");
        this.taskList.addQuery((RepositoryQuery)query);
        RefactorRepositoryUrlOperationTest.assertTrue((this.taskList.getRepositoryQueries("http://foo.bar").size() > 0 ? 1 : 0) != 0);
        new RefactorRepositoryUrlOperation("http://foo.bar", "http://bar.baz").run((IProgressMonitor)new NullProgressMonitor());
        RefactorRepositoryUrlOperationTest.assertTrue((this.taskList.getRepositoryQueries("http://foo.bar").size() == 0 ? 1 : 0) != 0);
        RefactorRepositoryUrlOperationTest.assertTrue((this.taskList.getRepositoryQueries("http://bar.baz").size() > 0 ? 1 : 0) != 0);
        IRepositoryQuery changedQuery = (IRepositoryQuery)this.taskList.getRepositoryQueries("http://bar.baz").iterator().next();
        RefactorRepositoryUrlOperationTest.assertEquals((String)"http://bar.baz/b", (String)changedQuery.getUrl());
    }

    @Test
    public void testRefactorMetaContextHandles() throws Exception {
        Calendar now = Calendar.getInstance();
        String firstUrl = "http://repository1.com/bugs";
        String secondUrl = "http://repository2.com/bugs";
        MockTask task1 = new MockTask(firstUrl, "1");
        MockTask task2 = new MockTask(firstUrl, "2");
        this.taskList.addTask((ITask)task1);
        this.taskList.addTask((ITask)task2);
        Calendar startDate = Calendar.getInstance();
        startDate.setTimeInMillis(now.getTimeInMillis());
        Calendar endDate = Calendar.getInstance();
        endDate.setTimeInMillis(now.getTimeInMillis());
        endDate.add(12, 5);
        Calendar startDate2 = Calendar.getInstance();
        startDate2.setTimeInMillis(now.getTimeInMillis());
        startDate2.add(12, 15);
        Calendar endDate2 = Calendar.getInstance();
        endDate2.setTimeInMillis(now.getTimeInMillis());
        endDate2.add(12, 25);
        ContextCorePlugin.getContextManager().resetActivityMetaContext();
        InteractionContext metaContext = ContextCorePlugin.getContextManager().getActivityMetaContext();
        RefactorRepositoryUrlOperationTest.assertEquals((int)0, (int)metaContext.getInteractionHistory().size());
        ContextCorePlugin.getContextManager().processActivityMetaContextEvent(new InteractionEvent(InteractionEvent.Kind.ATTENTION, "timing", task1.getHandleIdentifier(), "origin", null, "added", 1.0f, startDate.getTime(), endDate.getTime()));
        ContextCorePlugin.getContextManager().processActivityMetaContextEvent(new InteractionEvent(InteractionEvent.Kind.ATTENTION, "timing", task2.getHandleIdentifier(), "origin", null, "added", 1.0f, startDate2.getTime(), endDate2.getTime()));
        RefactorRepositoryUrlOperationTest.assertEquals((int)2, (int)metaContext.getInteractionHistory().size());
        RefactorRepositoryUrlOperationTest.assertEquals((long)300000L, (long)TasksUiPlugin.getTaskActivityManager().getElapsedTime((ITask)task1));
        RefactorRepositoryUrlOperationTest.assertEquals((long)600000L, (long)TasksUiPlugin.getTaskActivityManager().getElapsedTime((ITask)task2));
        new RefactorRepositoryUrlOperation(firstUrl, secondUrl).run((IProgressMonitor)new NullProgressMonitor());
        metaContext = ContextCorePlugin.getContextManager().getActivityMetaContext();
        RefactorRepositoryUrlOperationTest.assertEquals((int)2, (int)metaContext.getInteractionHistory().size());
        RefactorRepositoryUrlOperationTest.assertEquals((long)300000L, (long)TasksUiPlugin.getTaskActivityManager().getElapsedTime((ITask)new MockTask(secondUrl, "1")));
        RefactorRepositoryUrlOperationTest.assertEquals((long)600000L, (long)TasksUiPlugin.getTaskActivityManager().getElapsedTime((ITask)new MockTask(secondUrl, "2")));
        RefactorRepositoryUrlOperationTest.assertEquals((String)(String.valueOf(secondUrl) + "-1"), (String)((InteractionEvent)metaContext.getInteractionHistory().get(0)).getStructureHandle());
    }
}

