/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.context.tasks.tests;

import java.util.Collections;
import junit.framework.TestCase;
import org.eclipse.mylyn.context.sdk.util.ContextTestUtil;
import org.eclipse.mylyn.internal.context.ui.ContextUiPlugin;
import org.eclipse.mylyn.internal.tasks.core.TaskTask;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.actions.DeleteAction;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.tests.TaskTestUtil;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.tests.util.TestFixture;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class PerspectiveRestoreTest
extends TestCase {
    private static final String ID_RESOURCE_PERSPECTIVE = "org.eclipse.ui.resourcePerspective";
    private static final String ID_PLANNING_PERSPECTIVE = "org.eclipse.mylyn.tasks.ui.perspectives.planning";
    private boolean previousSetting;

    @Before
    public void setUp() throws Exception {
        ContextTestUtil.triggerContextUiLazyStart();
        TestFixture.resetTaskListAndRepositories();
        this.previousSetting = ContextUiPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.mylyn.ide.ui.perspectives.auto.manage");
        ContextUiPlugin.getDefault().getPreferenceStore().setValue("org.eclipse.mylyn.ide.ui.perspectives.auto.manage", true);
    }

    @After
    public void tearDown() throws Exception {
        ContextUiPlugin.getDefault().getPreferenceStore().setValue("org.eclipse.mylyn.ide.ui.perspectives.auto.manage", this.previousSetting);
        TestFixture.resetTaskListAndRepositories();
    }

    @Test
    public void testHasPlanningAndResourcePerspective() throws Exception {
        PlatformUI.getWorkbench().showPerspective(ID_RESOURCE_PERSPECTIVE, this.getWorkbenchWindow());
        PerspectiveRestoreTest.assertEquals((String)ID_RESOURCE_PERSPECTIVE, (String)this.getActivePerspective());
        PlatformUI.getWorkbench().showPerspective(ID_PLANNING_PERSPECTIVE, this.getWorkbenchWindow());
        PerspectiveRestoreTest.assertEquals((String)ID_PLANNING_PERSPECTIVE, (String)this.getActivePerspective());
    }

    @Test
    public void testHasActiveWorkbenchWindow() throws Exception {
        PerspectiveRestoreTest.assertNotNull((String)"No active workbench window. Following tests are likely to fail.", (Object)PlatformUI.getWorkbench().getActiveWorkbenchWindow());
    }

    @Test
    public void testRestorePerspective() throws Exception {
        PlatformUI.getWorkbench().showPerspective(ID_RESOURCE_PERSPECTIVE, this.getWorkbenchWindow());
        PerspectiveRestoreTest.assertEquals((String)ID_RESOURCE_PERSPECTIVE, (String)this.getActivePerspective());
        TaskTask task = TaskTestUtil.createMockTask((String)"testRestorePerspective");
        TasksUi.getTaskActivityManager().activateTask((ITask)task);
        PerspectiveRestoreTest.assertEquals((String)ID_RESOURCE_PERSPECTIVE, (String)this.getActivePerspective());
        PlatformUI.getWorkbench().showPerspective(ID_PLANNING_PERSPECTIVE, this.getWorkbenchWindow());
        PerspectiveRestoreTest.assertEquals((String)ID_PLANNING_PERSPECTIVE, (String)this.getActivePerspective());
        TasksUi.getTaskActivityManager().deactivateActiveTask();
        PerspectiveRestoreTest.assertEquals((String)ID_RESOURCE_PERSPECTIVE, (String)this.getActivePerspective());
        TasksUi.getTaskActivityManager().activateTask((ITask)task);
        PerspectiveRestoreTest.assertEquals((String)ID_PLANNING_PERSPECTIVE, (String)this.getActivePerspective());
    }

    @Test
    public void testRecreateTask() throws Exception {
        PlatformUI.getWorkbench().showPerspective(ID_RESOURCE_PERSPECTIVE, this.getWorkbenchWindow());
        TaskTask task = TaskTestUtil.createMockTask((String)"1");
        TasksUiPlugin.getTaskList().addTask((ITask)task);
        TasksUi.getTaskActivityManager().activateTask((ITask)task);
        PlatformUI.getWorkbench().showPerspective(ID_PLANNING_PERSPECTIVE, this.getWorkbenchWindow());
        TasksUiPlugin.getTaskActivityManager().deactivateActiveTask();
        DeleteAction.performDeletion(Collections.singleton(task));
        PerspectiveRestoreTest.assertEquals((String)ID_RESOURCE_PERSPECTIVE, (String)this.getActivePerspective());
        task = TaskTestUtil.createMockTask((String)"1");
        TasksUi.getTaskActivityManager().activateTask((ITask)task);
        PerspectiveRestoreTest.assertEquals((String)ID_RESOURCE_PERSPECTIVE, (String)this.getActivePerspective());
    }

    private IWorkbenchWindow getWorkbenchWindow() {
        IWorkbenchWindow window = ContextUiPlugin.getPerspectiveStateParticipant().getWorkbenchWindow();
        PerspectiveRestoreTest.assertNotNull((Object)window);
        return window;
    }

    private String getActivePerspective() {
        return this.getWorkbenchWindow().getActivePage().getPerspective().getId();
    }
}

